<?php

namespace Modules\Superadmin\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class OfflinePaymentDeclinedNotification extends Notification
{
    use Queueable;

    /**
     * @var object
     */
    public $subscription;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($subscription)
    {
        $this->subscription = $subscription;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        $channels = ['mail'];
        
        // Add WhatsApp channel if enabled
        if (config('services.whatsapp.enabled')) {
            $channels[] = \Modules\Superadmin\Notifications\Channels\WhatsAppChannel::class;
        }
        
        return $channels;
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Offline Payment Declined')
            ->greeting('Hello ' . $notifiable->user_full_name . ',')
            ->line('We regret to inform you that your offline payment has been declined.')
            ->line('**Subscription Details:**')
            ->line('• Package: ' . $this->subscription->package->name)
            ->line('• Price: ' . $this->subscription->package_price_currency . ' ' . number_format($this->subscription->package_price, 2))
            ->line('Please contact our support team if you have any questions or would like to resubmit your payment with the correct information.')
            ->line('You can also try other payment methods available on our platform.')
            ->line('Thank you for your understanding.');
    }

    /**
     * Get the WhatsApp representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return string
     */
    public function toWhatsApp($notifiable)
    {
        $message = "❌ *Payment Declined*\n\n";
        $message .= "Hello {$notifiable->user_full_name},\n\n";
        $message .= "We regret to inform you that your offline payment has been declined.\n\n";
        $message .= "*Subscription Details:*\n";
        $message .= "• Package: {$this->subscription->package->name}\n";
        $message .= "• Price: {$this->subscription->package_price_currency} " . number_format($this->subscription->package_price, 2) . "\n\n";
        $message .= "Please contact our support team if you have any questions or would like to resubmit your payment with the correct information.\n\n";
        $message .= "You can also try other payment methods available on our platform.\n\n";
        $message .= "_Thank you for your understanding._\n\n";
        $message .= "_JEB Business Management System Team_";

        return $message;
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
