<?php

namespace Modules\Superadmin\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class OfflinePaymentSubmittedNotification extends Notification
{
    use Queueable;

    /**
     * @var object
     */
    public $subscription;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($subscription)
    {
        $this->subscription = $subscription;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        $channels = ['mail'];
        
        // Add WhatsApp channel if enabled
        if (config('services.whatsapp.enabled')) {
            $channels[] = \Modules\Superadmin\Notifications\Channels\WhatsAppChannel::class;
        }
        
        return $channels;
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Offline Payment Submitted Successfully')
            ->greeting('Hello ' . $notifiable->user_full_name . ',')
            ->line('Your offline payment has been submitted successfully and is pending approval.')
            ->line('**Subscription Details:**')
            ->line('• Package: ' . $this->subscription->package->name)
            ->line('• Price: ' . $this->subscription->package_price_currency . ' ' . number_format($this->subscription->package_price, 2))
            ->line('Our team will review your payment and activate your subscription shortly.')
            ->line('You will receive a confirmation once your payment is approved.')
            ->line('Thank you for choosing JEB Business Management System!');
    }

    /**
     * Get the WhatsApp representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return string
     */
    public function toWhatsApp($notifiable)
    {
        $message = "✅ *Payment Submitted Successfully!*\n\n";
        $message .= "Hello {$notifiable->user_full_name},\n\n";
        $message .= "Your offline payment has been submitted successfully and is pending approval.\n\n";
        $message .= "*Subscription Details:*\n";
        $message .= "• Package: {$this->subscription->package->name}\n";
        $message .= "• Price: {$this->subscription->package_price_currency} " . number_format($this->subscription->package_price, 2) . "\n\n";
        $message .= "Our team will review your payment and activate your subscription shortly. ";
        $message .= "You will receive a confirmation once your payment is approved. 🎉\n\n";
        $message .= "_Thank you for choosing JEB Business Management System!_";

        return $message;
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
