<?php

namespace Modules\Superadmin\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Modules\Superadmin\Notifications\Channels\WhatsAppChannel;

class PasswordUpdateNotification extends Notification
{
    use Queueable;

    protected $password;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($password)
    {
        $this->password = $password;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        $channels = ['mail'];
        
        if (config('services.whatsapp.enabled', false)) {
            $channels[] = WhatsAppChannel::class;
        }
        
        return $channels;
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->subject(__('superadmin::lang.password_updated'))
                    ->greeting(__('restaurant.hello_name', ['name' => $notifiable->first_name]))
                    ->line(__('superadmin::lang.your_password_updated_successfully'))
                    ->line(__('superadmin::lang.your_new_password_is', ['password' => $this->password]))
                    ->action(__('lang_v1.login'), route('login'));
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }

    /**
     * Get the WhatsApp representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return string
     */
    public function toWhatsApp($notifiable)
    {
        $message = "🔐 *Password Updated*\n\n";
        $message .= "Hello {$notifiable->first_name},\n\n";
        $message .= "Your password has been updated successfully by admin.\n\n";
        $message .= "*Your new password is:* {$this->password}\n\n";
        $message .= "⚠️ Please keep this secure and change it after logging in.\n\n";
        $message .= "If you didn't authorize this change, please contact support immediately.\n\n";
        $message .= "Updated: " . now()->format('M d, Y h:i A') . "\n\n";
        $message .= "_" . config('app.name') . " Team_";
        
        return $message;
    }
}
