<?php

namespace Modules\Superadmin\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Modules\Superadmin\Notifications\Channels\WhatsAppChannel;

class SubscriptionActivatedNotification extends Notification
{
    use Queueable;

    protected $subscription;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($subscription)
    {
        $this->subscription = $subscription;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        $channels = ['mail'];
        
        if (config('services.whatsapp.enabled', false)) {
            $channels[] = WhatsAppChannel::class;
        }
        
        return $channels;
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                ->subject('Subscription Activated!')
                ->greeting('Hello ' . $notifiable->user_full_name . '!')
                ->line('Your subscription has been activated successfully.')
                ->line('Package: ' . $this->subscription->package->name)
                ->line('Start Date: ' . $this->subscription->start_date->format('M d, Y'))
                ->line('End Date: ' . $this->subscription->end_date->format('M d, Y'))
                ->line('Thank you for your payment!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }

    /**
     * Get the WhatsApp representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return string
     */
    public function toWhatsApp($notifiable)
    {
        $message = "✅ *Subscription Activated!*\n\n";
        $message .= "Hello {$notifiable->user_full_name},\n\n";
        $message .= "Great news! Your subscription has been activated successfully.\n\n";
        $message .= "*Subscription Details:*\n";
        $message .= "• Package: {$this->subscription->package->name}\n";
        $message .= "• Start Date: " . $this->subscription->start_date->format('M d, Y') . "\n";
        $message .= "• End Date: " . $this->subscription->end_date->format('M d, Y') . "\n\n";
        $message .= "You can now access all features of your subscription! 🎉\n\n";
        $message .= "_" . config('app.name') . " Team_";
        
        return $message;
    }
}
