<?php

namespace Modules\Superadmin\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Modules\Superadmin\Notifications\Channels\WhatsAppChannel;

class SubscriptionOfflinePaymentActivationConfirmation extends Notification
{
    use Queueable;

    protected $business;
    protected $package;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($business, $package)
    {
        $this->business = $business;
        $this->package = $package;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        $channels = ['mail'];
        
        if (config('services.whatsapp.enabled', false)) {
            $channels[] = WhatsAppChannel::class;
        }
        
        return $channels;
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $details = 'Business: '.$this->business->name.', Package: '.$this->package->name.', Price: '.$this->package->price;

        return (new MailMessage)
                ->greeting('Hello!')
                ->line('Please confirm Offline Payment for subscription')
                ->line($details)
                ->line('To confirm go to superadmin subscriptions tab and confirm it.');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }

    /**
     * Get the WhatsApp representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return string
     */
    public function toWhatsApp($notifiable)
    {
        $message = "⚠️ *Offline Payment Pending Approval*\n\n";
        $message .= "A business has submitted an offline payment for subscription.\n\n";
        $message .= "*Details:*\n";
        $message .= "• Business: {$this->business->name}\n";
        $message .= "• Owner: {$this->business->owner->user_full_name}\n";
        $message .= "• Package: {$this->package->name}\n";
        $message .= "• Price: {$this->package->price}\n\n";
        $message .= "📋 Please login to admin panel to review and approve the payment.\n\n";
        $message .= "_" . config('app.name') . " Admin Panel_";
        
        return $message;
    }
}
