@extends('layouts.app')
@section('title', 'Manual Verification')

@section('content')
<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Manual Business Verification</h4>
            <h6>Manually verify business email and WhatsApp</h6>
        </div>
        <div class="page-btn">
            <a href="{{ action([\Modules\Superadmin\Http\Controllers\BusinessController::class, 'index']) }}" class="btn btn-secondary">
                <i class="fa fa-arrow-left"></i> Back to Businesses
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-lg-8 offset-lg-2">
                    <div class="alert alert-info">
                        <i class="fa fa-info-circle"></i> <strong>Note:</strong> Manual verification should only be used when automatic verification fails or for trusted businesses.
                    </div>

                    <div class="business-info mb-4">
                        <h5 class="mb-3">Business Information</h5>
                        <table class="table table-bordered">
                            <tr>
                                <th width="30%">Business Name</th>
                                <td>{{ $business->name }}</td>
                            </tr>
                            <tr>
                                <th>Owner Name</th>
                                <td>{{ $business->owner->first_name ?? '' }} {{ $business->owner->last_name ?? '' }}</td>
                            </tr>
                            <tr>
                                <th>Email</th>
                                <td>
                                    {{ $business->owner->email }}
                                    @if($business->email_verified_at)
                                        <span class="badge badge-success"><i class="fa fa-check"></i> Verified</span>
                                    @else
                                        <span class="badge badge-warning"><i class="fa fa-clock-o"></i> Pending</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>WhatsApp Number</th>
                                <td>
                                    {{ $business->locations()->first()->mobile ?? $business->owner->mobile ?? 'N/A' }}
                                    @if($business->whatsapp_verified_at)
                                        <span class="badge badge-success"><i class="fa fa-check"></i> Verified</span>
                                    @else
                                        <span class="badge badge-warning"><i class="fa fa-clock-o"></i> Pending</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    @if($business->is_active)
                                        <span class="badge badge-success">Active</span>
                                    @else
                                        <span class="badge badge-danger">Inactive</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Registered Date</th>
                                <td>{{ $business->created_at->format('M d, Y H:i') }}</td>
                            </tr>
                        </table>
                    </div>

                    <form id="manual-verify-form" method="POST" action="{{ route('superadmin.business.manual-verify', $business->id) }}">
                        @csrf
                        <div class="card border-primary">
                            <div class="card-header bg-primary text-white">
                                <h5 class="mb-0"><i class="fa fa-check-circle"></i> Manual Verification Options</h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" name="verify_email" value="1" {{ $business->email_verified_at ? 'checked disabled' : '' }}>
                                        <span class="custom-control-label">
                                            <strong>Verify Email Address</strong>
                                            <br><small class="text-muted">Mark email as verified manually</small>
                                        </span>
                                    </label>
                                </div>

                                <div class="form-group">
                                    <label class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" name="verify_whatsapp" value="1" {{ $business->whatsapp_verified_at ? 'checked disabled' : '' }}>
                                        <span class="custom-control-label">
                                            <strong>Verify WhatsApp Number</strong>
                                            <br><small class="text-muted">Mark WhatsApp as verified manually</small>
                                        </span>
                                    </label>
                                </div>

                                <div class="form-group">
                                    <label for="admin_notes">Admin Notes <span class="text-danger">*</span></label>
                                    <textarea class="form-control" name="admin_notes" id="admin_notes" rows="3" required placeholder="Enter reason for manual verification..."></textarea>
                                    <small class="text-muted">This note will be logged for audit purposes</small>
                                </div>

                                @if(!$business->is_active)
                                    <div class="form-group">
                                        <label class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" name="activate_business" value="1">
                                            <span class="custom-control-label">
                                                <strong>Activate Business</strong>
                                                <br><small class="text-muted">Activate the business account immediately</small>
                                            </span>
                                        </label>
                                    </div>
                                @endif
                            </div>
                        </div>

                        <div class="text-center mt-4">
                            <button type="submit" class="btn btn-primary btn-lg px-5">
                                <i class="fa fa-check"></i> Verify Business
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('javascript')
<script>
$(document).ready(function() {
    $('#manual-verify-form').submit(function(e) {
        e.preventDefault();
        
        const verify_email = $('input[name="verify_email"]:checked').length;
        const verify_whatsapp = $('input[name="verify_whatsapp"]:checked').length;
        const admin_notes = $('textarea[name="admin_notes"]').val().trim();
        
        if (!verify_email && !verify_whatsapp) {
            swal('Error', 'Please select at least one verification option', 'error');
            return;
        }
        
        if (!admin_notes) {
            swal('Error', 'Please enter admin notes', 'error');
            return;
        }
        
        swal({
            title: 'Are you sure?',
            text: 'This will manually verify the selected items for this business.',
            icon: 'warning',
            buttons: ['Cancel', 'Yes, Verify'],
            dangerMode: false,
        }).then((confirmed) => {
            if (confirmed) {
                const form = $(this);
                const btn = form.find('button[type="submit"]');
                btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Verifying...');
                
                $.ajax({
                    url: form.attr('action'),
                    type: 'POST',
                    data: form.serialize(),
                    success: function(response) {
                        if (response.success) {
                            swal('Success', response.msg, 'success').then(() => {
                                window.location.href = '{{ action([\Modules\Superadmin\Http\Controllers\BusinessController::class, 'index']) }}';
                            });
                        } else {
                            swal('Error', response.msg, 'error');
                            btn.prop('disabled', false).html('<i class="fa fa-check"></i> Verify Business');
                        }
                    },
                    error: function() {
                        swal('Error', 'Something went wrong. Please try again.', 'error');
                        btn.prop('disabled', false).html('<i class="fa fa-check"></i> Verify Business');
                    }
                });
            }
        });
    });
});
</script>
@endsection
