@extends('layouts.app')

@section('title', __('superadmin::lang.create_ticket_for_business'))

@section('content')

<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>@lang('superadmin::lang.create_ticket_for_business')</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ action([\App\Http\Controllers\HomeController::class, 'index']) }}">@lang('lang_v1.home')</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('superadmin.support-tickets.index') }}">@lang('superadmin::lang.support_tickets')</a></li>
                    <li class="breadcrumb-item active">@lang('superadmin::lang.create_ticket_for_business')</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">@lang('superadmin::lang.ticket_details')</h3>
                    </div>
                    
                    <form action="{{ route('superadmin.support-tickets.store') }}" method="POST" enctype="multipart/form-data" id="create_ticket_form">
                        @csrf
                        
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="business_id">@lang('superadmin::lang.select_business') <span class="text-danger">*</span></label>
                                        <select name="business_id" id="business_id" class="form-control select2" required>
                                            <option value="">@lang('superadmin::lang.please_select')</option>
                                            @foreach($businesses as $business)
                                                <option value="{{ $business->id }}" {{ old('business_id') == $business->id ? 'selected' : '' }}>
                                                    {{ $business->name }} ({{ $business->owner->user_full_name ?? 'N/A' }})
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('business_id')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="subject">@lang('superadmin::lang.subject') <span class="text-danger">*</span></label>
                                        <input type="text" name="subject" id="subject" class="form-control" value="{{ old('subject') }}" required maxlength="255">
                                        @error('subject')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="category">@lang('superadmin::lang.category') <span class="text-danger">*</span></label>
                                        <select name="category" id="category" class="form-control" required>
                                            <option value="">@lang('superadmin::lang.select_category')</option>
                                            @foreach($categories as $key => $category)
                                                <option value="{{ $key }}" {{ old('category') == $key ? 'selected' : '' }}>{{ $category }}</option>
                                            @endforeach
                                        </select>
                                        @error('category')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="priority">@lang('superadmin::lang.priority') <span class="text-danger">*</span></label>
                                        <select name="priority" id="priority" class="form-control" required>
                                            <option value="">@lang('superadmin::lang.select_priority')</option>
                                            @foreach($priorities as $key => $priority)
                                                <option value="{{ $key }}" {{ old('priority', 'medium') == $key ? 'selected' : '' }}>{{ $priority }}</option>
                                            @endforeach
                                        </select>
                                        @error('priority')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="description">@lang('superadmin::lang.description') <span class="text-danger">*</span></label>
                                        <textarea name="description" id="description" rows="6" class="form-control" required>{{ old('description') }}</textarea>
                                        @error('description')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                        <small class="form-text text-muted">@lang('superadmin::lang.describe_issue_detail')</small>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="attachments">@lang('superadmin::lang.attachments')</label>
                                        <input type="file" name="attachments[]" id="attachments" class="form-control-file" multiple accept=".jpg,.jpeg,.png,.pdf,.doc,.docx,.xls,.xlsx,.zip">
                                        <small class="form-text text-muted">@lang('superadmin::lang.max_file_size_10mb')</small>
                                        @error('attachments.*')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="alert alert-info">
                                <i class="fas fa-info-circle"></i> @lang('superadmin::lang.ticket_creation_info')
                            </div>
                        </div>

                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> @lang('superadmin::lang.create_ticket')
                            </button>
                            <a href="{{ route('superadmin.support-tickets.index') }}" class="btn btn-default">
                                <i class="fas fa-times"></i> @lang('messages.cancel')
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script>
    $(document).ready(function() {
        $('#business_id').select2({
            placeholder: '@lang("superadmin::lang.please_select")',
            allowClear: true
        });

        // File upload validation
        $('#attachments').on('change', function() {
            let files = this.files;
            let maxSize = 10 * 1024 * 1024; // 10MB
            
            for (let i = 0; i < files.length; i++) {
                if (files[i].size > maxSize) {
                    alert('@lang("superadmin::lang.file_too_large")');
                    $(this).val('');
                    return false;
                }
            }
        });
    });
</script>
@endsection
