@extends('layouts.app')
@section('title', __('superadmin::lang.superadmin') . ' | ' . __('superadmin::lang.support_tickets'))

@section('content')
    @include('superadmin::layouts.nav')
    
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="row">
            <div class="col-md-8">
                <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">
                    @lang('superadmin::lang.manage_support_tickets')
                </h1>
            </div>
            <div class="col-md-4 text-right">
                <a href="{{ action([\Modules\Superadmin\Http\Controllers\SuperadminSupportTicketController::class, 'create']) }}" class="btn btn-primary btn-lg">
                    <i class="fa fa-plus"></i> @lang('superadmin::lang.create_ticket_for_business')
                </a>
            </div>
        </div>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Stats Row -->
        <div class="row">
            <div class="col-lg-2 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3>{{ $stats['total'] }}</h3>
                        <p>@lang('superadmin::lang.total_tickets')</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-ticket"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3>{{ $stats['open'] }}</h3>
                        <p>@lang('superadmin::lang.open')</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-folder-open"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-xs-6">
                <div class="small-box bg-blue">
                    <div class="inner">
                        <h3>{{ $stats['in_progress'] }}</h3>
                        <p>@lang('superadmin::lang.in_progress')</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-spinner"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-xs-6">
                <div class="small-box bg-purple">
                    <div class="inner">
                        <h3>{{ $stats['waiting_customer'] }}</h3>
                        <p>@lang('superadmin::lang.waiting_customer')</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-clock-o"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3>{{ $stats['resolved'] }}</h3>
                        <p>@lang('superadmin::lang.resolved')</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-check"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3>{{ $stats['high_priority'] }}</h3>
                        <p>@lang('superadmin::lang.high_priority')</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-exclamation-triangle"></i>
                    </div>
                </div>
            </div>
        </div>

        @component('components.widget', ['class' => 'box-primary', 'title' => __('superadmin::lang.filter_tickets')])
            <div class="row">
                <div class="col-md-2">
                    <div class="form-group">
                        <label>@lang('superadmin::lang.status'):</label>
                        <select class="form-control" id="status_filter">
                            <option value="all" {{ $status_filter == 'all' ? 'selected' : '' }}>@lang('superadmin::lang.all')</option>
                            <option value="open" {{ $status_filter == 'open' ? 'selected' : '' }}>@lang('superadmin::lang.open')</option>
                            <option value="in_progress" {{ $status_filter == 'in_progress' ? 'selected' : '' }}>@lang('superadmin::lang.in_progress')</option>
                            <option value="waiting_admin" {{ $status_filter == 'waiting_admin' ? 'selected' : '' }}>@lang('superadmin::lang.waiting_admin')</option>
                            <option value="waiting_customer" {{ $status_filter == 'waiting_customer' ? 'selected' : '' }}>@lang('superadmin::lang.waiting_customer')</option>
                            <option value="resolved" {{ $status_filter == 'resolved' ? 'selected' : '' }}>@lang('superadmin::lang.resolved')</option>
                            <option value="closed" {{ $status_filter == 'closed' ? 'selected' : '' }}>@lang('superadmin::lang.closed')</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>@lang('superadmin::lang.priority'):</label>
                        <select class="form-control" id="priority_filter">
                            <option value="all" {{ $priority_filter == 'all' ? 'selected' : '' }}>@lang('superadmin::lang.all')</option>
                            <option value="low" {{ $priority_filter == 'low' ? 'selected' : '' }}>@lang('superadmin::lang.low')</option>
                            <option value="medium" {{ $priority_filter == 'medium' ? 'selected' : '' }}>@lang('superadmin::lang.medium')</option>
                            <option value="high" {{ $priority_filter == 'high' ? 'selected' : '' }}>@lang('superadmin::lang.high')</option>
                            <option value="urgent" {{ $priority_filter == 'urgent' ? 'selected' : '' }}>@lang('superadmin::lang.urgent')</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>@lang('superadmin::lang.category'):</label>
                        <select class="form-control" id="category_filter">
                            <option value="all" {{ $category_filter == 'all' ? 'selected' : '' }}>@lang('superadmin::lang.all')</option>
                            <option value="billing" {{ $category_filter == 'billing' ? 'selected' : '' }}>@lang('superadmin::lang.billing')</option>
                            <option value="technical_support" {{ $category_filter == 'technical_support' ? 'selected' : '' }}>@lang('superadmin::lang.technical_support')</option>
                            <option value="feature_request" {{ $category_filter == 'feature_request' ? 'selected' : '' }}>@lang('superadmin::lang.feature_request')</option>
                            <option value="bug_report" {{ $category_filter == 'bug_report' ? 'selected' : '' }}>@lang('superadmin::lang.bug_report')</option>
                            <option value="account_issue" {{ $category_filter == 'account_issue' ? 'selected' : '' }}>@lang('superadmin::lang.account_issue')</option>
                            <option value="payment_issue" {{ $category_filter == 'payment_issue' ? 'selected' : '' }}>@lang('superadmin::lang.payment_issue')</option>
                            <option value="general_inquiry" {{ $category_filter == 'general_inquiry' ? 'selected' : '' }}>@lang('superadmin::lang.general_inquiry')</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>@lang('superadmin::lang.assigned'):</label>
                        <select class="form-control" id="assigned_filter">
                            <option value="all" {{ $assigned_filter == 'all' ? 'selected' : '' }}>@lang('superadmin::lang.all')</option>
                            <option value="unassigned" {{ $assigned_filter == 'unassigned' ? 'selected' : '' }}>@lang('superadmin::lang.unassigned')</option>
                            <option value="me" {{ $assigned_filter == 'me' ? 'selected' : '' }}>@lang('superadmin::lang.assigned_to_me')</option>
                            @foreach($admins as $admin)
                                <option value="{{ $admin->id }}" {{ $assigned_filter == $admin->id ? 'selected' : '' }}>{{ $admin->username }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>@lang('superadmin::lang.search'):</label>
                        <input type="text" class="form-control" id="search_input" placeholder="@lang('superadmin::lang.search_tickets')" value="{{ $search }}">
                    </div>
                </div>
            </div>
        @endcomponent

        @component('components.widget', ['class' => 'box-primary', 'title' => __('superadmin::lang.all_tickets')])
            <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>@lang('superadmin::lang.ticket_number')</th>
                            <th>@lang('superadmin::lang.business')</th>
                            <th>@lang('superadmin::lang.subject')</th>
                            <th>@lang('superadmin::lang.category')</th>
                            <th>@lang('superadmin::lang.priority')</th>
                            <th>@lang('superadmin::lang.status')</th>
                            <th>@lang('superadmin::lang.assigned_to')</th>
                            <th>@lang('superadmin::lang.messages')</th>
                            <th>@lang('superadmin::lang.created_at')</th>
                            <th>@lang('messages.action')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($tickets as $ticket)
                        <tr>
                            <td>
                                <a href="{{ route('superadmin.support-tickets.show', $ticket->id) }}">
                                    {{ $ticket->ticket_number }}
                                </a>
                                @if($ticket->whatsapp_ticket_number)
                                    <br><small class="text-success">
                                        <i class="fa fa-whatsapp"></i> {{ $ticket->whatsapp_ticket_number }}
                                    </small>
                                @endif
                            </td>
                            <td>{{ $ticket->business->name ?? 'N/A' }}</td>
                            <td>{{ $ticket->subject }}</td>
                            <td>
                                <span class="label label-default">
                                    {{ ucwords(str_replace('_', ' ', $ticket->category)) }}
                                </span>
                            </td>
                            <td>{!! $ticket->priority_badge !!}</td>
                            <td>{!! $ticket->status_badge !!}</td>
                            <td>
                                @if($ticket->assigned_to)
                                    {{ $ticket->assignedTo->username ?? 'N/A' }}
                                @else
                                    <span class="text-muted">@lang('superadmin::lang.unassigned')</span>
                                @endif
                            </td>
                            <td>
                                <span class="badge bg-blue">{{ $ticket->messages->count() }}</span>
                                @if($ticket->getUnreadBusinessMessagesCount() > 0)
                                    <span class="badge bg-red">{{ $ticket->getUnreadBusinessMessagesCount() }} @lang('superadmin::lang.new')</span>
                                @endif
                            </td>
                            <td>{{ @format_datetime($ticket->created_at) }}</td>
                            <td>
                                <a href="{{ route('superadmin.support-tickets.show', $ticket->id) }}" class="btn btn-xs btn-info">
                                    <i class="fa fa-eye"></i> @lang('messages.view')
                                </a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            <div class="text-center">
                {{ $tickets->appends(request()->query())->links() }}
            </div>
        @endcomponent
    </section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        $('#status_filter, #priority_filter, #category_filter, #assigned_filter').change(function() {
            applyFilters();
        });

        $('#search_input').on('keypress', function(e) {
            if(e.which == 13) {
                applyFilters();
            }
        });

        function applyFilters() {
            var status = $('#status_filter').val();
            var priority = $('#priority_filter').val();
            var category = $('#category_filter').val();
            var assigned = $('#assigned_filter').val();
            var search = $('#search_input').val();
            
            window.location.href = "{{ route('superadmin.support-tickets.index') }}?status=" + status + 
                "&priority=" + priority + "&category=" + category + "&assigned=" + assigned + "&search=" + search;
        }
    });
</script>
@endsection
