@extends('layouts.app')
@section('title', __('superadmin::lang.superadmin') . ' | ' . __('superadmin::lang.ticket') . ' #' . $ticket->ticket_number)

@section('content')
    @include('superadmin::layouts.nav')
    
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">
            @lang('superadmin::lang.ticket') #{{ $ticket->ticket_number }}
            {!! $ticket->status_badge !!}
        </h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-8">
                @component('components.widget', ['class' => 'box-primary', 'title' => $ticket->subject])
                    @slot('tool')
                        <div class="box-tools">
                            @if(!$ticket->isClosed())
                                <!-- Status Update -->
                                {!! Form::open(['route' => ['superadmin.support-tickets.update-status', $ticket->id], 'method' => 'post', 'style' => 'display:inline', 'id' => 'status_form']) !!}
                                <select name="status" class="form-control input-sm" style="display:inline; width:auto;" onchange="this.form.submit()">
                                    <option value="">@lang('superadmin::lang.change_status')</option>
                                    <option value="in_progress">@lang('superadmin::lang.in_progress')</option>
                                    <option value="waiting_customer">@lang('superadmin::lang.waiting_customer')</option>
                                    <option value="waiting_admin">@lang('superadmin::lang.waiting_admin')</option>
                                    <option value="closed">@lang('superadmin::lang.closed')</option>
                                </select>
                                {!! Form::close() !!}
                            @endif
                        </div>
                    @endslot

                    <!-- Conversation Messages -->
                    <div class="direct-chat-messages" style="height: auto; max-height: 600px; overflow-y: auto;">
                        @foreach($ticket->messages as $message)
                            @php
                                $is_business = $message->sender_type === 'business';
                                $is_system = $message->sender_type === 'system';
                                $is_internal = $message->is_internal_note;
                            @endphp

                            @if(!$is_internal || $is_internal)
                                <div class="direct-chat-msg {{ $is_business ? '' : 'right' }}">
                                    <div class="direct-chat-info clearfix">
                                        <span class="direct-chat-name {{ $is_business ? 'pull-left' : 'pull-right' }}">
                                            @if($is_system)
                                                <i class="fa fa-cog"></i> @lang('superadmin::lang.system')
                                            @else
                                                {{ $message->user->username ?? __('superadmin::lang.deleted_user') }}
                                            @endif
                                            @if($is_internal)
                                                <span class="label label-warning">@lang('superadmin::lang.internal_note')</span>
                                            @endif
                                        </span>
                                        <span class="direct-chat-timestamp {{ $is_business ? 'pull-right' : 'pull-left' }}">
                                            {{ @format_datetime($message->created_at) }}
                                            @if($message->read_at)
                                                <i class="fa fa-check text-success" title="@lang('superadmin::lang.read_at') {{ @format_datetime($message->read_at) }}"></i>
                                            @endif
                                        </span>
                                    </div>

                                    @if($is_system)
                                        <div class="direct-chat-img-container">
                                            <div class="direct-chat-img-placeholder">
                                                <i class="fa fa-cog fa-2x"></i>
                                            </div>
                                        </div>
                                    @else
                                        <img class="direct-chat-img" src="{{ asset('img/default.png') }}" alt="User Image">
                                    @endif

                                    <div class="direct-chat-text {{ $is_system ? 'bg-gray' : ($is_internal ? 'bg-yellow' : '') }}">
                                        {!! nl2br(e($message->message)) !!}

                                        @if($message->attachments->count() > 0)
                                            <div class="attachments" style="margin-top: 10px;">
                                                <strong>@lang('superadmin::lang.attachments'):</strong><br>
                                                @foreach($message->attachments as $attachment)
                                                    <a href="{{ $attachment->file_url }}" target="_blank" class="btn btn-xs btn-default">
                                                        <i class="fa {{ $attachment->file_icon }}"></i>
                                                        {{ $attachment->file_name }}
                                                        <small>({{ $attachment->formatted_file_size }})</small>
                                                    </a>
                                                @endforeach
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>

                    @if(!$ticket->isClosed())
                        <hr>
                        <!-- Reply Form -->
                        {!! Form::open(['route' => ['superadmin.support-tickets.respond', $ticket->id], 'method' => 'post', 'files' => true]) !!}
                        <div class="form-group">
                            {!! Form::label('message', __('superadmin::lang.your_response') . ':') !!}
                            {!! Form::textarea('message', null, ['class' => 'form-control', 'required', 'rows' => 3, 'placeholder' => __('superadmin::lang.type_your_response')]) !!}
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    {!! Form::label('attachments', __('superadmin::lang.attachments') . ':') !!}
                                    {!! Form::file('attachments[]', ['class' => 'form-control', 'multiple' => true, 'accept' => 'image/*,.pdf,.doc,.docx,.xls,.xlsx']) !!}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="checkbox">
                                    <label>
                                        {!! Form::checkbox('is_internal_note', 1, false) !!}
                                        @lang('superadmin::lang.internal_note_only')
                                        <small class="help-block">@lang('superadmin::lang.internal_note_help')</small>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-primary pull-right">
                            <i class="fa fa-send"></i> @lang('superadmin::lang.send_response')
                        </button>
                        {!! Form::close() !!}
                    @endif

                    @if($ticket->status !== 'resolved' && !$ticket->isClosed())
                        <hr>
                        <!-- Resolve Form -->
                        {!! Form::open(['route' => ['superadmin.support-tickets.resolve', $ticket->id], 'method' => 'post']) !!}
                        <div class="panel panel-success">
                            <div class="panel-heading">
                                <h4 class="panel-title">@lang('superadmin::lang.resolve_ticket')</h4>
                            </div>
                            <div class="panel-body">
                                <div class="form-group">
                                    {!! Form::label('resolution_note', __('superadmin::lang.resolution_note') . ':*') !!}
                                    {!! Form::textarea('resolution_note', null, ['class' => 'form-control', 'required', 'rows' => 2, 'placeholder' => __('superadmin::lang.resolution_note_placeholder')]) !!}
                                </div>
                                <button type="submit" class="btn btn-success">
                                    <i class="fa fa-check"></i> @lang('superadmin::lang.mark_as_resolved')
                                </button>
                            </div>
                        </div>
                        {!! Form::close() !!}
                    @endif
                @endcomponent
            </div>

            <div class="col-md-4">
                @component('components.widget', ['class' => 'box-info', 'title' => __('superadmin::lang.ticket_information')])
                    <table class="table table-striped">
                        <tr>
                            <th>@lang('superadmin::lang.business'):</th>
                            <td>{{ $ticket->business->name ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>@lang('superadmin::lang.ticket_number'):</th>
                            <td>{{ $ticket->ticket_number }}</td>
                        </tr>
                        <tr>
                            <th>@lang('superadmin::lang.status'):</th>
                            <td>{!! $ticket->status_badge !!}</td>
                        </tr>
                        <tr>
                            <th>@lang('superadmin::lang.priority'):</th>
                            <td>{!! $ticket->priority_badge !!}</td>
                        </tr>
                        <tr>
                            <th>@lang('superadmin::lang.category'):</th>
                            <td>{{ ucwords(str_replace('_', ' ', $ticket->category)) }}</td>
                        </tr>
                        <tr>
                            <th>@lang('superadmin::lang.created_by'):</th>
                            <td>{{ $ticket->creator->username ?? __('superadmin::lang.deleted_user') }}</td>
                        </tr>
                        <tr>
                            <th>@lang('superadmin::lang.created_at'):</th>
                            <td>{{ @format_datetime($ticket->created_at) }}</td>
                        </tr>
                        @if($ticket->external_reference)
                        <tr>
                            <th>@lang('superadmin::lang.reference'):</th>
                            <td>{{ $ticket->external_reference }}</td>
                        </tr>
                        @endif
                        @if($ticket->whatsapp_ticket_number)
                        <tr>
                            <th>@lang('superadmin::lang.whatsapp_ticket'):</th>
                            <td><span class="label label-success"><i class="fa fa-whatsapp"></i> {{ $ticket->whatsapp_ticket_number }}</span></td>
                        </tr>
                        @endif
                    </table>

                    @if(!$ticket->isClosed())
                        <hr>
                        <h5>@lang('superadmin::lang.assign_ticket'):</h5>
                        {!! Form::open(['route' => ['superadmin.support-tickets.assign', $ticket->id], 'method' => 'post']) !!}
                        <div class="form-group">
                            {!! Form::select('assigned_to', $admins->pluck('username', 'id'), $ticket->assigned_to, ['class' => 'form-control select2', 'placeholder' => __('superadmin::lang.select_admin')]) !!}
                        </div>
                        <button type="submit" class="btn btn-block btn-primary btn-sm">
                            <i class="fa fa-user"></i> @lang('superadmin::lang.assign')
                        </button>
                        {!! Form::close() !!}
                    @endif

                    @if($ticket->assigned_to)
                        <hr>
                        <h5>@lang('superadmin::lang.assigned_to'):</h5>
                        <p><strong>{{ $ticket->assignedTo->username ?? __('superadmin::lang.deleted_user') }}</strong></p>
                    @endif

                    @if($ticket->resolved_at)
                        <hr>
                        <h5>@lang('superadmin::lang.resolution_details'):</h5>
                        <p>
                            <strong>@lang('superadmin::lang.resolved_at'):</strong><br>
                            {{ @format_datetime($ticket->resolved_at) }}
                        </p>
                        <p>
                            <strong>@lang('superadmin::lang.resolved_by'):</strong><br>
                            {{ $ticket->resolver->username ?? __('superadmin::lang.deleted_user') }}
                        </p>
                        @if($ticket->resolution_note)
                            <div class="well well-sm">
                                <strong>@lang('superadmin::lang.resolution_note'):</strong><br>
                                {!! nl2br(e($ticket->resolution_note)) !!}
                            </div>
                        @endif
                    @endif

                    @if($ticket->attachments->count() > 0)
                        <hr>
                        <h5>@lang('superadmin::lang.initial_attachments'):</h5>
                        @foreach($ticket->attachments as $attachment)
                            <a href="{{ $attachment->file_url }}" target="_blank" class="btn btn-xs btn-default btn-block text-left">
                                <i class="fa {{ $attachment->file_icon }}"></i>
                                {{ $attachment->file_name }}
                                <small class="pull-right">({{ $attachment->formatted_file_size }})</small>
                            </a>
                        @endforeach
                    @endif
                @endcomponent
            </div>
        </div>
    </section>
@endsection

@section('css')
<style>
    .direct-chat-messages {
        padding: 10px;
    }
    .direct-chat-msg {
        margin-bottom: 20px;
    }
    .attachments a {
        margin: 2px;
    }
    .direct-chat-img-container {
        display: inline-block;
        width: 50px;
        height: 50px;
        float: left;
        margin-right: 10px;
    }
    .right .direct-chat-img-container {
        float: right;
        margin-right: 0;
        margin-left: 10px;
    }
    .direct-chat-img-placeholder {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        background-color: #f4f4f4;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #999;
    }
    .bg-yellow {
        background-color: #fff9e6 !important;
        border-left: 3px solid #f39c12;
    }
</style>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        $('.select2').select2();
    });
</script>
@endsection
