@extends('layouts.app')
@section('title', __('superadmin::lang.create_ticket'))

@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">
            @lang('superadmin::lang.create_ticket')
        </h1>
    </section>

    <!-- Main content -->
    <section class="content">
        {!! Form::open(['route' => 'support-tickets.store', 'method' => 'post', 'id' => 'ticket_create_form', 'files' => true]) !!}
        
        @component('components.widget', ['class' => 'box-primary', 'title' => __('superadmin::lang.ticket_details')])
            <div class="row">
                <div class="col-md-8">
                    <div class="form-group">
                        {!! Form::label('subject', __('superadmin::lang.subject') . ':*') !!}
                        {!! Form::text('subject', null, ['class' => 'form-control', 'required', 'placeholder' => __('superadmin::lang.ticket_subject')]) !!}
                    </div>

                    <div class="form-group">
                        {!! Form::label('description', __('superadmin::lang.description') . ':*') !!}
                        {!! Form::textarea('description', null, ['class' => 'form-control', 'required', 'rows' => 5, 'placeholder' => __('superadmin::lang.describe_issue')]) !!}
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                {!! Form::label('category', __('superadmin::lang.category') . ':*') !!}
                                {!! Form::select('category', $categories, null, ['class' => 'form-control select2', 'required', 'placeholder' => __('messages.please_select')]) !!}
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {!! Form::label('priority', __('superadmin::lang.priority') . ':*') !!}
                                {!! Form::select('priority', $priorities, 'medium', ['class' => 'form-control select2', 'required']) !!}
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        {!! Form::label('external_reference', __('superadmin::lang.reference_number') . ':') !!}
                        {!! Form::text('external_reference', null, ['class' => 'form-control', 'placeholder' => __('superadmin::lang.optional_reference')]) !!}
                        <p class="help-block">@lang('superadmin::lang.external_reference_help')</p>
                    </div>

                    <div class="form-group">
                        {!! Form::label('attachments', __('superadmin::lang.attachments') . ':') !!}
                        {!! Form::file('attachments[]', ['class' => 'form-control', 'multiple' => true, 'accept' => 'image/*,.pdf,.doc,.docx,.xls,.xlsx']) !!}
                        <p class="help-block">@lang('superadmin::lang.max_file_size_10mb')</p>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="well">
                        <h4>@lang('superadmin::lang.ticket_help')</h4>
                        <p>@lang('superadmin::lang.ticket_help_text')</p>
                        
                        <h5>@lang('superadmin::lang.categories'):</h5>
                        <ul class="list-unstyled">
                            <li><i class="fa fa-credit-card"></i> @lang('superadmin::lang.billing')</li>
                            <li><i class="fa fa-wrench"></i> @lang('superadmin::lang.technical_support')</li>
                            <li><i class="fa fa-lightbulb-o"></i> @lang('superadmin::lang.feature_request')</li>
                            <li><i class="fa fa-bug"></i> @lang('superadmin::lang.bug_report')</li>
                            <li><i class="fa fa-user"></i> @lang('superadmin::lang.account_issue')</li>
                            <li><i class="fa fa-money"></i> @lang('superadmin::lang.payment_issue')</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <button type="submit" class="btn btn-primary pull-right">
                        <i class="fa fa-ticket"></i> @lang('superadmin::lang.create_ticket')
                    </button>
                    <a href="{{ route('support-tickets.index') }}" class="btn btn-default pull-right" style="margin-right: 10px;">
                        @lang('messages.cancel')
                    </a>
                </div>
            </div>
        @endcomponent

        {!! Form::close() !!}
    </section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        $('.select2').select2();
    });
</script>
@endsection
