@extends('layouts.app')
@section('title', __('superadmin::lang.support_tickets'))

@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">
            @lang('superadmin::lang.support_tickets')
            <small>@lang('superadmin::lang.manage_support_tickets')</small>
        </h1>
    </section>

    <!-- Main content -->
    <section class="content">
        @component('components.widget', ['class' => 'box-primary', 'title' => __('superadmin::lang.filter_tickets')])
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label>@lang('superadmin::lang.status'):</label>
                        <select class="form-control" id="status_filter">
                            <option value="all" {{ $status_filter == 'all' ? 'selected' : '' }}>@lang('superadmin::lang.all')</option>
                            <option value="open" {{ $status_filter == 'open' ? 'selected' : '' }}>@lang('superadmin::lang.open')</option>
                            <option value="in_progress" {{ $status_filter == 'in_progress' ? 'selected' : '' }}>@lang('superadmin::lang.in_progress')</option>
                            <option value="waiting_admin" {{ $status_filter == 'waiting_admin' ? 'selected' : '' }}>@lang('superadmin::lang.waiting_admin')</option>
                            <option value="waiting_customer" {{ $status_filter == 'waiting_customer' ? 'selected' : '' }}>@lang('superadmin::lang.waiting_customer')</option>
                            <option value="resolved" {{ $status_filter == 'resolved' ? 'selected' : '' }}>@lang('superadmin::lang.resolved')</option>
                            <option value="closed" {{ $status_filter == 'closed' ? 'selected' : '' }}>@lang('superadmin::lang.closed')</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>@lang('superadmin::lang.priority'):</label>
                        <select class="form-control" id="priority_filter">
                            <option value="all" {{ $priority_filter == 'all' ? 'selected' : '' }}>@lang('superadmin::lang.all')</option>
                            <option value="low" {{ $priority_filter == 'low' ? 'selected' : '' }}>@lang('superadmin::lang.low')</option>
                            <option value="medium" {{ $priority_filter == 'medium' ? 'selected' : '' }}>@lang('superadmin::lang.medium')</option>
                            <option value="high" {{ $priority_filter == 'high' ? 'selected' : '' }}>@lang('superadmin::lang.high')</option>
                            <option value="urgent" {{ $priority_filter == 'urgent' ? 'selected' : '' }}>@lang('superadmin::lang.urgent')</option>
                        </select>
                    </div>
                </div>
            </div>
        @endcomponent

        <div class="row">
            <div class="col-md-3 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-aqua"><i class="fa fa-ticket"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">@lang('superadmin::lang.open_tickets')</span>
                        <span class="info-box-number">{{ $open_count }}</span>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-green"><i class="fa fa-check"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">@lang('superadmin::lang.closed_tickets')</span>
                        <span class="info-box-number">{{ $closed_count }}</span>
                    </div>
                </div>
            </div>
        </div>

        @component('components.widget', ['class' => 'box-primary'])
            @slot('tool')
                <div class="box-tools">
                    <a class="btn btn-block btn-primary" href="{{ route('support-tickets.create') }}">
                        <i class="fa fa-plus"></i> @lang('superadmin::lang.create_ticket')
                    </a>
                </div>
            @endslot
            
            <div class="table-responsive">
                <table class="table table-bordered table-striped" id="support_tickets_table">
                    <thead>
                        <tr>
                            <th>@lang('superadmin::lang.ticket_number')</th>
                            <th>@lang('superadmin::lang.subject')</th>
                            <th>@lang('superadmin::lang.category')</th>
                            <th>@lang('superadmin::lang.priority')</th>
                            <th>@lang('superadmin::lang.status')</th>
                            <th>@lang('superadmin::lang.messages')</th>
                            <th>@lang('superadmin::lang.created_at')</th>
                            <th>@lang('messages.action')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($tickets as $ticket)
                        <tr>
                            <td>
                                <a href="{{ route('support-tickets.show', $ticket->id) }}">
                                    {{ $ticket->ticket_number }}
                                </a>
                            </td>
                            <td>{{ $ticket->subject }}</td>
                            <td>
                                <span class="label label-default">
                                    {{ ucwords(str_replace('_', ' ', $ticket->category)) }}
                                </span>
                            </td>
                            <td>{!! $ticket->priority_badge !!}</td>
                            <td>{!! $ticket->status_badge !!}</td>
                            <td>
                                <span class="badge bg-blue">{{ $ticket->messages->count() }}</span>
                                @if($ticket->getUnreadAdminMessagesCount() > 0)
                                    <span class="badge bg-red">{{ $ticket->getUnreadAdminMessagesCount() }} @lang('superadmin::lang.new')</span>
                                @endif
                            </td>
                            <td>{{ @format_datetime($ticket->created_at) }}</td>
                            <td>
                                <a href="{{ route('support-tickets.show', $ticket->id) }}" class="btn btn-xs btn-info">
                                    <i class="fa fa-eye"></i> @lang('messages.view')
                                </a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            <div class="text-center">
                {{ $tickets->appends(request()->query())->links() }}
            </div>
        @endcomponent
    </section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        $('#status_filter, #priority_filter').change(function() {
            var status = $('#status_filter').val();
            var priority = $('#priority_filter').val();
            window.location.href = "{{ route('support-tickets.index') }}?status=" + status + "&priority=" + priority;
        });
    });
</script>
@endsection
