@extends('layouts.app')
@section('title', __('superadmin::lang.ticket') . ' #' . $ticket->ticket_number)

@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">
            @lang('superadmin::lang.ticket') #{{ $ticket->ticket_number }}
            {!! $ticket->status_badge !!}
        </h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-8">
                @component('components.widget', ['class' => 'box-primary', 'title' => $ticket->subject])
                    @slot('tool')
                        <div class="box-tools">
                            @if(!$ticket->isClosed())
                                {!! Form::open(['route' => ['support-tickets.close', $ticket->id], 'method' => 'post', 'style' => 'display:inline']) !!}
                                <button type="submit" class="btn btn-sm btn-warning" onclick="return confirm('@lang('superadmin::lang.confirm_close_ticket')')">
                                    <i class="fa fa-times"></i> @lang('superadmin::lang.close_ticket')
                                </button>
                                {!! Form::close() !!}
                            @endif
                        </div>
                    @endslot

                    <!-- Ticket Description -->
                    <div class="direct-chat-messages" style="height: auto; max-height: 600px; overflow-y: auto;">
                        @foreach($ticket->messages as $message)
                            @if(!$message->is_internal_note)
                                @php
                                    $is_business = $message->sender_type === 'business';
                                    $is_system = $message->sender_type === 'system';
                                @endphp

                                <div class="direct-chat-msg {{ $is_business ? '' : 'right' }}">
                                    <div class="direct-chat-info clearfix">
                                        <span class="direct-chat-name {{ $is_business ? 'pull-left' : 'pull-right' }}">
                                            @if($is_system)
                                                <i class="fa fa-cog"></i> @lang('superadmin::lang.system')
                                            @else
                                                {{ $message->user->username ?? __('superadmin::lang.deleted_user') }}
                                            @endif
                                        </span>
                                        <span class="direct-chat-timestamp {{ $is_business ? 'pull-right' : 'pull-left' }}">
                                            {{ @format_datetime($message->created_at) }}
                                            @if($message->read_at)
                                                <i class="fa fa-check text-success" title="@lang('superadmin::lang.read_at') {{ @format_datetime($message->read_at) }}"></i>
                                            @endif
                                        </span>
                                    </div>

                                    @if($is_system)
                                        <div class="direct-chat-img-container">
                                            <div class="direct-chat-img-placeholder">
                                                <i class="fa fa-cog fa-2x"></i>
                                            </div>
                                        </div>
                                    @else
                                        <img class="direct-chat-img" src="{{ asset('img/default.png') }}" alt="User Image">
                                    @endif

                                    <div class="direct-chat-text {{ $is_system ? 'bg-gray' : '' }}">
                                        {!! nl2br(e($message->message)) !!}

                                        @if($message->attachments->count() > 0)
                                            <div class="attachments" style="margin-top: 10px;">
                                                <strong>@lang('superadmin::lang.attachments'):</strong><br>
                                                @foreach($message->attachments as $attachment)
                                                    <a href="{{ $attachment->file_url }}" target="_blank" class="btn btn-xs btn-default">
                                                        <i class="fa {{ $attachment->file_icon }}"></i>
                                                        {{ $attachment->file_name }}
                                                        <small>({{ $attachment->formatted_file_size }})</small>
                                                    </a>
                                                @endforeach
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>

                    @if(!$ticket->isClosed())
                        <hr>
                        <!-- Reply Form -->
                        {!! Form::open(['route' => ['support-tickets.reply', $ticket->id], 'method' => 'post', 'files' => true]) !!}
                        <div class="form-group">
                            {!! Form::label('message', __('superadmin::lang.your_reply') . ':') !!}
                            {!! Form::textarea('message', null, ['class' => 'form-control', 'required', 'rows' => 3, 'placeholder' => __('superadmin::lang.type_your_reply')]) !!}
                        </div>

                        <div class="form-group">
                            {!! Form::label('attachments', __('superadmin::lang.attachments') . ':') !!}
                            {!! Form::file('attachments[]', ['class' => 'form-control', 'multiple' => true, 'accept' => 'image/*,.pdf,.doc,.docx,.xls,.xlsx']) !!}
                        </div>

                        <button type="submit" class="btn btn-primary pull-right">
                            <i class="fa fa-send"></i> @lang('superadmin::lang.send_reply')
                        </button>
                        {!! Form::close() !!}
                    @else
                        <div class="alert alert-warning">
                            <i class="fa fa-info-circle"></i> @lang('superadmin::lang.ticket_closed_no_reply')
                        </div>
                    @endif
                @endcomponent
            </div>

            <div class="col-md-4">
                @component('components.widget', ['class' => 'box-info', 'title' => __('superadmin::lang.ticket_details')])
                    <table class="table table-striped">
                        <tr>
                            <th>@lang('superadmin::lang.ticket_number'):</th>
                            <td>{{ $ticket->ticket_number }}</td>
                        </tr>
                        <tr>
                            <th>@lang('superadmin::lang.status'):</th>
                            <td>{!! $ticket->status_badge !!}</td>
                        </tr>
                        <tr>
                            <th>@lang('superadmin::lang.priority'):</th>
                            <td>{!! $ticket->priority_badge !!}</td>
                        </tr>
                        <tr>
                            <th>@lang('superadmin::lang.category'):</th>
                            <td>{{ ucwords(str_replace('_', ' ', $ticket->category)) }}</td>
                        </tr>
                        <tr>
                            <th>@lang('superadmin::lang.created_by'):</th>
                            <td>{{ $ticket->creator->username ?? __('superadmin::lang.deleted_user') }}</td>
                        </tr>
                        <tr>
                            <th>@lang('superadmin::lang.created_at'):</th>
                            <td>{{ @format_datetime($ticket->created_at) }}</td>
                        </tr>
                        @if($ticket->assigned_to)
                        <tr>
                            <th>@lang('superadmin::lang.assigned_to'):</th>
                            <td>{{ $ticket->assignedTo->username ?? __('superadmin::lang.deleted_user') }}</td>
                        </tr>
                        @endif
                        @if($ticket->resolved_at)
                        <tr>
                            <th>@lang('superadmin::lang.resolved_at'):</th>
                            <td>{{ @format_datetime($ticket->resolved_at) }}</td>
                        </tr>
                        <tr>
                            <th>@lang('superadmin::lang.resolved_by'):</th>
                            <td>{{ $ticket->resolver->username ?? __('superadmin::lang.deleted_user') }}</td>
                        </tr>
                        @endif
                        @if($ticket->external_reference)
                        <tr>
                            <th>@lang('superadmin::lang.reference'):</th>
                            <td>{{ $ticket->external_reference }}</td>
                        </tr>
                        @endif
                        @if($ticket->whatsapp_ticket_number)
                        <tr>
                            <th>@lang('superadmin::lang.whatsapp_ticket'):</th>
                            <td><span class="label label-success">{{ $ticket->whatsapp_ticket_number }}</span></td>
                        </tr>
                        @endif
                    </table>

                    @if($ticket->attachments->count() > 0)
                        <hr>
                        <h5>@lang('superadmin::lang.initial_attachments'):</h5>
                        @foreach($ticket->attachments as $attachment)
                            <a href="{{ $attachment->file_url }}" target="_blank" class="btn btn-xs btn-default btn-block text-left">
                                <i class="fa {{ $attachment->file_icon }}"></i>
                                {{ $attachment->file_name }}
                                <small class="pull-right">({{ $attachment->formatted_file_size }})</small>
                            </a>
                        @endforeach
                    @endif

                    @if($ticket->resolution_note)
                        <hr>
                        <h5>@lang('superadmin::lang.resolution_note'):</h5>
                        <div class="well well-sm">
                            {!! nl2br(e($ticket->resolution_note)) !!}
                        </div>
                    @endif
                @endcomponent
            </div>
        </div>
    </section>
@endsection

@section('css')
<style>
    .direct-chat-messages {
        padding: 10px;
    }
    .direct-chat-msg {
        margin-bottom: 20px;
    }
    .attachments a {
        margin: 2px;
    }
    .direct-chat-img-container {
        display: inline-block;
        width: 50px;
        height: 50px;
        float: left;
        margin-right: 10px;
    }
    .right .direct-chat-img-container {
        float: right;
        margin-right: 0;
        margin-left: 10px;
    }
    .direct-chat-img-placeholder {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        background-color: #f4f4f4;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #999;
    }
</style>
@endsection
