<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>{{ __('verification.verification_expired') }} - {{ config('app.name', 'POS') }}</title>
  <link rel="icon" href="/asset/img/logo.svg">
  <link rel="stylesheet" href="/asset/css/bootstrap.min.css">
  <link rel="stylesheet" href="/asset/css/fontawesome.min.css">
  <link rel="stylesheet" href="/asset/css/animate.css">
  <link rel="stylesheet" href="/asset/css/style.css">
</head>
<body>
  <div class="cs_register_page position-relative">
    <div class="container">
      <div class="cs_login_container text-center">
        <div class="cs_logo">
          <img src="/asset/img/logo3.png" alt="Logo">
        </div>

        <div class="cs_login_form">
          <div style="margin-bottom: 30px;">
            <i class="fa fa-clock-o" style="font-size: 80px; color: #ffc107;"></i>
          </div>
          
          <h2 class="cs_login_heading" style="color: #ffc107;">{{ __('verification.verification_expired') }}</h2>
          
          <p style="color: #666; font-size: 16px; margin: 20px 0;">
            {{ __('verification.verification_expired_message') }}
          </p>

          @if(session('warning'))
            <div class="alert alert-warning" style="text-align: left; margin: 20px 0;">
              <i class="fa fa-exclamation-circle"></i>
              {{ session('warning') }}
            </div>
          @elseif(isset($message))
            <div class="alert alert-warning" style="text-align: left; margin: 20px 0;">
              <i class="fa fa-exclamation-circle"></i>
              {{ $message }}
            </div>
          @endif

          <div style="background: #fffbf0; border: 1px solid #ffc107; border-radius: 8px; padding: 20px; margin: 30px 0; text-align: left;">
            <p style="color: #856404; margin-bottom: 10px; font-size: 14px;">
              <strong>{{ __('verification.validity_periods') }}:</strong>
            </p>
            <ul style="color: #856404; margin: 0; padding-left: 20px;">
              <li>
                <i class="fa fa-envelope"></i> {{ __('verification.email_verification_link') }}: 
                <strong>{{ __('verification.valid_for_24_hours') }}</strong>
              </li>
              <li>
                <i class="fab fa-whatsapp"></i> {{ __('verification.whatsapp_code') }}: 
                <strong>{{ __('verification.valid_for_10_minutes') }}</strong>
              </li>
            </ul>
          </div>

          <div style="background: #e7f3ff; border: 1px solid #b3d9ff; border-radius: 8px; padding: 15px; margin-bottom: 30px; text-align: left;">
            <p style="color: #004085; margin: 0; font-size: 14px;">
              <i class="fa fa-info-circle"></i>
              <strong>{{ __('verification.what_to_do') }}?</strong><br>
              {{ __('verification.login_to_request_new_code') }}
            </p>
          </div>

          <a href="{{ route('login') }}" class="btn btn-primary btn-lg btn-block">
            <i class="fa fa-sign-in"></i> {{ __('verification.login_to_resend') }}
          </a>

          <div style="margin-top: 30px;">
            <p style="color: #999; font-size: 13px;">
              <i class="fa fa-shield"></i> {{ __('verification.security_note') }}
            </p>
          </div>
        </div>
      </div>
    </div>
  </div>
</body>
</html>
