<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>{{ __('verification.verification_failed') }} - {{ config('app.name', 'POS') }}</title>
  <link rel="icon" href="/asset/img/logo.svg">
  <link rel="stylesheet" href="/asset/css/bootstrap.min.css">
  <link rel="stylesheet" href="/asset/css/fontawesome.min.css">
  <link rel="stylesheet" href="/asset/css/animate.css">
  <link rel="stylesheet" href="/asset/css/style.css">
</head>
<body>
  <div class="cs_register_page position-relative">
    <div class="container">
      <div class="cs_login_container text-center">
        <div class="cs_logo">
          <img src="/asset/img/logo3.png" alt="Logo">
        </div>

        <div class="cs_login_form">
          <div style="margin-bottom: 30px;">
            <i class="fa fa-times-circle" style="font-size: 80px; color: #dc3545;"></i>
          </div>
          
          <h2 class="cs_login_heading" style="color: #dc3545;">{{ __('verification.verification_failed') }}</h2>
          
          <p style="color: #666; font-size: 16px; margin: 20px 0;">
            {{ __('verification.verification_failed_message') }}
          </p>

          @if(session('error'))
            <div class="alert alert-danger" style="text-align: left; margin: 20px 0;">
              <i class="fa fa-exclamation-triangle"></i>
              <strong>{{ __('verification.error') }}:</strong>
              {{ session('error') }}
            </div>
          @elseif(isset($error))
            <div class="alert alert-danger" style="text-align: left; margin: 20px 0;">
              <i class="fa fa-exclamation-triangle"></i>
              <strong>{{ __('verification.error') }}:</strong>
              {{ $error }}
            </div>
          @endif

          <div style="background: #fff3cd; border: 1px solid #ffc107; border-radius: 8px; padding: 20px; margin: 30px 0; text-align: left;">
            <p style="color: #856404; margin-bottom: 10px; font-size: 14px;">
              <strong>{{ __('verification.possible_reasons') }}:</strong>
            </p>
            <ul style="color: #856404; margin: 0; padding-left: 20px;">
              <li>{{ __('verification.invalid_verification_code') }}</li>
              <li>{{ __('verification.code_already_used') }}</li>
              <li>{{ __('verification.code_expired') }}</li>
              <li>{{ __('verification.technical_error') }}</li>
            </ul>
          </div>

          <a href="{{ route('login') }}" class="btn btn-primary btn-lg btn-block">
            <i class="fa fa-sign-in"></i> {{ __('verification.back_to_login') }}
          </a>

          <div style="margin-top: 30px; background: #e7f3ff; border: 1px solid #b3d9ff; border-radius: 8px; padding: 15px; text-align: left;">
            <p style="color: #004085; margin: 0; font-size: 14px;">
              <i class="fa fa-question-circle"></i>
              <strong>{{ __('verification.need_help') }}?</strong><br>
              {{ __('verification.contact_support') }}: <a href="mailto:support@example.com">support@example.com</a>
            </p>
          </div>
        </div>
      </div>
    </div>
  </div>
</body>
</html>
