<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>{{ __('verification.verify_your_account') }} - {{ config('app.name', 'POS') }}</title>
  <link rel="shortcut icon" type="image/x-icon" href="{{ asset('asset/img/favicon.png') }}">
  <link rel="stylesheet" href="{{ asset('asset/css/bootstrap.min.css') }}">
  <!-- FontAwesome 6.5.0 from CDN -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" integrity="sha512-Avb2QiuDEEvB4bZJYdft2mNjVShBftLdPG8FJ0V7irTLQ8Uo0qcPxh4Plq7G5tGm0rU+1SPhVotteLpBERwTkw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <link rel="stylesheet" href="{{ asset('asset/css/style.css') }}">
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body.account-page {
      background: #ffffff;
      font-family: 'Poppins', sans-serif;
      margin: 0;
      padding: 0;
      min-height: 100vh;
      overflow-x: hidden;
    }

    .main-wrapper {
      min-height: 100vh;
      height: 100vh;
      display: flex;
      align-items: stretch;
      justify-content: center;
      padding: 0;
      margin: 0;
    }

    .account-content {
      width: 100%;
      max-width: 100%;
      height: 100vh;
      margin: 0;
      display: flex;
      align-items: stretch;
    }

    .login-wrapper {
      background: #fff;
      display: flex;
      width: 100%;
      height: 100vh;
      overflow: hidden;
      position: relative;
      box-shadow: none;
      border-radius: 0;
    }

    .login-content {
      flex: 0 0 50%;
      width: 50%;
      padding: 40px 60px;
      overflow-y: auto;
      max-height: 100vh;
    }

    .login-logo {
      text-align: center;
      margin-bottom: 25px;
    }

    .login-logo img {
      max-width: 140px;
      height: auto;
    }

    .login-userheading {
      text-align: center;
      margin-bottom: 25px;
    }

    .login-userheading h3 {
      font-size: 26px;
      font-weight: 700;
      color: #1e1e1e;
      margin-bottom: 8px;
    }

    .login-userheading h4 {
      font-size: 14px;
      font-weight: 400;
      color: #888;
      margin: 0;
    }

    .login-img {
      flex: 0 0 50%;
      width: 50%;
      background: linear-gradient(to right, #FF9F43 0%, #FBB034 100%);
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 0;
      position: relative;
      overflow: hidden;
      height: 100vh;
    }

    .login-img img {
      width: 100%;
      height: 100%;
      object-fit: cover;
      object-position: center;
    }

    .verification-card {
      background: white;
      border-radius: 12px;
      padding: 20px;
      margin-bottom: 16px;
      border: 2px solid #e0e0e0;
      transition: all 0.3s;
    }

    .verification-card.verified {
      border-color: #28a745;
      background: #f0f9f4;
    }

    .verification-card.pending {
      border-color: #FF9F43;
      background: #fffbf0;
    }

    .status-badge {
      display: inline-block;
      padding: 6px 12px;
      border-radius: 20px;
      font-size: 12px;
      font-weight: 600;
    }

    .status-badge.success {
      background: #28a745;
      color: white;
    }

    .status-badge.warning {
      background: #FF9F43;
      color: #000;
    }

    .btn {
      padding: 12px 20px;
      border-radius: 8px;
      font-size: 14px;
      font-weight: 600;
      transition: all 0.3s ease;
      border: none;
      cursor: pointer;
    }

    .btn-primary {
      background: #FF9F43;
      color: #fff;
    }

    .btn-primary:hover {
      background: #e88a2f;
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(255, 159, 67, 0.3);
    }

    .btn-success {
      background: #28a745;
      color: #fff;
    }

    .btn-success:hover {
      background: #218838;
      transform: translateY(-2px);
    }

    .btn-secondary {
      background: #6c757d;
      color: #fff;
    }

    .btn-secondary:hover {
      background: #5a6268;
      transform: translateY(-2px);
    }

    .btn-link {
      background: transparent;
      color: #FF9F43;
      padding: 5px 10px;
    }

    .btn-link:hover {
      color: #e88a2f;
      text-decoration: underline;
    }

    .form-control {
      width: 100%;
      padding: 12px 15px;
      border: 1px solid #e3e6f0;
      border-radius: 8px;
      font-size: 14px;
      transition: all 0.3s ease;
    }

    .form-control:focus {
      border-color: #FF9F43;
      outline: none;
      box-shadow: 0 0 0 0.2rem rgba(255, 159, 67, 0.15);
    }

    .progress {
      height: 30px;
      border-radius: 8px;
      overflow: hidden;
      background: #e9ecef;
    }

    .progress-bar {
      background: #FF9F43;
      font-size: 14px;
      font-weight: bold;
      line-height: 30px;
      transition: width 0.6s ease;
    }

    .progress-bar-success {
      background: #28a745 !important;
    }

    .cs_text_btn {
      color: #FF9F43;
      text-decoration: none;
      font-weight: 500;
      transition: all 0.3s ease;
    }

    .cs_text_btn:hover {
      color: #e88a2f;
      text-decoration: underline;
    }

    @media (max-width: 992px) {
      .login-img {
        display: none !important;
      }

      .login-content {
        flex: 1;
        width: 100%;
      }
    }
  </style>
</head>

<body class="account-page">
  <div class="main-wrapper">
    <div class="account-content">
      <div class="login-wrapper">
        <div class="login-content">
          <div class="login-logo"><img src="/asset/img/logo3.png" alt="Logo"></div>
          <div class="login-userheading">
            <h3>🔐 {{ __('verification.verify_your_account') }}</h3>
            <h4>{{ __('verification.verify_both_email_whatsapp') }}</h4>
          </div>
          <div class="row">
            <div class="col-md-6">
              <div class="verification-card {{ $business->email_verified_at ? 'verified' : 'pending' }}">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                  <h4 style="margin: 0; font-size: 16px;"><i class="fa fa-envelope"></i>
                    {{ __('verification.email_verification') }}</h4>
                  @if($business->email_verified_at)
                    <span class="status-badge success"><i class="fa fa-check"></i>
                      {{ __('verification.verified') }}</span>
                  @else
                    <span class="status-badge warning"><i class="fa fa-clock-o"></i>
                      {{ __('verification.pending') }}</span>
                  @endif
                </div>
                @if($business->email_verified_at)
                  <p style="color: #28a745; margin: 0; font-size: 14px;"><i class="fa fa-check-circle"></i>
                    {{ __('verification.verified_on', ['date' => \Carbon\Carbon::parse($business->email_verified_at)->format('M d, Y H:i')]) }}
                  </p>
                @else
                  <p style="color: #666; font-size: 13px; margin-bottom: 12px;">
                    {{ __('verification.email_verification_instruction') }} <strong id="current-email">{{ $business->owner->email }}</strong>
                  </p>
                  <p style="color: #999; font-size: 12px; margin-bottom: 12px;"><i class="fa fa-info-circle"></i>
                    {{ __('verification.link_expires_24_hours') }}</p>
                  <button type="button" id="resend-email-btn" class="btn btn-primary btn-block" style="margin-bottom: 8px;"><i
                      class="fa fa-paper-plane"></i> {{ __('verification.resend_verification_email') }}</button>
                  <button type="button" id="change-email-btn" class="btn btn-link btn-sm" style="padding: 5px; font-size: 12px;"><i
                      class="fa fa-edit"></i> Wrong email? Click to change</button>
                  
                  <!-- Hidden form for changing email -->
                  <div id="change-email-form" style="display: none; margin-top: 12px; padding: 12px; background: #f8f9fa; border-radius: 8px;">
                    <div class="form-group" style="margin-bottom: 10px;">
                      <label for="new-email" style="font-size: 13px; font-weight: 500;">New Email Address:</label>
                      <input type="email" id="new-email" class="form-control" placeholder="Enter new email address" style="font-size: 13px;">
                    </div>
                    <div style="display: flex; gap: 8px;">
                      <button type="button" id="update-email-btn" class="btn btn-success btn-sm" style="flex: 1;"><i class="fa fa-check"></i> Update Email</button>
                      <button type="button" id="cancel-email-change-btn" class="btn btn-secondary btn-sm" style="flex: 1;"><i class="fa fa-times"></i> Cancel</button>
                    </div>
                  </div>
                @endif
              </div>
            </div>
            <div class="col-md-6">
              <div class="verification-card {{ $business->whatsapp_verified_at ? 'verified' : 'pending' }}">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                  <h4 style="margin: 0; font-size: 16px;"><i class="fab fa-whatsapp"></i>
                    {{ __('verification.whatsapp_verification') }}</h4>
                  @if($business->whatsapp_verified_at)
                    <span class="status-badge success"><i class="fa fa-check"></i>
                      {{ __('verification.verified') }}</span>
                  @else
                    <span class="status-badge warning"><i class="fa fa-clock-o"></i>
                      {{ __('verification.pending') }}</span>
                  @endif
                </div>
                @if($business->whatsapp_verified_at)
                  <p style="color: #28a745; margin: 0; font-size: 14px;"><i class="fa fa-check-circle"></i>
                    {{ __('verification.verified_on', ['date' => \Carbon\Carbon::parse($business->whatsapp_verified_at)->format('M d, Y H:i')]) }}
                  </p>
                @else
                  @php $mobile = $business->locations()->first()->mobile ?? $business->owner->mobile ?? null; @endphp
                  @if(!empty($mobile))
                    <p style="color: #666; font-size: 13px; margin-bottom: 12px;">
                      {{ __('verification.whatsapp_verification_instruction') }}
                    </p>
                    <p style="color: #999; font-size: 12px; margin-bottom: 12px;">{{ __('verification.code_sent_to') }}
                      <strong><span id="masked-number"></span></strong><br><i class="fa fa-info-circle"></i>
                      {{ __('verification.code_expires_10_minutes') }}
                    </p>
                    <div class="form-group" style="margin-bottom: 12px;">
                      <input type="text" id="verification-code" class="form-control"
                        placeholder="{{ __('verification.enter_6_digit_code') }}" maxlength="6"
                        style="text-align: center; font-size: 18px; letter-spacing: 4px; font-weight: bold;">
                    </div>
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 8px;">
                      <button type="button" id="send-whatsapp-btn" class="btn btn-primary"><i class="fa fa-paper-plane"></i>
                        {{ __('verification.send_verification_code') }}</button>
                      <button type="button" id="verify-code-btn" class="btn btn-success"><i class="fa fa-check"></i>
                        {{ __('verification.verify_code') }}</button>
                    </div>
                    <button type="button" id="resend-whatsapp-btn" class="btn btn-link btn-sm"
                      style="margin-top: 8px; display: none;"><i class="fa fa-refresh"></i>
                      {{ __('verification.resend_code') }}</button>
                    <button type="button" id="change-whatsapp-btn" class="btn btn-link btn-sm" style="padding: 5px; font-size: 12px;"><i
                      class="fa fa-edit"></i> Wrong number? Click to change</button>
                    
                    <!-- Hidden form for changing WhatsApp -->
                    <div id="change-whatsapp-form" style="display: none; margin-top: 12px; padding: 12px; background: #f8f9fa; border-radius: 8px;">
                      <div class="form-group" style="margin-bottom: 10px;">
                        <label for="new-whatsapp" style="font-size: 13px; font-weight: 500;">New WhatsApp Number:</label>
                        <input type="tel" id="new-whatsapp" class="form-control" placeholder="Enter new WhatsApp number" style="font-size: 13px;">
                        <small style="color: #666; font-size: 11px;">Include country code (e.g., +234...)</small>
                      </div>
                      <div style="display: flex; gap: 8px;">
                        <button type="button" id="update-whatsapp-btn" class="btn btn-success btn-sm" style="flex: 1;"><i class="fa fa-check"></i> Update Number</button>
                        <button type="button" id="cancel-whatsapp-change-btn" class="btn btn-secondary btn-sm" style="flex: 1;"><i class="fa fa-times"></i> Cancel</button>
                      </div>
                    </div>
                  @else
                    <div class="alert alert-warning" style="margin: 0; text-align: left; font-size: 13px;"><i
                        class="fa fa-exclamation-triangle"></i> {{ __('verification.no_mobile_number') }}</div>
                  @endif
                @endif
              </div>
            </div>
          </div>
          @php $verified_count = ($business->email_verified_at ? 1 : 0) + ($business->whatsapp_verified_at ? 1 : 0);
          $progress = ($verified_count / 2) * 100; @endphp
          <div style="margin-top: 25px; padding: 18px; background: #f8f9fa; border-radius: 8px;">
            <p style="color: #666; margin-bottom: 10px; font-weight: 500; font-size: 
            14px;">
              {{ __('verification.verification_progress') }}: {{ $verified_count }}/2</p>
            <div class="progress">
              <div class="progress-bar {{ $progress == 100 ? 'progress-bar-success' : '' }}" role="progressbar"
                style="width: {{ $progress }}%;">{{ $progress }}%</div>
            </div>
          </div>
          <div
            style="margin-top: 18px; padding: 14px; background: #e7f3ff; border: 1px solid #b3d9ff; border-radius: 8px; text-align: left;">
            <p style="color: #004085; margin: 0; font-size: 13px;"><i class="fa fa-info-circle"></i>
              <strong>{{ __('verification.important') }}:</strong> {{ __('verification.both_verifications_required') }}
            </p>
          </div>
          <div style="margin-top: 25px; text-align: center;">
            <form action="{{ action([\App\Http\Controllers\Auth\LoginController::class, 'logout']) }}" method="POST" style="display: inline;">
              @csrf
              <button type="submit" class="cs_text_btn" style="background: none; border: none; cursor: pointer; color: #FF9F43; text-decoration: none; font-weight: 500;">
                <i class="fa fa-sign-out"></i> {{ __('verification.logout') }}
              </button>
            </form>
          </div>
        </div>
        <div class="login-img" oncontextmenu="return false;">

                     <img src="{{ asset('asset/img/verification.png') }}" alt="Verification" oncontextmenu="return false;" ondragstart="return false;">
        </div>
        <!-- <div class="login-img"><img src="/asset/img/authentication/register02.png" alt="Verification"></div> -->
      </div>
    </div>
  </div>
  <script src="{{ asset('asset/js/jquery.min.js') }}"></script>
  <script src="{{ asset('asset/js/bootstrap.bundle.min.js') }}"></script>
  <script>
    $(document).ready(function () {
      $.ajaxSetup({ headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') } });
      function maskMobile(mobile) { if (!mobile) return ''; let cleaned = mobile.replace(/\D/g, ''); if (cleaned.length > 4) { return cleaned.substring(0, 2) + '****' + cleaned.substring(cleaned.length - 4); } return mobile; }
      @php $mobile = $business->locations()->first()->mobile ?? $business->owner->mobile ?? null; @endphp
        @if(!empty($mobile)) $('#masked-number').text(maskMobile('{{ $mobile }}')); @endif
      function showToast(message, type = 'success') { const alertClass = type === 'success' ? 'alert-success' : 'alert-danger'; const icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle'; const alert = $(`<div class="alert ${alertClass}" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 300px; box-shadow: 0 5px 15px rgba(0,0,0,0.3); border-radius: 8px;"><i class="fa ${icon}"></i> ${message}</div>`); $('body').append(alert); setTimeout(() => alert.fadeOut(() => alert.remove()), 3000); }
      $('#resend-email-btn').click(function () { var btn = $(this); btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> {{ __("verification.sending") }}'); $.ajax({ url: '{{ route("superadmin.business.resend-email") }}', type: 'POST', success: function (response) { showToast(response.msg, response.success ? 'success' : 'error'); }, error: function () { showToast('{{ __("messages.something_went_wrong") }}', 'error'); }, complete: function () { btn.prop('disabled', false).html('<i class="fa fa-paper-plane"></i> {{ __("verification.resend_verification_email") }}'); } }); });
      $('#send-whatsapp-btn, #resend-whatsapp-btn').click(function () { var btn = $(this); var originalText = btn.html(); btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> {{ __("verification.sending") }}'); $.ajax({ url: '{{ route("superadmin.business.send-whatsapp-code") }}', type: 'POST', success: function (response) { showToast(response.msg, response.success ? 'success' : 'error'); if (response.success) $('#resend-whatsapp-btn').show(); }, error: function () { showToast('{{ __("messages.something_went_wrong") }}', 'error'); }, complete: function () { btn.prop('disabled', false).html(originalText); } }); });
      $('#verify-code-btn').click(function () { var code = $('#verification-code').val().trim(); if (code.length !== 6) { showToast('{{ __("verification.please_enter_6_digit_code") }}', 'error'); return; } var btn = $(this); btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> {{ __("verification.verifying") }}'); $.ajax({ url: '{{ route("superadmin.business.verify-whatsapp-code") }}', type: 'POST', data: { code: code }, success: function (response) { showToast(response.msg, response.success ? 'success' : 'error'); if (response.success) { setTimeout(() => window.location.href = response.redirect_url || location.href, 1500); } else { btn.prop('disabled', false).html('<i class="fa fa-check"></i> {{ __("verification.verify_code") }}'); } }, error: function () { showToast('{{ __("messages.something_went_wrong") }}', 'error'); btn.prop('disabled', false).html('<i class="fa fa-check"></i> {{ __("verification.verify_code") }}'); } }); });
      $('#verification-code').on('input', function () { this.value = this.value.replace(/[^0-9]/g, ''); });
      
      // Email change handlers
      $('#change-email-btn').click(function() { $('#change-email-form').slideDown(); $(this).hide(); });
      $('#cancel-email-change-btn').click(function() { $('#change-email-form').slideUp(); $('#change-email-btn').show(); $('#new-email').val(''); });
      $('#update-email-btn').click(function() { 
        var newEmail = $('#new-email').val().trim(); 
        if (!newEmail || !isValidEmail(newEmail)) { 
          showToast('Please enter a valid email address', 'error'); 
          return; 
        } 
        var btn = $(this); 
        btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Updating...'); 
        $.ajax({ 
          url: '{{ route("superadmin.business.update-email") }}', 
          type: 'POST', 
          data: { new_email: newEmail }, 
          success: function(response) { 
            showToast(response.msg, response.success ? 'success' : 'error'); 
            if (response.success) { 
              $('#current-email').text(response.new_email); 
              $('#change-email-form').slideUp(); 
              $('#change-email-btn').show(); 
              $('#new-email').val(''); 
            } 
          }, 
          error: function(xhr) { 
            var msg = xhr.responseJSON?.message || '{{ __("messages.something_went_wrong") }}'; 
            showToast(msg, 'error'); 
          }, 
          complete: function() { 
            btn.prop('disabled', false).html('<i class="fa fa-check"></i> Update Email'); 
          } 
        }); 
      });
      
      // WhatsApp change handlers
      $('#change-whatsapp-btn').click(function() { $('#change-whatsapp-form').slideDown(); $(this).hide(); });
      $('#cancel-whatsapp-change-btn').click(function() { $('#change-whatsapp-form').slideUp(); $('#change-whatsapp-btn').show(); $('#new-whatsapp').val(''); });
      $('#update-whatsapp-btn').click(function() { 
        var newNumber = $('#new-whatsapp').val().trim(); 
        if (!newNumber || newNumber.length < 10) { 
          showToast('Please enter a valid phone number', 'error'); 
          return; 
        } 
        var btn = $(this); 
        btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Updating...'); 
        $.ajax({ 
          url: '{{ route("superadmin.business.update-whatsapp") }}', 
          type: 'POST', 
          data: { new_whatsapp: newNumber }, 
          success: function(response) { 
            showToast(response.msg, response.success ? 'success' : 'error'); 
            if (response.success) { 
              $('#masked-number').text(response.new_number); 
              $('#change-whatsapp-form').slideUp(); 
              $('#change-whatsapp-btn').show(); 
              $('#new-whatsapp').val(''); 
            } 
          }, 
          error: function(xhr) { 
            var msg = xhr.responseJSON?.message || '{{ __("messages.something_went_wrong") }}'; 
            showToast(msg, 'error'); 
          }, 
          complete: function() { 
            btn.prop('disabled', false).html('<i class="fa fa-check"></i> Update Number'); 
          } 
        }); 
      });
      
      // Email validation helper
      function isValidEmail(email) { 
        return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email); 
      }
    });
  </script>
</body>

</html>