<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>{{ __('verification.verification_successful') }} - {{ config('app.name', 'POS') }}</title>
  <link rel="icon" href="/asset/img/logo.svg">
  <link rel="stylesheet" href="/asset/css/bootstrap.min.css">
  <link rel="stylesheet" href="/asset/css/fontawesome.min.css">
  <link rel="stylesheet" href="/asset/css/animate.css">
  <link rel="stylesheet" href="/asset/css/style.css">
</head>
<body>
  <div class="cs_register_page position-relative">
    <div class="container">
      <div class="cs_login_container text-center">
        <div class="cs_logo">
          <img src="/asset/img/logo3.png" alt="Logo">
        </div>

        <div class="cs_login_form">
          <div style="margin-bottom: 30px;">
            <i class="fa fa-check-circle" style="font-size: 80px; color: #28a745;"></i>
          </div>
          
          <h2 class="cs_login_heading" style="color: #28a745;">{{ __('verification.verification_successful') }}</h2>
          
          @if(isset($verificationType))
            <p style="color: #666; font-size: 16px; margin: 20px 0;">
              @if($verificationType === 'email')
                <i class="fa fa-envelope"></i> {{ __('verification.email_verified_successfully') }}
              @elseif($verificationType === 'whatsapp')
                <i class="fab fa-whatsapp"></i> {{ __('verification.whatsapp_verified_successfully') }}
              @else
                {{ __('verification.verification_completed') }}
              @endif
            </p>
          @else
            <p style="color: #666; font-size: 16px; margin: 20px 0;">
              {{ __('verification.verification_completed') }}
            </p>
          @endif

          <div style="background: #f0f9f4; border: 1px solid #28a745; border-radius: 8px; padding: 20px; margin: 30px 0; text-align: left;">
            <p style="color: #155724; margin: 0; font-size: 14px;">
              <strong>{{ __('verification.business_details') }}:</strong>
            </p>
            @if(isset($business))
              <ul style="color: #155724; margin-top: 10px; padding-left: 20px;">
                <li>{{ __('business.business_name') }}: <strong>{{ $business->name }}</strong></li>
                @if($business->owner)
                  <li>{{ __('user.email') }}: <strong>{{ $business->owner->email }}</strong></li>
                @endif
                @php
                  $verified_count = ($business->email_verified_at ? 1 : 0) + ($business->whatsapp_verified_at ? 1 : 0);
                @endphp
                <li>{{ __('verification.verified_methods') }}: <strong>{{ $verified_count }}/2</strong></li>
              </ul>
            @endif
          </div>

          @php
            $both_verified = isset($business) && $business->email_verified_at && $business->whatsapp_verified_at;
          @endphp

          @if($both_verified)
            <div style="background: #e7f3ff; border: 1px solid #b3d9ff; border-radius: 8px; padding: 15px; margin-bottom: 30px; text-align: left;">
              <p style="color: #004085; margin: 0; font-size: 14px;">
                <i class="fa fa-check-circle"></i>
                <strong>{{ __('verification.congratulations') }}!</strong>
                {{ __('verification.all_verifications_complete') }}
              </p>
            </div>

            <a href="{{ url('/home') }}" class="btn btn-primary btn-lg btn-block">
              <i class="fa fa-arrow-right"></i> {{ __('verification.continue_to_dashboard') }}
            </a>
          @else
            <div style="background: #fffbf0; border: 1px solid #ffc107; border-radius: 8px; padding: 15px; margin-bottom: 30px; text-align: left;">
              <p style="color: #856404; margin: 0; font-size: 14px;">
                <i class="fa fa-info-circle"></i>
                <strong>{{ __('verification.one_more_step') }}!</strong>
                {{ __('verification.complete_remaining_verification') }}
              </p>
            </div>

            @php
              $moduleUtil = app(\App\Utils\ModuleUtil::class);
              $is_superadmin = $moduleUtil->isSuperadminInstalled();
              $verification_route = $is_superadmin ? 'superadmin.business.verification' : 'business.verification';
            @endphp

            <a href="{{ route($verification_route) }}" class="btn btn-warning btn-lg btn-block">
              <i class="fa fa-arrow-left"></i> {{ __('verification.back_to_verification') }}
            </a>
          @endif

          <div style="margin-top: 30px;">
            <form action="{{ action([\App\Http\Controllers\Auth\LoginController::class, 'logout']) }}" method="POST" style="display: inline;">
              @csrf
              <button type="submit" class="cs_text_btn" style="background: none; border: none; cursor: pointer; color: inherit; font: inherit; padding: 0;">
                <i class="fa fa-sign-out"></i> {{ __('verification.logout') }}
              </button>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</body>
</html>
