@extends('layouts.app')
@section('title', __('superadmin::lang.whatsapp_settings'))

@section('content')
@include('superadmin::layouts.nav')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('superadmin::lang.whatsapp_settings')
        <small>@lang('superadmin::lang.manage_whatsapp_notifications')</small>
    </h1>
</section>

<!-- Main content -->
<section class="content">
    @if(session('status'))
        <div class="row">
            <div class="col-md-12">
                @if(session('status')['success'] == 1)
                    <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        {{ session('status')['msg'] }}
                    </div>
                @else
                    <div class="alert alert-danger alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        {{ session('status')['msg'] }}
                    </div>
                @endif
            </div>
        </div>
    @endif

    <div class="row">
        <div class="col-md-8">
            <div class="box box-solid">
                <div class="box-header with-border">
                    <h3 class="box-title">@lang('superadmin::lang.whatsapp_configuration')</h3>
                </div>
                <form action="{{ route('superadmin.whatsapp.update') }}" method="POST">
                    @csrf
                    <div class="box-body">
                        <div class="form-group">
                            <label>
                                {!! Form::checkbox('enabled', 1, $settings['enabled'], ['class' => 'input-icheck']); !!}
                                @lang('superadmin::lang.enable_whatsapp_notifications')
                            </label>
                            <p class="help-block">@lang('superadmin::lang.enable_whatsapp_help')</p>
                        </div>

                        <div class="form-group">
                            <label for="api_url">@lang('superadmin::lang.whatsapp_api_url') *</label>
                            <input type="url" 
                                   class="form-control" 
                                   id="api_url" 
                                   name="api_url" 
                                   value="{{ old('api_url', $settings['api_url']) }}"
                                   placeholder="https://your-whatsapp-api.com/send">
                            @if($errors->has('api_url'))
                                <span class="text-danger">{{ $errors->first('api_url') }}</span>
                            @endif
                            <p class="help-block">@lang('superadmin::lang.whatsapp_api_url_help')</p>
                        </div>

                        <div class="form-group">
                            <label for="token">@lang('superadmin::lang.whatsapp_api_token') *</label>
                            <input type="text" 
                                   class="form-control" 
                                   id="token" 
                                   name="token" 
                                   value="{{ old('token', $settings['token']) }}"
                                   placeholder="Your API Token">
                            @if($errors->has('token'))
                                <span class="text-danger">{{ $errors->first('token') }}</span>
                            @endif
                            <p class="help-block">@lang('superadmin::lang.whatsapp_api_token_help')</p>
                        </div>
                    </div>
                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fa fa-save"></i> @lang('messages.save')
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <div class="col-md-4">
            <div class="box box-solid">
                <div class="box-header with-border">
                    <h3 class="box-title">@lang('superadmin::lang.test_whatsapp')</h3>
                </div>
                <form action="{{ route('superadmin.whatsapp.test') }}" method="POST">
                    @csrf
                    <div class="box-body">
                        <div class="form-group">
                            <label for="test_phone">@lang('superadmin::lang.phone_number')</label>
                            <input type="text" 
                                   class="form-control" 
                                   id="test_phone" 
                                   name="test_phone" 
                                   placeholder="2348123456789"
                                   required>
                            <p class="help-block">@lang('superadmin::lang.phone_number_help')</p>
                        </div>
                    </div>
                    <div class="box-footer">
                        <button type="submit" class="btn btn-success">
                            <i class="fa fa-paper-plane"></i> @lang('superadmin::lang.send_test_message')
                        </button>
                    </div>
                </form>
            </div>

            <div class="box box-solid">
                <div class="box-header with-border">
                    <h3 class="box-title">@lang('superadmin::lang.information')</h3>
                </div>
                <div class="box-body">
                    <p><strong>@lang('superadmin::lang.supported_notifications'):</strong></p>
                    <ul>
                        <li>@lang('superadmin::lang.new_business_registration')</li>
                        <li>@lang('superadmin::lang.new_subscription')</li>
                        <li>@lang('superadmin::lang.subscription_expiry_alert')</li>
                        <li>@lang('superadmin::lang.offline_payment_confirmation')</li>
                        <li>@lang('superadmin::lang.password_update')</li>
                        <li>@lang('superadmin::lang.communicator_messages')</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
