<?php

// use App\Http\Controllers\BusinessController;
// use App\Http\Controllers\Modules;
// use Illuminate\Support\Facades\Route;

Route::get('/pricing', [Modules\Superadmin\Http\Controllers\PricingController::class, 'index'])->name('pricing');
Route::get('/package-duration-update', [Modules\Superadmin\Http\Controllers\PricingController::class, 'package_duration_update'])->name('package_duration_update');

// WhatsApp Webhook Routes (No Auth - External API calls)
Route::prefix('webhooks')->name('webhooks.')->group(function () {
    Route::post('/whatsapp', [Modules\Superadmin\Http\Controllers\WhatsAppWebhookController::class, 'handleWebhook'])->name('whatsapp');
    Route::get('/whatsapp/verify', [Modules\Superadmin\Http\Controllers\WhatsAppWebhookController::class, 'verifyWebhook'])->name('whatsapp.verify');
    
    // Test endpoint (development only)
    if (config('app.env') === 'local' || config('app.env') === 'development') {
        Route::post('/whatsapp/test', [Modules\Superadmin\Http\Controllers\WhatsAppWebhookController::class, 'testMessage'])->name('whatsapp.test');
    }
});

Route::middleware('web', 'auth', 'language', 'AdminSidebarMenu', 'superadmin')->prefix('superadmin')->group(function () {
    Route::get('/install', [Modules\Superadmin\Http\Controllers\InstallController::class, 'index']);
    Route::post('/install', [Modules\Superadmin\Http\Controllers\InstallController::class, 'install']);
    Route::get('/install/update', [Modules\Superadmin\Http\Controllers\InstallController::class, 'update']);
    Route::get('/install/uninstall', [Modules\Superadmin\Http\Controllers\InstallController::class, 'uninstall']);
    Route::post('/install/update', [Modules\Superadmin\Http\Controllers\InstallController::class, 'updateExecute']);

    Route::get('/', [Modules\Superadmin\Http\Controllers\SuperadminController::class, 'index']);
    Route::get('/stats', [Modules\Superadmin\Http\Controllers\SuperadminController::class, 'stats']);

    Route::get('/{business_id}/toggle-active/{is_active}', [Modules\Superadmin\Http\Controllers\BusinessController::class, 'toggleActive']);

    Route::get('/users/{business_id}', [Modules\Superadmin\Http\Controllers\BusinessController::class, 'usersList']);
    Route::post('/update-password', [Modules\Superadmin\Http\Controllers\BusinessController::class, 'updatePassword']);

    // Custom Domain Management Routes
    Route::get('/custom-domains', function() {
        return view('superadmin::custom-domains.index');
    })->name('superadmin.domains.index');
    Route::get('/custom-domains/pending', [Modules\Superadmin\Http\Controllers\BusinessController::class, 'pendingDomains'])->name('superadmin.domains.pending');
    Route::post('/custom-domains/{id}/verify', [Modules\Superadmin\Http\Controllers\BusinessController::class, 'verifyCustomDomain'])->name('superadmin.domains.verify');
    Route::post('/custom-domains/{id}/reject', [Modules\Superadmin\Http\Controllers\BusinessController::class, 'rejectCustomDomain'])->name('superadmin.domains.reject');

    Route::resource('/business', Modules\Superadmin\Http\Controllers\BusinessController::class);
    Route::get('/business/{id}/destroy', [Modules\Superadmin\Http\Controllers\BusinessController::class, 'destroy']);

    Route::resource('/packages', 'Modules\Superadmin\Http\Controllers\PackagesController');
    Route::get('/packages/{id}/destroy', [Modules\Superadmin\Http\Controllers\PackagesController::class, 'destroy']);

    Route::resource('/coupons', 'Modules\Superadmin\Http\Controllers\CouponController');
    Route::get('/coupons/{id}/destroy', [Modules\Superadmin\Http\Controllers\CouponController::class, 'destroy']);
    
    Route::get('/settings', [Modules\Superadmin\Http\Controllers\SuperadminSettingsController::class, 'edit']);
    Route::put('/settings', [Modules\Superadmin\Http\Controllers\SuperadminSettingsController::class, 'update']);
    Route::post('/whatsapp-settings', [Modules\Superadmin\Http\Controllers\SuperadminSettingsController::class, 'whatsappSettings'])->name('superadmin.whatsapp-settings');
    Route::get('/edit-subscription/{id}', [Modules\Superadmin\Http\Controllers\SuperadminSubscriptionsController::class, 'editSubscription']);
    Route::post('/update-subscription', [Modules\Superadmin\Http\Controllers\SuperadminSubscriptionsController::class, 'updateSubscription']);
    Route::get('/subscription/{id}/view-proof', [Modules\Superadmin\Http\Controllers\SuperadminSubscriptionsController::class, 'viewProofOfPayment'])->name('superadmin.subscription.view-proof');
    Route::resource('/superadmin-subscription', 'Modules\Superadmin\Http\Controllers\SuperadminSubscriptionsController');

    Route::get('/communicator', [Modules\Superadmin\Http\Controllers\CommunicatorController::class, 'index']);
    Route::post('/communicator/send', [Modules\Superadmin\Http\Controllers\CommunicatorController::class, 'send']);
    Route::get('/communicator/get-history', [Modules\Superadmin\Http\Controllers\CommunicatorController::class, 'getHistory']);

    Route::resource('/frontend-pages', 'Modules\Superadmin\Http\Controllers\PageController');

    // Support Tickets - Superadmin Management
    Route::prefix('support-tickets')->name('superadmin.support-tickets.')->group(function () {
        Route::get('/', [Modules\Superadmin\Http\Controllers\SuperadminSupportTicketController::class, 'index'])->name('index');
        Route::get('/create', [Modules\Superadmin\Http\Controllers\SuperadminSupportTicketController::class, 'create'])->name('create');
        Route::post('/', [Modules\Superadmin\Http\Controllers\SuperadminSupportTicketController::class, 'store'])->name('store');
        Route::get('/{id}', [Modules\Superadmin\Http\Controllers\SuperadminSupportTicketController::class, 'show'])->name('show');
        Route::post('/{id}/assign', [Modules\Superadmin\Http\Controllers\SuperadminSupportTicketController::class, 'assign'])->name('assign');
        Route::post('/{id}/respond', [Modules\Superadmin\Http\Controllers\SuperadminSupportTicketController::class, 'respond'])->name('respond');
        Route::post('/{id}/update-status', [Modules\Superadmin\Http\Controllers\SuperadminSupportTicketController::class, 'updateStatus'])->name('update-status');
        Route::post('/{id}/resolve', [Modules\Superadmin\Http\Controllers\SuperadminSupportTicketController::class, 'resolve'])->name('resolve');
    });
});

// Business Verification Routes (Public - No Auth Required for Email Verification)
Route::get('/verify-email/{token}', [Modules\Superadmin\Http\Controllers\BusinessVerificationController::class, 'verifyEmail'])
    ->name('superadmin.business.verify-email');

// Business Verification Routes (Authenticated)
Route::middleware('web', 'SetSessionData', 'auth')->group(function () {
    Route::get('/business-verification', [Modules\Superadmin\Http\Controllers\BusinessVerificationController::class, 'index'])
        ->name('superadmin.business.verification');
    
    Route::post('/resend-email-verification', [Modules\Superadmin\Http\Controllers\BusinessVerificationController::class, 'resendEmail'])
        ->name('superadmin.business.resend-email');
    
    Route::post('/send-whatsapp-code', [Modules\Superadmin\Http\Controllers\BusinessVerificationController::class, 'sendWhatsAppCode'])
        ->name('superadmin.business.send-whatsapp-code');
    
    Route::post('/verify-whatsapp-code', [Modules\Superadmin\Http\Controllers\BusinessVerificationController::class, 'verifyWhatsAppCode'])
        ->name('superadmin.business.verify-whatsapp-code');
    
    Route::post('/update-email', [Modules\Superadmin\Http\Controllers\BusinessVerificationController::class, 'updateEmail'])
        ->name('superadmin.business.update-email');
    
    Route::post('/update-whatsapp', [Modules\Superadmin\Http\Controllers\BusinessVerificationController::class, 'updateWhatsApp'])
        ->name('superadmin.business.update-whatsapp');
    
    // Manual Verification Routes
    Route::get('/business/{id}/manual-verification', [Modules\Superadmin\Http\Controllers\BusinessController::class, 'showManualVerification'])
        ->name('superadmin.business.show-manual-verification');
    
    Route::post('/business/{id}/manual-verify', [Modules\Superadmin\Http\Controllers\BusinessController::class, 'manualVerify'])
        ->name('superadmin.business.manual-verify');
});

Route::middleware('web', 'SetSessionData', 'auth', 'language', 'timezone', 'AdminSidebarMenu')->group(function () {
    // Support Tickets - Business Management
    Route::prefix('support-tickets')->name('support-tickets.')->group(function () {
        Route::get('/', [Modules\Superadmin\Http\Controllers\SupportTicketController::class, 'index'])->name('index');
        Route::get('/create', [Modules\Superadmin\Http\Controllers\SupportTicketController::class, 'create'])->name('create');
        Route::post('/', [Modules\Superadmin\Http\Controllers\SupportTicketController::class, 'store'])->name('store');
        Route::get('/{id}', [Modules\Superadmin\Http\Controllers\SupportTicketController::class, 'show'])->name('show');
        Route::post('/{id}/reply', [Modules\Superadmin\Http\Controllers\SupportTicketController::class, 'reply'])->name('reply');
        Route::post('/{id}/close', [Modules\Superadmin\Http\Controllers\SupportTicketController::class, 'close'])->name('close');
    });

    //Routes related to paypal checkout
    Route::post('/paypal-express-checkout', [Modules\Superadmin\Http\Controllers\SubscriptionController::class, 'paypalExpressCheckout'])->name('paypalExpressCheckout');

    Route::post('/capture-paypal-order', [Modules\Superadmin\Http\Controllers\SubscriptionController::class, 'capturePaypalOrder'])->name('capturePaypalOrder');


    Route::get('/subscription/post-flutterwave-payment', [Modules\Superadmin\Http\Controllers\SubscriptionController::class, 'postFlutterwavePaymentCallback']);

    Route::post('/subscription/pay-stack', [Modules\Superadmin\Http\Controllers\SubscriptionController::class, 'getRedirectToPaystack']);
    Route::get('/subscription/post-payment-pay-stack-callback', [Modules\Superadmin\Http\Controllers\SubscriptionController::class, 'postPaymentPaystackCallback']);

    //Routes related to pesapal checkout
    Route::get('/subscription/{package_id}/pesapal-callback', [Modules\Superadmin\Http\Controllers\SubscriptionController::class, 'pesapalCallback'])->name('pesapalCallback');

    Route::get('/subscription/{package_id}/pay', [Modules\Superadmin\Http\Controllers\SubscriptionController::class, 'pay']);
    Route::any('/subscription/{package_id?}/confirm', [Modules\Superadmin\Http\Controllers\SubscriptionController::class, 'confirm'])->name('subscription-confirm');
    Route::get('/all-subscriptions', [Modules\Superadmin\Http\Controllers\SubscriptionController::class, 'allSubscriptions']);

    Route::get('/subscription/{package_id}/register-pay', [Modules\Superadmin\Http\Controllers\SubscriptionController::class, 'registerPay'])->name('register-pay');

    Route::resource('/subscription', 'Modules\Superadmin\Http\Controllers\SubscriptionController');

    Route::get('/subscription/{subcription_id}/force-active', [Modules\Superadmin\Http\Controllers\SubscriptionController::class, 'forceActive'])->name('force-active');
    Route::get('/myfatoorah-callback', [Modules\Superadmin\Http\Controllers\SubscriptionController::class, 'myfatoorahcallback'])->name('myfatoorah_callback');

});

Route::get('/page/{slug}', [Modules\Superadmin\Http\Controllers\PageController::class, 'showPage'])->name('frontend-pages');
