# Central Bot Number Test Guide

## Quick Test Steps

### 1. Configure Environment
Add to `.env`:
```env
WHATSAPP_CENTRAL_BOT_ENABLED=true
WHATSAPP_CENTRAL_BOT_NUMBER=+2348012345678
WHATSAPP_PHONE_MAPPING=central_bot
```

### 2. Test Messages
Send these messages TO the central bot number:

**First Message (Business Identification):**
```
"Test Business today sales"
```
Expected: Bot identifies "Test Business" and shows sales + remembers preference

**Follow-up Message (Memory Test):**
```
"today profit"
```
Expected: Bot uses remembered business and shows profit

**Different Business:**
```
"Another Store send report"
```
Expected: Bot switches to "Another Store" and updates preference

### 3. Database Check
```sql
-- Check user business preferences
SELECT * FROM whatsapp_user_businesses;

-- Should show user_phone and business_id mappings
```

### 4. Log Verification
Check logs for:
- Business resolution messages
- User preference saving
- Central bot mode activation

## Expected Behavior
1. ✅ Users send TO central bot number
2. ✅ First message includes business name
3. ✅ Bot identifies and remembers business
4. ✅ Future messages use remembered business
5. ✅ Different business names switch context
6. ✅ All responses go back to sender's WhatsApp