<?php

return [
    'name' => 'WhatsAppBot',
    
    // Module version
    'module_version' => '1.0.2',
    
    // NearBuyMarts API Configuration
    'nodeurl' => env('WHATSAPP_SEND_NODEURL', 'https://api.nearbuymarts.com/send'),
    'token' => env('WHATSAPP_SEND_TOKEN', 'UzgsBoKOeg6Y9w1JeIda'),
    'mediaurl' => env('WHATSAPP_MEDIA_URL', 'https://app.nearbuymarts.com/public/app-assets/images/logo/logo.png'),
    
    // Central Bot Configuration
    'central_bot_enabled' => env('WHATSAPP_CENTRAL_BOT_ENABLED', true),
    'central_bot_number' => env('WHATSAPP_CENTRAL_BOT_NUMBER', null),
    
    // SECURITY: Webhook verification (REQUIRED for production)
    // Generate a strong random token: php artisan tinker --execute="echo bin2hex(random_bytes(32));"
    'verify_webhook_token' => env('WHATSAPP_WEBHOOK_VERIFY_TOKEN'),
    
    // Business phone mapping methods
    // 'central_bot' - Messages sent TO central bot, business identified by phone/command
    // 'business_table' - Messages sent FROM business WhatsApp (legacy method)
    'phone_mapping_method' => env('WHATSAPP_PHONE_MAPPING', 'central_bot'),
    
    // Logging
    'log_incoming_messages' => env('WHATSAPP_LOG_INCOMING', true),
    'log_outgoing_messages' => env('WHATSAPP_LOG_OUTGOING', true),
    
    // SECURITY: Rate limiting
    'rate_limit_webhook' => env('WHATSAPP_RATE_LIMIT_WEBHOOK', 60), // requests per minute per IP
    'rate_limit_api' => env('WHATSAPP_RATE_LIMIT_API', 30), // test messages per minute
    
    // SECURITY: File security
    'max_pdf_size' => env('WHATSAPP_MAX_PDF_SIZE', 10485760), // 10MB in bytes
    'pdf_cleanup_hours' => env('WHATSAPP_PDF_CLEANUP_HOURS', 24),
    
    // SECURITY: Message limits
    'max_message_length' => env('WHATSAPP_MAX_MESSAGE_LENGTH', 4096),
    'max_phone_length' => env('WHATSAPP_MAX_PHONE_LENGTH', 20),
];
