<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPhoneColumnsToBusinessTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('business', function (Blueprint $table) {
            // Only add whatsapp_enabled flag since whatsapp_phone already exists from another migration
            // We'll use existing whatsapp_phone column for WhatsApp integration
            if (!Schema::hasColumn('business', 'whatsapp_enabled')) {
                $table->boolean('whatsapp_enabled')->default(false);
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('business', function (Blueprint $table) {
            if (Schema::hasColumn('business', 'whatsapp_enabled')) {
                $table->dropColumn('whatsapp_enabled');
            }
        });
    }
}
