<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateWhatsappBotLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('whatsapp_bot_logs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('business_id')->unsigned();
            $table->string('phone', 32);
            $table->enum('direction', ['incoming', 'outgoing'])->default('incoming');
            $table->text('message')->nullable();
            $table->json('payload')->nullable();
            $table->string('status', 50)->nullable();
            $table->text('response')->nullable();
            $table->timestamp('processed_at')->nullable();
            $table->timestamps();
            
            // Indexes
            $table->index('business_id');
            $table->index('phone');
            $table->index('direction');
            $table->index('created_at');
            
            // Foreign key
            $table->foreign('business_id')
                  ->references('id')
                  ->on('business')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('whatsapp_bot_logs');
    }
}
