# WhatsApp Bot Module - Quick Start Guide

## ⚡ 5-Minute Setup

### 1️⃣ Run Migrations (30 seconds)

```bash
cd /Users/engrabiolaadebowale/Downloads/UpdateJEB6.8.1/jebbms-oct-2025
php artisan migrate
```

This creates:
- `phone`, `owner_phone`, `whatsapp_enabled` columns in `business` table
- `whatsapp_bot_logs` table for message history

### 2️⃣ Configure Environment (1 minute)

Add to your `.env` file:

```env
WHATSAPP_SEND_NODEURL=https://api.nearbuymarts.com/send
WHATSAPP_SEND_TOKEN=UzgsBoKOeg6Y9w1JeIda
WHATSAPP_MEDIA_URL=https://app.nearbuymarts.com/public/app-assets/images/logo/logo.png
```

### 3️⃣ Add Your Business Phone (30 seconds)

Run this SQL (replace with your details):

```sql
UPDATE business 
SET phone = '+2348012345678',
    owner_phone = '+2348012345678',
    whatsapp_enabled = 1
WHERE id = 1;
```

**Important:** Use international format with `+` and country code!

### 4️⃣ Configure NearBuyMarts Webhook (2 minutes)

1. Go to https://nearbuymarts.com/dashboard
2. Navigate to: API Settings → Webhooks
3. Click "Add Webhook"
4. Enter URL: `https://yourdomain.com/api/webhook/whatsapp`
5. Method: `POST`
6. Save

**Replace `yourdomain.com` with your actual domain!**

### 5️⃣ Test It! (1 minute)

**Option A: Via Admin Panel**
1. Visit: `https://yourdomain.com/whatsappbot`
2. Enter your phone number
3. Type: "Test message"
4. Click "Send"

**Option B: Via WhatsApp**
1. Open WhatsApp on your phone
2. Send message to your business WhatsApp number
3. Type: "What's today's sales?"
4. Receive instant business data!

## 📱 Try These Commands

**Sales:**
- "What's today's sales?"
- "Show yesterday's sales"
- "This week's sales"

**Profit:**
- "What's today's profit?"
- "This month's profit"

**Reports:**
- "Send report"
- "Top products"

**Help:**
- "Help"
- "Commands"

## ✅ Verification Checklist

- [ ] Migrations completed successfully
- [ ] .env variables added
- [ ] Business phone number configured (with +234 or your country code)
- [ ] NearBuyMarts webhook URL registered
- [ ] Test message sent and received
- [ ] WhatsApp query responded correctly

## 🔧 Quick Troubleshooting

### No Response from Bot?

**Check phone format:**
```sql
SELECT id, name, phone FROM business;
```
Phone must be: `+2348012345678` (not `08012345678`)

**Fix phone format:**
```sql
UPDATE business SET phone = '+2348012345678' WHERE id = 1;
```

### Webhook Not Working?

**Test manually:**
```bash
curl -X POST https://yourdomain.com/api/webhook/whatsapp \
  -H "Content-Type: application/json" \
  -d '{"sender":"+2348012345678","message":"test"}'
```

Expected response: `{"status":"ok","message":"Message received and processed"}`

### Check Logs:

```bash
tail -f storage/logs/laravel.log | grep WhatsAppBot
```

Look for:
- `WhatsAppBot: Incoming webhook` - Message received
- `WhatsAppBot: Business resolved` - Business found
- `WhatsAppBot: Message sent successfully` - Response sent

## 📊 Sample Responses

**Sales Query:**
```
🛒 Today's Sales - My Store

Date: 06 Nov 2024
Total Sales: ₦125,450.00
Transactions: 23

Generated at: 03:14 PM
```

**Profit Query:**
```
💰 Today's Profit - My Store

Date: 06 Nov 2024
Sales: ₦125,450.00
Purchases: ₦98,320.00
Profit: ₦27,130.00

Generated at: 03:14 PM
```

**Full Report:**
```
📊 Daily Business Report
My Store
━━━━━━━━━━━━━━━━━━

📅 Date: 06 November 2024

💵 Financial Summary:
Total Sales: ₦125,450.00
Total Purchases: ₦98,320.00
Net Profit: ₦27,130.00

📈 Transaction Summary:
Total Transactions: 23
Average Sale: ₦5,454.78

━━━━━━━━━━━━━━━━━━
Generated: 06 Nov 2024 03:14 PM

Thank you for using JebbMS! 🎉
```

## 🎯 Next Steps

1. **Add More Businesses:** Repeat step 3 for each business location
2. **Train Staff:** Share command list with business owners
3. **Monitor Usage:** Check `whatsapp_bot_logs` table for activity
4. **Customize:** Edit queries in `Services/WhatsAppBotService.php`
5. **Enhance:** Add more query types, scheduled reports, etc.

## 📞 Support

- **Documentation:** `/Modules/WhatsAppBot/README.md`
- **Installation Guide:** `/Modules/WhatsAppBot/INSTALLATION.md`
- **Email:** support@jebbms.com

## 🎉 You're All Set!

Your WhatsApp Bot is now live and ready to serve business intelligence queries!

**Pro Tip:** Save your business WhatsApp number and send yourself a "help" message to see all available commands.
