@extends('layouts.app')

@section('title', __('WhatsApp Bot'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('whatsappbot::lang.whatsapp_bot')
        <small>@lang('whatsappbot::lang.manage_whatsapp_bot')</small>
    </h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <!-- Configuration Card -->
        <div class="col-md-6">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        <i class="fa fa-cog"></i> @lang('whatsappbot::lang.configuration')
                    </h3>
                </div>
                <div class="box-body">
                    <table class="table table-striped">
                        <tr>
                            <td><strong>@lang('whatsappbot::lang.api_endpoint'):</strong></td>
                            <td>{{ config('whatsappbot.nodeurl') }}</td>
                        </tr>
                        <tr>
                            <td><strong>@lang('whatsappbot::lang.webhook_url'):</strong></td>
                            <td>
                                <code>{{ url('/api/webhook/whatsapp') }}</code>
                                <button class="btn btn-xs btn-info" onclick="copyToClipboard('{{ url('/api/webhook/whatsapp') }}')">
                                    <i class="fa fa-copy"></i> @lang('whatsappbot::lang.copy')
                                </button>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>@lang('whatsappbot::lang.status'):</strong></td>
                            <td>
                                @if(config('whatsappbot.token'))
                                    <span class="label label-success">
                                        <i class="fa fa-check"></i> @lang('whatsappbot::lang.configured')
                                    </span>
                                @else
                                    <span class="label label-danger">
                                        <i class="fa fa-times"></i> @lang('whatsappbot::lang.not_configured')
                                    </span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td><strong>@lang('whatsappbot::lang.business_phone'):</strong></td>
                            <td>
                                @if($business_phone)
                                    {{ $business_phone }}
                                @else
                                    <span class="text-warning">
                                        <i class="fa fa-exclamation-triangle"></i> @lang('whatsappbot::lang.no_phone_configured')
                                    </span>
                                @endif
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <!-- Test Message Card -->
        <div class="col-md-6">
            <div class="box box-success">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        <i class="fa fa-paper-plane"></i> @lang('whatsappbot::lang.send_test_message')
                    </h3>
                </div>
                <form id="test-message-form">
                    <div class="box-body">
                        <div class="form-group">
                            <label>@lang('whatsappbot::lang.phone_number')</label>
                            <input type="text" name="phone" class="form-control" 
                                   placeholder="+2348012345678" required>
                            <p class="help-block">@lang('whatsappbot::lang.phone_help')</p>
                        </div>
                        <div class="form-group">
                            <label>@lang('whatsappbot::lang.message')</label>
                            <textarea name="message" class="form-control" rows="4" 
                                      placeholder="@lang('whatsappbot::lang.message_placeholder')" required></textarea>
                        </div>
                    </div>
                    <div class="box-footer">
                        <button type="submit" class="btn btn-success">
                            <i class="fa fa-paper-plane"></i> @lang('whatsappbot::lang.send')
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Available Commands Card -->
    <div class="row">
        <div class="col-md-12">
            <div class="box box-info">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        <i class="fa fa-list"></i> @lang('whatsappbot::lang.available_commands')
                    </h3>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h4><i class="fa fa-shopping-cart"></i> @lang('whatsappbot::lang.sales_queries')</h4>
                            <ul class="list-unstyled">
                                <li><code>What's today's sales?</code></li>
                                <li><code>Show yesterday's sales</code></li>
                                <li><code>This week's sales</code></li>
                                <li><code>This month's sales</code></li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h4><i class="fa fa-money"></i> @lang('whatsappbot::lang.profit_queries')</h4>
                            <ul class="list-unstyled">
                                <li><code>What's today's profit?</code></li>
                                <li><code>Yesterday's profit</code></li>
                                <li><code>This week's profit</code></li>
                                <li><code>This month's profit</code></li>
                            </ul>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <h4><i class="fa fa-bar-chart"></i> @lang('whatsappbot::lang.reports')</h4>
                            <ul class="list-unstyled">
                                <li><code>Send report</code></li>
                                <li><code>Full report</code></li>
                                <li><code>Top products</code></li>
                                <li><code>Best selling items</code></li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h4><i class="fa fa-question-circle"></i> @lang('whatsappbot::lang.help')</h4>
                            <ul class="list-unstyled">
                                <li><code>Help</code></li>
                                <li><code>Commands</code></li>
                                <li><code>What can you do?</code></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Setup Instructions -->
    <div class="row">
        <div class="col-md-12">
            <div class="box box-warning collapsed-box">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        <i class="fa fa-book"></i> @lang('whatsappbot::lang.setup_instructions')
                    </h3>
                    <div class="box-tools pull-right">
                        <button type="button" class="btn btn-box-tool" data-widget="collapse">
                            <i class="fa fa-plus"></i>
                        </button>
                    </div>
                </div>
                <div class="box-body">
                    <ol>
                        <li>
                            <strong>@lang('whatsappbot::lang.step1'):</strong>
                            @lang('whatsappbot::lang.step1_desc')
                        </li>
                        <li>
                            <strong>@lang('whatsappbot::lang.step2'):</strong>
                            @lang('whatsappbot::lang.step2_desc')
                        </li>
                        <li>
                            <strong>@lang('whatsappbot::lang.step3'):</strong>
                            @lang('whatsappbot::lang.step3_desc')
                            <code>{{ url('/api/webhook/whatsapp') }}</code>
                        </li>
                        <li>
                            <strong>@lang('whatsappbot::lang.step4'):</strong>
                            @lang('whatsappbot::lang.step4_desc')
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

</section>

@endsection

@section('javascript')
<script type="text/javascript" data-cfasync="false">
    // Cache buster: v1.4 - Use web route instead of API route
    var WHATSAPP_TEST_URL = '{{ route("whatsappbot.send-test") }}';
    
    console.log('WhatsApp Test URL:', WHATSAPP_TEST_URL);
    
    $(document).ready(function() {
        // Handle test message form submission
        $('#test-message-form').on('submit', function(e) {
            e.preventDefault();
            
            var phone = $('input[name="phone"]').val();
            var message = $('textarea[name="message"]').val();
            
            $.ajax({
                url: WHATSAPP_TEST_URL,
                type: 'POST',
                data: {
                    phone: phone,
                    message: message,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    toastr.success('@lang("whatsappbot::lang.test_message_sent")');
                    $('#test-message-form')[0].reset();
                },
                error: function(xhr) {
                    console.error('Error:', xhr.status, xhr.statusText);
                    console.error('URL attempted:', WHATSAPP_TEST_URL);
                    var error = xhr.responseJSON ? xhr.responseJSON.message : '@lang("whatsappbot::lang.test_message_failed")';
                    toastr.error(error);
                }
            });
        });
    });
    
    function copyToClipboard(text) {
        var temp = $('<input>');
        $('body').append(temp);
        temp.val(text).select();
        document.execCommand('copy');
        temp.remove();
        toastr.success('@lang("whatsappbot::lang.copied_to_clipboard")');
    }
</script>
@endsection
