@extends('layouts.app')

@section('title', __('whatsappbot::lang.logs'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('whatsappbot::lang.whatsapp_bot')
        <small>@lang('whatsappbot::lang.logs')</small>
    </h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        <i class="fa fa-list"></i> @lang('whatsappbot::lang.message_logs')
                    </h3>
                    <div class="box-tools pull-right">
                        <button type="button" class="btn btn-default btn-sm" onclick="refreshLogs()">
                            <i class="fa fa-refresh"></i> @lang('whatsappbot::lang.refresh')
                        </button>
                    </div>
                </div>
                <div class="box-body">
                    <div class="alert alert-info">
                        <i class="fa fa-info-circle"></i>
                        @lang('whatsappbot::lang.logs_info')
                    </div>
                    
                    <!-- Tabs for different log types -->
                    <ul class="nav nav-tabs" role="tablist">
                        <li role="presentation" class="active">
                            <a href="#message-logs" aria-controls="message-logs" role="tab" data-toggle="tab">
                                <i class="fa fa-comments"></i> Message Logs
                            </a>
                        </li>
                        <li role="presentation">
                            <a href="#invoice-logs" aria-controls="invoice-logs" role="tab" data-toggle="tab">
                                <i class="fa fa-file-pdf-o"></i> Invoice Logs
                            </a>
                        </li>
                    </ul>

                    <!-- Tab Content -->
                    <div class="tab-content" style="margin-top: 15px;">
                        <!-- Message Logs Tab -->
                        <div role="tabpanel" class="tab-pane active" id="message-logs">
                    
                    <!-- Log Filter -->
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>@lang('whatsappbot::lang.filter_by_date')</label>
                                <input type="date" id="log-date" class="form-control" 
                                       value="{{ date('Y-m-d') }}" onchange="filterLogs()">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>@lang('whatsappbot::lang.filter_by_type')</label>
                                <select id="log-type" class="form-control" onchange="filterLogs()">
                                    <option value="">@lang('whatsappbot::lang.all_types')</option>
                                    <option value="incoming">@lang('whatsappbot::lang.incoming_messages')</option>
                                    <option value="outgoing">@lang('whatsappbot::lang.outgoing_messages')</option>
                                    <option value="error">@lang('whatsappbot::lang.errors')</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>@lang('whatsappbot::lang.search')</label>
                                <input type="text" id="log-search" class="form-control" 
                                       placeholder="@lang('whatsappbot::lang.search_placeholder')" 
                                       onkeyup="filterLogs()">
                            </div>
                        </div>
                    </div>

                    <!-- Logs Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="logs-table">
                            <thead>
                                <tr>
                                    <th>@lang('whatsappbot::lang.timestamp')</th>
                                    <th>@lang('whatsappbot::lang.type')</th>
                                    <th>@lang('whatsappbot::lang.phone')</th>
                                    <th>@lang('whatsappbot::lang.message')</th>
                                    <th>@lang('whatsappbot::lang.status')</th>
                                    <th>@lang('whatsappbot::lang.actions')</th>
                                </tr>
                            </thead>
                            <tbody id="logs-tbody">
                                <tr>
                                    <td colspan="6" class="text-center">
                                        <i class="fa fa-spinner fa-spin"></i> @lang('whatsappbot::lang.loading_logs')
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="dataTables_info">
                                <span id="logs-info">@lang('whatsappbot::lang.showing_logs')</span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="dataTables_paginate paging_simple_numbers">
                                <ul class="pagination" id="logs-pagination">
                                    <!-- Pagination will be populated by JavaScript -->
                                </ul>
                            </div>
                        </div>
                    </div>
                    </div>  <!-- End Message Logs Tab -->

                    <!-- Invoice Logs Tab -->
                    <div role="tabpanel" class="tab-pane" id="invoice-logs">
                        <div class="row" style="margin-bottom: 15px;">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Filter by Date</label>
                                    <input type="date" id="invoice-date" class="form-control" 
                                           value="{{ date('Y-m-d') }}" onchange="filterInvoiceLogs()">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Filter by Status</label>
                                    <select id="invoice-status" class="form-control" onchange="filterInvoiceLogs()">
                                        <option value="">All Status</option>
                                        <option value="sent">Sent</option>
                                        <option value="failed">Failed</option>
                                        <option value="pending">Pending</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Search</label>
                                    <input type="text" id="invoice-search" class="form-control" 
                                           placeholder="Search by invoice number or phone..." 
                                           onkeyup="filterInvoiceLogs()">
                                </div>
                            </div>
                        </div>

                        <!-- Invoice Logs Table -->
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="invoice-logs-table">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Invoice No</th>
                                        <th>Customer</th>
                                        <th>Phone</th>
                                        <th>Status</th>
                                        <th>PDF</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $business_id = session()->get('user.business_id');
                                        $invoice_logs = \Modules\WhatsAppBot\Models\WhatsAppInvoiceLog::where('business_id', $business_id)
                                            ->orderBy('created_at', 'desc')
                                            ->limit(50)
                                            ->get();
                                    @endphp
                                    @forelse($invoice_logs as $log)
                                    <tr>
                                        <td>{{ $log->created_at->format('d M Y, h:i A') }}</td>
                                        <td>
                                            <span class="text-info">{{ $log->invoice_no }}</span>
                                            @if($log->transaction)
                                                <br><small class="text-muted">₦{{ number_format($log->transaction->final_total, 2) }}</small>
                                            @endif
                                        </td>
                                        <td>{{ $log->customer_name ?? 'N/A' }}</td>
                                        <td>{{ $log->customer_phone }}</td>
                                        <td>
                                            @if($log->status == 'sent')
                                                <span class="label label-success">
                                                    <i class="fa fa-check"></i> Sent
                                                </span>
                                            @elseif($log->status == 'failed')
                                                <span class="label label-danger">
                                                    <i class="fa fa-times"></i> Failed
                                                </span>
                                            @else
                                                <span class="label label-warning">
                                                    <i class="fa fa-clock-o"></i> Pending
                                                </span>
                                            @endif
                                            @if($log->retry_count > 0)
                                                <br><small class="text-muted">Retries: {{ $log->retry_count }}</small>
                                            @endif
                                        </td>
                                        <td>
                                            @if($log->pdf_filename)
                                                <i class="fa fa-file-pdf-o text-danger"></i>
                                                <small>{{ $log->pdf_filename }}</small>
                                            @else
                                                <span class="text-muted">No PDF</span>
                                            @endif
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-xs btn-info" 
                                                    onclick="viewInvoiceLog({{ $log->id }})" 
                                                    title="View Details">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                            @if($log->status == 'failed' && $log->canRetry())
                                                <button type="button" class="btn btn-xs btn-warning" 
                                                        onclick="retryInvoice({{ $log->id }})" 
                                                        title="Retry Send">
                                                    <i class="fa fa-refresh"></i>
                                                </button>
                                            @endif
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="7" class="text-center text-muted">
                                            <i class="fa fa-info-circle"></i> No invoice logs found
                                        </td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>  <!-- End Invoice Logs Tab -->

                    </div>  <!-- End Tab Content -->
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row">
        <div class="col-md-3">
            <div class="small-box bg-blue">
                <div class="inner">
                    <h3 id="total-messages">0</h3>
                    <p>@lang('whatsappbot::lang.total_messages')</p>
                </div>
                <div class="icon">
                    <i class="fa fa-comments"></i>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="small-box bg-green">
                <div class="inner">
                    <h3 id="successful-messages">0</h3>
                    <p>@lang('whatsappbot::lang.successful_messages')</p>
                </div>
                <div class="icon">
                    <i class="fa fa-check"></i>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="small-box bg-red">
                <div class="inner">
                    <h3 id="failed-messages">0</h3>
                    <p>@lang('whatsappbot::lang.failed_messages')</p>
                </div>
                <div class="icon">
                    <i class="fa fa-times"></i>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="small-box bg-yellow">
                <div class="inner">
                    <h3 id="pending-messages">0</h3>
                    <p>@lang('whatsappbot::lang.pending_messages')</p>
                </div>
                <div class="icon">
                    <i class="fa fa-clock-o"></i>
                </div>
            </div>
        </div>
    </div>

</section>

<!-- Log Detail Modal -->
<div class="modal fade" id="log-detail-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">@lang('whatsappbot::lang.log_details')</h4>
            </div>
            <div class="modal-body" id="log-detail-content">
                <!-- Content will be populated by JavaScript -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">
                    @lang('whatsappbot::lang.close')
                </button>
            </div>
        </div>
    </div>
</div>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        loadLogs();
        loadStatistics();
    });

    function loadLogs() {
        // For now, show sample data since we haven't implemented backend logging yet
        var sampleLogs = [
            {
                id: 1,
                timestamp: '2024-01-01 12:00:00',
                type: 'incoming',
                phone: '+2348012345678',
                message: 'What\'s today\'s sales?',
                status: 'processed',
                response: 'Today\'s sales: ₦125,000'
            },
            {
                id: 2,
                timestamp: '2024-01-01 12:05:00',
                type: 'outgoing',
                phone: '+2348012345678',
                message: 'Today\'s sales: ₦125,000',
                status: 'sent',
                response: null
            },
            {
                id: 3,
                timestamp: '2024-01-01 12:10:00',
                type: 'incoming',
                phone: '+2348087654321',
                message: 'Send report',
                status: 'processed',
                response: 'Sales report generated and sent'
            }
        ];

        populateLogsTable(sampleLogs);
    }

    function populateLogsTable(logs) {
        var tbody = $('#logs-tbody');
        tbody.empty();

        if (logs.length === 0) {
            tbody.append('<tr><td colspan="6" class="text-center">@lang("whatsappbot::lang.no_logs_found")</td></tr>');
            return;
        }

        logs.forEach(function(log) {
            var statusBadge = getStatusBadge(log.status);
            var typeBadge = getTypeBadge(log.type);
            
            var row = `
                <tr>
                    <td>${log.timestamp}</td>
                    <td>${typeBadge}</td>
                    <td>${log.phone}</td>
                    <td class="message-preview">${truncateMessage(log.message, 50)}</td>
                    <td>${statusBadge}</td>
                    <td>
                        <button class="btn btn-xs btn-info" onclick="showLogDetail(${log.id})">
                            <i class="fa fa-eye"></i> @lang('whatsappbot::lang.view')
                        </button>
                    </td>
                </tr>
            `;
            tbody.append(row);
        });
    }

    function getStatusBadge(status) {
        switch(status) {
            case 'sent':
            case 'processed':
                return '<span class="label label-success"><i class="fa fa-check"></i> ' + status + '</span>';
            case 'failed':
            case 'error':
                return '<span class="label label-danger"><i class="fa fa-times"></i> ' + status + '</span>';
            case 'pending':
                return '<span class="label label-warning"><i class="fa fa-clock-o"></i> ' + status + '</span>';
            default:
                return '<span class="label label-default">' + status + '</span>';
        }
    }

    function getTypeBadge(type) {
        switch(type) {
            case 'incoming':
                return '<span class="label label-primary"><i class="fa fa-arrow-down"></i> @lang("whatsappbot::lang.incoming")</span>';
            case 'outgoing':
                return '<span class="label label-info"><i class="fa fa-arrow-up"></i> @lang("whatsappbot::lang.outgoing")</span>';
            case 'error':
                return '<span class="label label-danger"><i class="fa fa-exclamation-triangle"></i> @lang("whatsappbot::lang.error")</span>';
            default:
                return '<span class="label label-default">' + type + '</span>';
        }
    }

    function truncateMessage(message, length) {
        if (message.length > length) {
            return message.substring(0, length) + '...';
        }
        return message;
    }

    function showLogDetail(logId) {
        // Show log details in modal
        $('#log-detail-modal').modal('show');
        $('#log-detail-content').html('<p>@lang("whatsappbot::lang.log_details_placeholder")</p>');
    }

    function refreshLogs() {
        loadLogs();
        toastr.success('@lang("whatsappbot::lang.logs_refreshed")');
    }

    function filterLogs() {
        // Filter functionality - would connect to backend API
        console.log('Filtering logs...');
    }

    function loadStatistics() {
        // Sample statistics
        $('#total-messages').text('156');
        $('#successful-messages').text('142');
        $('#failed-messages').text('8');
        $('#pending-messages').text('6');
    }
</script>
@endsection