@extends('layouts.app')

@section('title', __('whatsappbot::lang.settings'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('whatsappbot::lang.whatsapp_bot')
        <small>@lang('whatsappbot::lang.settings')</small>
    </h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-8">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        <i class="fa fa-cog"></i> @lang('whatsappbot::lang.whatsapp_settings')
                    </h3>
                </div>
                <form action="{{ route('whatsappbot.settings.update') }}" method="POST">
                    @csrf
                <div class="box-body">
                    <div class="form-group">
                        <label for="whatsapp_phone">@lang('whatsappbot::lang.whatsapp_phone_number')</label>
                        <input type="text" name="whatsapp_phone" id="whatsapp_phone" 
                               class="form-control" 
                               value="{{ $business->whatsapp_phone ?? '' }}"
                               placeholder="+2348012345678">
                        <p class="help-block">@lang('whatsappbot::lang.phone_help')</p>
                    </div>
                    
                    <div class="form-group">
                        <div class="checkbox">
                            <label>
                                <input type="checkbox" name="whatsapp_enabled" value="1" 
                                       {{ ($business->whatsapp_enabled ?? false) ? 'checked' : '' }}>
                                @lang('whatsappbot::lang.enable_whatsapp_bot')
                            </label>
                        </div>
                        <p class="help-block">@lang('whatsappbot::lang.enable_whatsapp_help')</p>
                    </div>

                    <div class="form-group">
                        <div class="checkbox">
                            <label>
                                <input type="checkbox" name="auto_send_invoices" value="1" 
                                       {{ ($business->auto_send_invoices ?? false) ? 'checked' : '' }}>
                                @lang('whatsappbot::lang.auto_send_invoices')
                            </label>
                        </div>
                        <p class="help-block">@lang('whatsappbot::lang.auto_send_invoices_help')</p>
                    </div>

                    <div class="form-group">
                        <label>@lang('whatsappbot::lang.webhook_url')</label>
                        <div class="input-group">
                            <input type="text" class="form-control" readonly 
                                   value="{{ url('/api/webhook/whatsapp') }}">
                            <div class="input-group-btn">
                                <button type="button" class="btn btn-info" 
                                        onclick="copyToClipboard('{{ url('/api/webhook/whatsapp') }}')">
                                    <i class="fa fa-copy"></i> @lang('whatsappbot::lang.copy')
                                </button>
                            </div>
                        </div>
                        <p class="help-block">@lang('whatsappbot::lang.webhook_help')</p>
                    </div>

                    <div class="form-group">
                        <label>@lang('whatsappbot::lang.api_endpoint')</label>
                        <input type="text" class="form-control" readonly 
                               value="{{ config('whatsappbot.nodeurl') }}">
                        <p class="help-block">@lang('whatsappbot::lang.api_endpoint_help')</p>
                    </div>
                </div>
                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> @lang('whatsappbot::lang.save_settings')
                    </button>
                    <a href="{{ route('whatsappbot.index') }}" class="btn btn-default">
                        <i class="fa fa-arrow-left"></i> @lang('whatsappbot::lang.back_to_dashboard')
                    </a>
                </div>
                </form>
            </div>
        </div>

        <!-- Status Card -->
        <div class="col-md-4">
            <div class="box box-info">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        <i class="fa fa-info-circle"></i> @lang('whatsappbot::lang.current_status')
                    </h3>
                </div>
                <div class="box-body">
                    <table class="table table-condensed">
                        <tr>
                            <td><strong>@lang('whatsappbot::lang.status'):</strong></td>
                            <td>
                                @if($business->whatsapp_enabled ?? false)
                                    <span class="label label-success">
                                        <i class="fa fa-check"></i> @lang('whatsappbot::lang.enabled')
                                    </span>
                                @else
                                    <span class="label label-danger">
                                        <i class="fa fa-times"></i> @lang('whatsappbot::lang.disabled')
                                    </span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td><strong>@lang('whatsappbot::lang.phone'):</strong></td>
                            <td>
                                @if($business->whatsapp_phone)
                                    <span class="text-success">{{ $business->whatsapp_phone }}</span>
                                @else
                                    <span class="text-warning">@lang('whatsappbot::lang.not_configured')</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td><strong>@lang('whatsappbot::lang.auto_invoices'):</strong></td>
                            <td>
                                @if($business->auto_send_invoices ?? false)
                                    <span class="label label-success">
                                        <i class="fa fa-check"></i> @lang('whatsappbot::lang.enabled')
                                    </span>
                                @else
                                    <span class="label label-default">
                                        <i class="fa fa-times"></i> @lang('whatsappbot::lang.disabled')
                                    </span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td><strong>@lang('whatsappbot::lang.api_configured'):</strong></td>
                            <td>
                                @if(config('whatsappbot.token'))
                                    <span class="label label-success">
                                        <i class="fa fa-check"></i> @lang('whatsappbot::lang.yes')
                                    </span>
                                @else
                                    <span class="label label-danger">
                                        <i class="fa fa-times"></i> @lang('whatsappbot::lang.no')
                                    </span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Central Bot Mode:</strong></td>
                            <td>
                                @if(config('whatsappbot.central_bot_enabled'))
                                    <span class="label label-primary">
                                        <i class="fa fa-robot"></i> Enabled
                                    </span>
                                @else
                                    <span class="label label-default">
                                        <i class="fa fa-user"></i> Individual Mode
                                    </span>
                                @endif
                            </td>
                        </tr>
                        @if(config('whatsappbot.central_bot_enabled'))
                        <tr>
                            <td><strong>Central Bot Number:</strong></td>
                            <td>
                                @if(config('whatsappbot.central_bot_number'))
                                    <span class="text-info">
                                        <i class="fa fa-whatsapp"></i> {{ config('whatsappbot.central_bot_number') }}
                                    </span>
                                    <br><small class="text-muted">Send messages TO this number</small>
                                @else
                                    <span class="text-warning">Not configured</span>
                                    <br><small class="text-muted">Set WHATSAPP_CENTRAL_BOT_NUMBER in .env</small>
                                @endif
                            </td>
                        </tr>
                        @endif
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    function copyToClipboard(text) {
        var temp = $('<input>');
        $('body').append(temp);
        temp.val(text).select();
        document.execCommand('copy');
        temp.remove();
        toastr.success('@lang("whatsappbot::lang.copied_to_clipboard")');
    }
</script>
@endsection