@extends('layouts.app')

@section('title', __('whatsappbot::lang.test_messages'))

@push('head')
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="0">
<!-- Force reload indicator -->
<meta name="page-version" content="1.3.{{ time() }}">
@endpush

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('whatsappbot::lang.whatsapp_bot')
        <small>@lang('whatsappbot::lang.test_messages') v1.3</small>
    </h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <!-- Send Test Message -->
        <div class="col-md-8">
            <div class="box box-success">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        <i class="fa fa-paper-plane"></i> @lang('whatsappbot::lang.send_test_message')
                    </h3>
                </div>
                <form id="test-message-form">
                    <div class="box-body">
                        <div class="form-group">
                            <label for="test-phone">@lang('whatsappbot::lang.phone_number')</label>
                            <input type="text" id="test-phone" name="phone" class="form-control" 
                                   placeholder="+2348012345678" required>
                            <p class="help-block">@lang('whatsappbot::lang.phone_help')</p>
                        </div>
                        
                        <div class="form-group">
                            <label for="test-message">@lang('whatsappbot::lang.message')</label>
                            <textarea id="test-message" name="message" class="form-control" rows="4" 
                                      placeholder="@lang('whatsappbot::lang.message_placeholder')" required></textarea>
                            <p class="help-block">@lang('whatsappbot::lang.message_help')</p>
                        </div>

                        <div class="form-group">
                            <label for="message-template">@lang('whatsappbot::lang.quick_templates')</label>
                            <select id="message-template" class="form-control" onchange="selectTemplate()">
                                <option value="">@lang('whatsappbot::lang.select_template')</option>
                                <option value="sales-today">@lang('whatsappbot::lang.template_sales_today')</option>
                                <option value="sales-yesterday">@lang('whatsappbot::lang.template_sales_yesterday')</option>
                                <option value="profit-today">@lang('whatsappbot::lang.template_profit_today')</option>
                                <option value="report">@lang('whatsappbot::lang.template_report')</option>
                                <option value="help">@lang('whatsappbot::lang.template_help_cmd')</option>
                                <option value="custom">@lang('whatsappbot::lang.template_custom')</option>
                            </select>
                            <p class="help-block">@lang('whatsappbot::lang.template_help_desc')</p>
                        </div>
                    </div>
                    <div class="box-footer">
                        <button type="submit" class="btn btn-success">
                            <i class="fa fa-paper-plane"></i> @lang('whatsappbot::lang.send_test')
                        </button>
                        <button type="button" class="btn btn-default" onclick="clearForm()">
                            <i class="fa fa-refresh"></i> @lang('whatsappbot::lang.clear')
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Test Results & Status -->
        <div class="col-md-4">
            <div class="box box-info">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        <i class="fa fa-info-circle"></i> @lang('whatsappbot::lang.connection_status')
                    </h3>
                </div>
                <div class="box-body">
                    <table class="table table-condensed">
                        <tr>
                            <td><strong>@lang('whatsappbot::lang.api_status'):</strong></td>
                            <td>
                                @if(config('whatsappbot.token'))
                                    <span class="label label-success">
                                        <i class="fa fa-check"></i> @lang('whatsappbot::lang.connected')
                                    </span>
                                @else
                                    <span class="label label-danger">
                                        <i class="fa fa-times"></i> @lang('whatsappbot::lang.not_configured')
                                    </span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td><strong>@lang('whatsappbot::lang.business_phone'):</strong></td>
                            <td>
                                @if($business->whatsapp_phone)
                                    <span class="text-success">{{ $business->whatsapp_phone }}</span>
                                @else
                                    <span class="text-warning">@lang('whatsappbot::lang.not_set')</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td><strong>@lang('whatsappbot::lang.bot_enabled'):</strong></td>
                            <td>
                                @if($business->whatsapp_enabled ?? false)
                                    <span class="label label-success">
                                        <i class="fa fa-check"></i> @lang('whatsappbot::lang.enabled')
                                    </span>
                                @else
                                    <span class="label label-danger">
                                        <i class="fa fa-times"></i> @lang('whatsappbot::lang.disabled')
                                    </span>
                                @endif
                            </td>
                        </tr>
                    </table>
                    
                    @if(!config('whatsappbot.token') || !($business->whatsapp_enabled ?? false))
                        <div class="alert alert-warning">
                            <i class="fa fa-exclamation-triangle"></i>
                            @lang('whatsappbot::lang.configure_first')
                            <br>
                            <a href="{{ route('whatsappbot.settings') }}" class="btn btn-xs btn-primary">
                                <i class="fa fa-cog"></i> @lang('whatsappbot::lang.configure_now')
                            </a>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Recent Test Results -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        <i class="fa fa-history"></i> @lang('whatsappbot::lang.recent_tests')
                    </h3>
                </div>
                <div class="box-body">
                    <div id="test-results">
                        <p class="text-muted">@lang('whatsappbot::lang.no_recent_tests')</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Available Commands Reference -->
    <div class="row">
        <div class="col-md-12">
            <div class="box box-info collapsed-box">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        <i class="fa fa-list"></i> @lang('whatsappbot::lang.available_commands')
                    </h3>
                    <div class="box-tools pull-right">
                        <button type="button" class="btn btn-box-tool" data-widget="collapse">
                            <i class="fa fa-plus"></i>
                        </button>
                    </div>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h4><i class="fa fa-shopping-cart"></i> @lang('whatsappbot::lang.sales_queries')</h4>
                            <ul class="list-unstyled">
                                <li>
                                    <code onclick="useCommand(this)">What's today's sales?</code>
                                </li>
                                <li>
                                    <code onclick="useCommand(this)">Show yesterday's sales</code>
                                </li>
                                <li>
                                    <code onclick="useCommand(this)">This week's sales</code>
                                </li>
                                <li>
                                    <code onclick="useCommand(this)">This month's sales</code>
                                </li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h4><i class="fa fa-money"></i> @lang('whatsappbot::lang.profit_queries')</h4>
                            <ul class="list-unstyled">
                                <li>
                                    <code onclick="useCommand(this)">What's today's profit?</code>
                                </li>
                                <li>
                                    <code onclick="useCommand(this)">Yesterday's profit</code>
                                </li>
                                <li>
                                    <code onclick="useCommand(this)">This week's profit</code>
                                </li>
                                <li>
                                    <code onclick="useCommand(this)">This month's profit</code>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <h4><i class="fa fa-bar-chart"></i> @lang('whatsappbot::lang.reports')</h4>
                            <ul class="list-unstyled">
                                <li>
                                    <code onclick="useCommand(this)">Send report</code>
                                </li>
                                <li>
                                    <code onclick="useCommand(this)">Full report</code>
                                </li>
                                <li>
                                    <code onclick="useCommand(this)">Top products</code>
                                </li>
                                <li>
                                    <code onclick="useCommand(this)">Best selling items</code>
                                </li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h4><i class="fa fa-question-circle"></i> @lang('whatsappbot::lang.help')</h4>
                            <ul class="list-unstyled">
                                <li>
                                    <code onclick="useCommand(this)">Help</code>
                                </li>
                                <li>
                                    <code onclick="useCommand(this)">Commands</code>
                                </li>
                                <li>
                                    <code onclick="useCommand(this)">What can you do?</code>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</section>

@endsection

@section('javascript')
<script type="text/javascript">
(function() {
    'use strict';
    
    // Cache buster: v1.6 - jQuery available check + global function exposure
    var testResults = [];
    var WHATSAPP_TEST_URL = '{{ route("whatsappbot.send-test") }}';
    
    // Force override in case any other script tries to use the old API route
    window.WHATSAPP_TEST_URL = WHATSAPP_TEST_URL;
    
    console.log('==== WhatsApp Test Configuration v1.6 ====');
    console.log('Test URL from Laravel:', WHATSAPP_TEST_URL);
    console.log('Expected URL pattern: /whatsappbot/send-test');
    console.log('=========================================');

    // Wait for jQuery to be available
    function initWhatsAppTest() {
        if (typeof jQuery === 'undefined') {
            setTimeout(initWhatsAppTest, 100);
            return;
        }

        jQuery(document).ready(function($) {
            // Expose functions globally for inline event handlers
            window.selectTemplate = selectTemplate;
            window.useCommand = useCommand;
            window.clearForm = clearForm;
            
            // Handle test message form submission
            $('#test-message-form').on('submit', function(e) {
                e.preventDefault();
                sendTestMessage();
            });
        });
    }

    function sendTestMessage() {
        if (typeof jQuery === 'undefined') {
            console.error('jQuery not loaded');
            return;
        }

        var $ = jQuery;
        var phone = $('#test-phone').val();
        var message = $('#test-message').val();
        
        if (!phone || !message) {
            if (typeof toastr !== 'undefined') {
                toastr.error('@lang("whatsappbot::lang.fill_required_fields")');
            } else {
                alert('@lang("whatsappbot::lang.fill_required_fields")');
            }
            return;
        }

        // Show loading state
        var submitBtn = $('#test-message-form button[type="submit"]');
        var originalText = submitBtn.html();
        submitBtn.html('<i class="fa fa-spinner fa-spin"></i> @lang("whatsappbot::lang.sending")').prop('disabled', true);

        console.log('Sending WhatsApp test to:', WHATSAPP_TEST_URL);

        $.ajax({
            url: WHATSAPP_TEST_URL,
            type: 'POST',
            data: {
                phone: phone,
                message: message,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                if (typeof toastr !== 'undefined') {
                    toastr.success('@lang("whatsappbot::lang.test_message_sent")');
                }
                
                // Add to recent tests
                addTestResult(phone, message, 'success', response.message);
            },
            error: function(xhr) {
                console.error('WhatsApp Test Error:', xhr.status, xhr.statusText);
                console.error('Attempted URL:', WHATSAPP_TEST_URL);
                console.error('Request URL (from xhr):', xhr.responseURL || 'Not available');
                
                var error = xhr.responseJSON ? xhr.responseJSON.message : '@lang("whatsappbot::lang.test_message_failed")';
                
                if (xhr.status === 404) {
                    error = 'Endpoint not found. URL: ' + WHATSAPP_TEST_URL + '. Clear cache and refresh.';
                }
                
                if (typeof toastr !== 'undefined') {
                    toastr.error(error);
                } else {
                    alert('Error: ' + error);
                }
                
                // Add to recent tests
                addTestResult(phone, message, 'error', error);
            },
            complete: function() {
                // Restore button
                submitBtn.html(originalText).prop('disabled', false);
            }
        });
    }

    function addTestResult(phone, message, status, result) {
        if (typeof jQuery === 'undefined') return;
        
        var $ = jQuery;
        var timestamp = new Date().toLocaleString();
        var statusIcon = status === 'success' ? '<i class="fa fa-check text-success"></i>' : '<i class="fa fa-times text-danger"></i>';
        
        var resultHtml = 
            '<div class="test-result-item">' +
            '<small class="text-muted">' + timestamp + '</small><br>' +
            '<strong>' + phone + '</strong> ' + statusIcon + '<br>' +
            '<em>' + (message.substring(0, 30) + (message.length > 30 ? '...' : '')) + '</em><br>' +
            '<small class="text-info">' + result + '</small>' +
            '<hr style="margin: 10px 0;">' +
            '</div>';
        
        var resultsContainer = $('#test-results');
        if (resultsContainer.find('.test-result-item').length === 0) {
            resultsContainer.html(resultHtml);
        } else {
            resultsContainer.prepend(resultHtml);
        }
        
        // Keep only last 5 results
        var items = resultsContainer.find('.test-result-item');
        if (items.length > 5) {
            items.slice(5).remove();
        }
    }

    function selectTemplate() {
        if (typeof jQuery === 'undefined') return;
        
        var $ = jQuery;
        var template = $('#message-template').val();
        var messageField = $('#test-message');
        
        var templates = {
            'sales-today': "What's today's sales?",
            'sales-yesterday': "Show yesterday's sales",
            'profit-today': "What's today's profit?",
            'report': "Send report",
            'help': "Help",
            'custom': "Hello! This is a test message from my POS system. Can you confirm you received this?"
        };
        
        if (template && templates[template]) {
            messageField.val(templates[template]);
        }
    }

    function useCommand(element) {
        if (typeof jQuery === 'undefined') return;
        
        var $ = jQuery;
        var command = $(element).text();
        $('#test-message').val(command);
        
        if (typeof toastr !== 'undefined') {
            toastr.info('@lang("whatsappbot::lang.command_copied")');
        }
    }

    function clearForm() {
        if (typeof jQuery === 'undefined') return;
        
        var $ = jQuery;
        $('#test-message-form')[0].reset();
        $('#message-template').val('');
    }
    
    // Initialize when script loads
    initWhatsAppTest();
})();
</script>
@endsection