<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Webhook endpoint for NearBuyMarts API
// This endpoint receives incoming WhatsApp messages (no auth required for webhooks)
Route::post('/webhook/whatsapp', 'WhatsAppBotController@handleIncoming')
    ->name('whatsappbot.webhook');

// GET endpoint for webhook verification (some providers ping this first)
Route::get('/webhook/whatsapp', 'WhatsAppBotController@verifyWebhook')
    ->name('whatsappbot.webhook.verify');

// Note: Test message endpoint removed from API routes
// Use the web route instead: POST /whatsappbot/send-test
// API routes don't support session-based authentication by default
