<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Route;

Route::middleware(['web', 'SetSessionData', 'auth', 'language', 'timezone', 'AdminSidebarMenu'])->prefix('whatsappbot')->group(function() {
    Route::get('/', 'WhatsAppBotController@index')->name('whatsappbot.index');
    Route::get('/dashboard', 'WhatsAppBotController@index')->name('whatsappbot.dashboard');
    
    // Settings
    Route::get('/settings', 'WhatsAppBotController@settings')->name('whatsappbot.settings');
    Route::post('/settings', 'WhatsAppBotController@updateSettings')->name('whatsappbot.settings.update');
    
    // Message Logs
    Route::get('/logs', 'WhatsAppBotController@logs')->name('whatsappbot.logs');
    
    // Test Messages
    Route::get('/test-messages', 'WhatsAppBotController@testMessages')->name('whatsappbot.test-messages');
    Route::get('/send-test', function() {
        return redirect()->route('whatsappbot.test-messages')
            ->with('error', 'Please use the form to send test messages.');
    });
    Route::post('/send-test', 'WhatsAppBotController@sendTest')->name('whatsappbot.send-test');
    
    // Webhook Tester
    Route::get('/webhook-tester', 'WhatsAppBotController@webhookTester')->name('whatsappbot.webhook-tester');
    Route::post('/test-webhook', 'WhatsAppBotController@testWebhook')->name('whatsappbot.test-webhook');
    Route::get('/webhook-logs', 'WhatsAppBotController@webhookLogs')->name('whatsappbot.webhook-logs');
    
    // Installation routes (Superadmin format)
    Route::get('/install', 'InstallController@index')->name('whatsappbot.install');
    Route::post('/install', 'InstallController@install')->name('whatsappbot.install.post');
    Route::get('/install/update', 'InstallController@update')->name('whatsappbot.install.update');
    Route::post('/install/update', 'InstallController@updateModule')->name('whatsappbot.install.update.post');
    Route::get('/install/uninstall', 'InstallController@uninstall')->name('whatsappbot.install.uninstall');
});
