# 📱 WhatsApp Bot User Guide - JEBBMS POS System

## 🎯 Overview
The WhatsApp Bot allows you to get real-time business reports and automatically sends invoices to customers via WhatsApp messages. This guide explains how to use all features and complete the setup.

---

## 🚀 Complete Setup Guide

### 1. **NearBuyMarts API Setup** 

#### **Required NearBuyMarts Dashboard Configuration:**

1. **Login to NearBuyMarts Dashboard**
   - Visit: `https://app.nearbuymarts.com`
   - Login with your API credentials

2. **Configure Webhook URL**
   - Navigate to: **Settings → Webhooks**
   - Set Webhook URL: `https://yourdomain.com/api/webhook/whatsapp`
   - Method: `POST`
   - Events: `message.received` (or equivalent incoming message event)
   - **Note**: Webhook verification token is optional for basic setup

3. **Get Your API Credentials**
   - Go to: **Settings → API Settings**
   - Copy your **API Token** (you'll need this for .env)
   - Note your **Send Node URL** (usually: `https://api.nearbuymarts.com/send`)

4. **Phone Number Verification**
   - Ensure your WhatsApp Business number is verified
   - Test message sending from dashboard to confirm setup

#### **Environment Variables Setup (.env file):**
```env
# WhatsApp API Configuration - Central Bot Mode
WHATSAPP_SEND_NODEURL=https://api.nearbuymarts.com/send
WHATSAPP_SEND_TOKEN=your_actual_api_token_here
WHATSAPP_MEDIA_URL=https://app.nearbuymarts.com/public/app-assets/images/logo/logo.png

# Central Bot Configuration (RECOMMENDED)
WHATSAPP_CENTRAL_BOT_ENABLED=true
WHATSAPP_CENTRAL_BOT_NUMBER=+2348012345678
WHATSAPP_PHONE_MAPPING=central_bot

# Optional Security
WHATSAPP_WEBHOOK_VERIFY_TOKEN=your_webhook_verification_token
WHATSAPP_LOG_INCOMING=true
WHATSAPP_LOG_OUTGOING=true
```

**🤖 Central Bot Mode**: One WhatsApp number serves all businesses. Users send messages TO the central bot number.

### 2. **JEBBMS System Configuration**

#### **Step 1: Configure Business WhatsApp Settings**
1. Login to your JEBBMS dashboard
2. Navigate to: **WhatsApp Bot → Settings**
3. Configure:
   - **WhatsApp Phone Number**: `+2348012345678` (your business WhatsApp number)
   - **Enable WhatsApp Bot**: ✅ Check this box
   - **Auto-Send Invoices**: ✅ Check to automatically send invoices after sales
4. Click **Save Settings**

#### **Step 2: Verify Setup**
1. Go to: **WhatsApp Bot → Test Messages**
2. Send a test message to verify connection
3. Check: **WhatsApp Bot → Logs** to see message delivery status

---

## 🏢 Multi-Tenant Support

### **🤖 Central Bot Mode (RECOMMENDED)**

The WhatsApp Bot now supports a **Central Bot Number** approach:

#### **How Central Bot Works:**
- **One Central Number**: `+2348012345678` (configured in .env)
- **All Users Send TO**: The central bot number
- **Business Identification**: System identifies business from message content
- **Smart Memory**: Bot remembers user's business preference

#### **Message Flow Example:**
```
Central Bot Number: +2348012345678

User A (Business Owner): Sends "ABC Store today sales" TO +2348012345678
User B (Staff Member): Sends "XYZ Shop profit report" TO +2348012345678  
User C (Manager): Sends "today sales" TO +2348012345678 (remembers previous business)

Each gets their respective business data!
```

#### **Setup Process:**
1. **Admin**: Configure central bot number in .env
2. **Users**: Send messages TO the central bot number
3. **First Message**: Include business name: "ABC Store today sales"
4. **Future Messages**: Bot remembers: just send "today sales"

#### **Legacy Individual Mode:**
- Still supported by setting `WHATSAPP_CENTRAL_BOT_ENABLED=false`
- Each business uses their own WhatsApp number (old method)

---

## 📱 **Important: How WhatsApp Message Routing Works**

### **🤖 Central Bot Mode (Default)**

**Simple Setup**: All users send messages **TO** one central WhatsApp Bot number.

**Message Flow:**
1. **Central Bot Number**: `+2348012345678` (configured by admin)
2. **Users send TO**: The central bot number from their personal WhatsApp
3. **Business Identification**: System identifies business from message content
4. **Response**: Sent back to user's personal WhatsApp number

### **📞 Central Bot Message Examples:**

```
Central Bot Number: +2348012345678

First-time User:
User sends TO bot: "ABC Store today sales"
Bot responds TO user: "📊 ABC Store Sales: ₦150,000..."
Bot remembers: This user works with ABC Store

Returning User:  
User sends TO bot: "today sales" 
Bot responds TO user: "📊 ABC Store Sales: ₦200,000..." (remembers ABC Store)

Business Name Recognition:
User sends TO bot: "XYZ Shop profit report"
Bot responds TO user: "💰 XYZ Shop Profit: ₦45,000..."
```

### **🎯 Key Points - Central Bot Mode:**
- ✅ **One central number** for all businesses
- ✅ **Users send TO** the central bot number  
- ✅ **Include business name** in first message
- ✅ **Bot remembers** your business for future messages
- ✅ **All responses** come back to your personal WhatsApp

### **🔄 Legacy Individual Mode:**
If `WHATSAPP_CENTRAL_BOT_ENABLED=false`:
- Each business uses their own WhatsApp number
- Business owners send FROM their business WhatsApp
- System identifies business by sender's phone number

---

## 📊 How to Get Reports via WhatsApp

### **📱 How to Send Report Requests**

**🤖 Central Bot Mode (Default)**: Send messages **TO** the central WhatsApp Bot number.

**Message Flow:**
1. **Send TO**: Central bot number (e.g., `+2348012345678`)
2. **Include business**: "ABC Store today sales" (first time)
3. **Bot remembers**: Future messages can just be "today sales"
4. **Get response**: Report sent back to your personal WhatsApp

**Examples:**
```
First message: "ABC Store today sales" → Bot learns your business
Next message: "today profit" → Bot remembers ABC Store
Later: "send report" → Still remembers ABC Store
```

### **Available Report Commands**

#### **📈 Sales Reports**
Send any of these messages **TO the central bot number**:

```
• "ABC Store today's sales"
• "XYZ Shop today sales" 
• "My Business today sales"
• "ABC Store how much did we sell today?"

Once bot knows your business:
• "today's sales"
• "yesterday's sales"
• "this week's sales"
• "this month's sales"
```

**Sample Response:**
```
📊 Today's Sales Report - [Business Name]

💰 Total Sales: ₦156,750.00
🧾 Total Transactions: 23
📱 Avg Transaction: ₦6,815.22

📅 Date: 06 Nov 2024
🕒 Generated: 3:45 PM

Have a profitable day! 💪
```

#### **💰 Profit Reports**
Get profit analysis with these commands:

```
First time (include business name):
• "ABC Store today's profit"
• "XYZ Shop profit today"

After bot remembers your business:
• "today's profit"
• "yesterday's profit"
• "this week's profit"
• "this month's profit"
```

**Sample Response:**
```
💰 Today's Profit Report - [Business Name]

🎯 Total Profit: ₦45,250.00
📊 Profit Margin: 28.85%
💵 Total Sales: ₦156,750.00
💸 Total Cost: ₦111,500.00

📅 Date: 06 Nov 2024
🕒 Generated: 3:45 PM

Keep up the great work! 🌟
```

#### **📋 Full Business Report**
Get comprehensive business overview:

```
• "Send report"
• "Full report"
• "Business report"
• "Daily report"
```

**Sample Response:**
```
📋 Daily Business Report - [Business Name]

📅 Date: 06 Nov 2024

💰 SALES SUMMARY
Total Sales: ₦156,750.00
Total Transactions: 23
Average Sale: ₦6,815.22

💵 PROFIT ANALYSIS  
Total Profit: ₦45,250.00
Profit Margin: 28.85%
Cost of Goods: ₦111,500.00

🏆 TOP PRODUCTS
1. Samsung Galaxy A54 - 8 units
2. iPhone 13 Case - 12 units  
3. Wireless Earbuds - 6 units

📊 PERFORMANCE
• Peak Hour: 2:00 PM - 3:00 PM
• Busiest Day: Today
• Growth: +15% vs yesterday

Generated at 3:45 PM
Have a profitable day! 💪
```

#### **🏆 Top Products Report**
See best-selling items:

```
• "Top products"
• "Best selling"
• "Popular items"
• "Top items today"
```

**Sample Response:**
```
🏆 Top Products Today - [Business Name]

1️⃣ Samsung Galaxy A54
   📦 Units Sold: 8
   💰 Revenue: ₦2,400,000.00

2️⃣ iPhone 13 Case  
   📦 Units Sold: 12
   💰 Revenue: ₦180,000.00

3️⃣ Wireless Earbuds
   📦 Units Sold: 6  
   💰 Revenue: ₦450,000.00

📅 Date: 06 Nov 2024
🕒 Updated: 3:45 PM

Keep stocking winners! 🌟
```

#### **❓ Help & Commands**
Get list of available commands:

```
• "Help"
• "Commands"  
• "What can you do?"
```

---

## 🧾 Automatic Invoice Delivery

### **How It Works**
1. **Customer completes purchase** in your POS system
2. **System automatically generates** professional PDF invoice
3. **WhatsApp message sent** to customer with invoice attached
4. **Delivery tracked** in WhatsApp Bot → Logs

### **Sample Auto-Invoice Message**
```
🧾 *Invoice from [Business Name]*

Invoice No: *INV-2024-001234*
Date: 06 Nov 2024, 3:56 PM
Amount: ₦25,750.00

✅ Status: *PAID*

📄 Please find your invoice attached below.

Thank you for your business! 🙏

📞 Contact: +234801234567
📧 Email: business@example.com

*[Business Name]* - Your trusted partner
```
*[PDF attachment included]*

### **Requirements for Auto-Invoice**
- ✅ Customer must have phone number in contact record
- ✅ Business WhatsApp must be enabled
- ✅ Auto-send invoices must be enabled in settings
- ✅ Transaction must be finalized (not draft/quotation)

---

## 🔧 Troubleshooting

### **Common Issues & Solutions**

#### **📵 "Business Not Found" Error**
**Problem**: WhatsApp bot says "Business Not Found"
**Solution**: 
1. **Verify sender number**: Make sure you're sending FROM the WhatsApp number registered in your business settings
2. **Check format**: Ensure phone number format is `+2348012345678` in settings
3. **Confirm setup**: The `whatsapp_phone` in your business settings must match the sender's number exactly

#### **📱 No Response from Bot**
**Problem**: Bot doesn't respond to messages
**Solution**:
1. Check **WhatsApp Bot → Settings** - ensure bot is enabled
2. Verify webhook URL is correct in NearBuyMarts dashboard
3. Check **WhatsApp Bot → Logs** for error messages
4. Test API connection in **Test Messages**

#### **🧾 Invoices Not Auto-Sending**
**Problem**: Customers not receiving invoice PDFs
**Solution**:
1. Check **WhatsApp Bot → Settings** - ensure "Auto-Send Invoices" is enabled
2. Verify customer has mobile number in contact record
3. Check **WhatsApp Bot → Logs → Invoice Logs** for delivery status
4. Ensure transaction is finalized (not draft)

#### **📊 Reports Show ₦0.00**
**Problem**: All reports show zero amounts
**Solution**:
1. Verify you're messaging from correct business WhatsApp number
2. Check if business has sales data for requested date
3. Ensure transactions are properly finalized in POS

---

## 📱 Message Examples for Quick Copy-Paste

### **Quick Commands**
```
Today sales
Yesterday profit  
This week sales
Send report
Top products
Help
```

### **Natural Language Examples**
```
How much did we sell today?
What's our profit this month?
Show me yesterday's sales report
Send me the daily business report
What are our best selling products?
```

---

## 🎯 Best Practices

### **For Business Owners**
1. **Check reports daily** using "Send report" command
2. **Monitor top products** to optimize inventory
3. **Track profit margins** weekly for financial health
4. **Verify invoice delivery** in logs regularly

### **For Staff Training**
1. **Teach customers** they'll receive WhatsApp invoices automatically
2. **Ensure phone numbers** are collected during sales
3. **Verify customer contact** details are up-to-date
4. **Test message delivery** before going live

### **For System Administrators**  
1. **Monitor webhook** logs for delivery issues
2. **Check API quotas** with NearBuyMarts regularly
3. **Backup invoice logs** periodically
4. **Update tokens** when they expire

---

## 📞 Support & Contact

If you need assistance:
- **Check Logs**: WhatsApp Bot → Logs for detailed error messages
- **Test Connection**: Use Test Messages feature to verify setup
- **Review Settings**: Ensure all configuration is correct
- **Contact Support**: Include error logs and configuration details

---

*📅 Last Updated: November 6, 2024*
*🔄 Version: 1.0.0*