<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Auth;

class CustomerDisplayController extends Controller
{
    // Display the Customer Panel Page
    public function index()
    {
        return view('customer_display.index');
    }

    // Method to save cart data as a JSON file
    public function saveCartData(Request $request)
    {
        $cartData = $request->json()->all(); // Parse JSON request body
        //    \Log::info('Received Cart Data:', $cartData);

        $user_id = Auth::id();
        $filePath = public_path("c_display_jsons/cart_data_user_" . $user_id . ".json");

        if (!file_exists(dirname($filePath))) {
            mkdir(dirname($filePath), 0775, true);
        }

        file_put_contents($filePath, json_encode($cartData, JSON_PRETTY_PRINT));

        return response()->json(['message' => 'Cart data saved successfully.']);
    }



    public function getCartData()
    {
        $user_id = Auth::id();
        $filePath = public_path("c_display_jsons/cart_data_user_" . $user_id . ".json");

        if (file_exists($filePath)) {
            $rawCartData = json_decode(file_get_contents($filePath), true);

            // Transform products into an array of items
            // Transform products into an array of items
            $items = [];
            $sum_line_discount = 0;
            foreach ($rawCartData['products'] as $productId => $productDetails) {
                // Convert values to float before performing arithmetic operations
                $unitPrice = floatval(str_replace([',', ' '], '', $productDetails['unit_price_inc_tax'])); // Remove commas or spaces
                $quantity = floatval($productDetails['quantity']); // Convert quantity to float
                $line_discount = floatval(str_replace([',', ' '], '', $productDetails['line_discount_amount'])); // Remove commas or spaces
                $sum_line_discount += $line_discount;
                $items[] = [
                    'item_name' => $productDetails['product_name'], // Replace with actual name if available
                    'item_unit_price' => $unitPrice,
                    'item_quantity' => $quantity,
                    'item_line_discount' => $line_discount,
                    'item_total_price_table' => $unitPrice * $quantity, // Calculate subtotal
                ];
            }
            $sum_discount = $rawCartData['discount_amount'] + $sum_line_discount;
       

            // Format the data for the frontend
            $cartData = [
                'items' => $items,
                'total_items_in_cart' => count($items),
                'total_payable' => $rawCartData['final_total'], // Ensure the total payable is numeric
                'discount_amount' => $sum_discount,
                'tax_calculation_amount' => $rawCartData['tax_calculation_amount'],
                'shipping_charges' => $rawCartData['shipping_charges'],
            ];


            return response()->json([
                'status' => true,
                'data' => $cartData
            ]);
        }

        return response()->json([
            'status' => false,
            'message' => 'Cart data not found'
        ]);
    }

    // Method to delete cart data
    public function deleteCartData()
    {
        $user_id = Auth::id();
        $filePath = public_path("c_display_jsons/cart_data_user_" . $user_id . ".json");

        if (file_exists($filePath)) {
            unlink($filePath);
            return response()->json(['message' => 'Cart data deleted successfully.']);
        }

        return response()->json(['message' => 'Cart data not found.']);
}


}
