<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(){

        Schema::create('service_warranties', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('location_id')->unsigned();
            $table->integer('product_id')->unsigned();
            $table->integer('serial_id')->unsigned()->nullable();
            $table->integer('service_transaction_id')->nullable()->unsigned();
            $table->decimal('service_fee', 22, 4)->nullable();
            $table->string('status')->default('received');
            $table->timestamp('received_time')->nullable();
            $table->timestamp('delivery_time')->nullable();
            $table->string('old_serial')->nullable();
            $table->string('new_serial')->nullable();
            $table->string('service_recived_no')->nullable();
            $table->string('service_delivery_no')->nullable();
            $table->timestamps();
        });
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('service_warranties');
    }
};
