<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('variations', function (Blueprint $table) {
            $table->string('first_unit_sku')->after('sell_price_inc_tax')->comment('First Unit SKU')->nullable();
            $table->decimal('fu_default_purchase_price', 22, 4)->after('first_unit_sku')->comment('First Unit')->nullable();
            $table->decimal('fu_dpp_inc_tax', 22, 4)->after('fu_default_purchase_price')->comment('First Unit')->default(0);
            $table->decimal('fu_profit_percent', 22, 4)->after('fu_dpp_inc_tax')->comment('First Unit')->default(0);
            $table->decimal('fu_default_sell_price', 22, 4)->after('fu_profit_percent')->comment('First Unit')->nullable();
            $table->decimal('fu_sell_price_inc_tax', 22, 4)->after('fu_default_sell_price')->comment('First Unit')->nullable();
            
            $table->string('second_unit_sku')->after('fu_sell_price_inc_tax')->comment('Second Unit SKU')->nullable();
            $table->decimal('su_default_purchase_price', 22, 4)->after('second_unit_sku')->comment('Second Unit')->nullable();
            $table->decimal('su_dpp_inc_tax', 22, 4)->after('su_default_purchase_price')->comment('Second Unit')->default(0);
            $table->decimal('su_profit_percent', 22, 4)->after('su_dpp_inc_tax')->comment('Second Unit')->default(0);
            $table->decimal('su_default_sell_price', 22, 4)->after('su_profit_percent')->comment('Second Unit')->nullable();
            $table->decimal('su_sell_price_inc_tax', 22, 4)->after('su_default_sell_price')->comment('Second Unit')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('variations', function (Blueprint $table) {
            if (Schema::hasColumn('variations', 'first_unit_sku')) {
                $table->dropColumn('first_unit_sku');
            }   
            if (Schema::hasColumn('variations', 'second_unit_sku')) {
                $table->dropColumn('second_unit_sku');
            }   
            if (Schema::hasColumn('variations', 'fu_default_purchase_price')) {
                $table->dropColumn('fu_default_purchase_price');
            }   
            if (Schema::hasColumn('variations', 'su_default_purchase_price')) {
                $table->dropColumn('su_default_purchase_price');
            }   
            if (Schema::hasColumn('variations', 'fu_dpp_inc_tax')) {
                $table->dropColumn('fu_dpp_inc_tax');
            }   
            if (Schema::hasColumn('variations', 'su_dpp_inc_tax')) {
                $table->dropColumn('su_dpp_inc_tax');
            }   
            if (Schema::hasColumn('variations', 'fu_default_sell_price')) {
                $table->dropColumn('fu_default_sell_price');
            }   
            if (Schema::hasColumn('variations', 'su_default_sell_price')) {
                $table->dropColumn('su_default_sell_price');
            }   
            if (Schema::hasColumn('variations', 'fu_sell_price_inc_tax')) {
                $table->dropColumn('fu_sell_price_inc_tax');
            }   
            if (Schema::hasColumn('variations', 'su_sell_price_inc_tax')) {
                $table->dropColumn('su_sell_price_inc_tax');
            }
        });
    }
};
