<?php

namespace Database\Seeders;

use App\NotificationTemplate;
use App\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use Carbon\Carbon;

class DummyDataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::beginTransaction();

        $password = Hash::make('123456');

        $today = \Carbon::now()->format('Y-m-d H:i:s');
        $yesterday = \Carbon::now()->subDays(2)->format('Y-m-d H:i:s');
        $last_week = \Carbon::now()->subDays(7)->format('Y-m-d H:i:s');
        $last_15th_day = \Carbon::now()->subDays(15)->format('Y-m-d H:i:s');
        $last_month = \Carbon::now()->subDays(30)->format('Y-m-d H:i:s');

        $next_6_month = \Carbon::now()->addMonths(6)->format('Y-m-d');
        $next_12_month = \Carbon::now()->addMonths(12)->format('Y-m-d');
        $next_18_month = \Carbon::now()->addMonths(18)->format('Y-m-d');

        $start_of_week = \Carbon::now()->startOfWeek()->format('Y-m-d');
        $end_of_week = \Carbon::now()->endOfWeek()->format('Y-m-d');

        DB::statement('SET FOREIGN_KEY_CHECKS = 0');

        $shortcuts = '{"pos":{"express_checkout":"shift+e","pay_n_ckeckout":"shift+p","draft":"shift+d","cancel":"shift+c","edit_discount":"shift+i","edit_order_tax":"shift+t","add_payment_row":"shift+r","finalize_payment":"shift+f","recent_product_quantity":"f2","add_new_product":"f4"}}';

        $prefixes = '{"purchase":"PO","stock_transfer":"ST","stock_adjustment":"SA","sell_return":"CN","expense":"EP","contacts":"CO","purchase_payment":"PP","sell_payment":"SP","business_location":"BL"}';

        // Insert Users data first (needed for business.owner_id foreign key)
        DB::insert("INSERT INTO users (id, surname, first_name, last_name, username, email, password, language, contact_no, address, remember_token, business_id, is_cmmsn_agnt, cmmsn_percent, deleted_at, created_at, updated_at) VALUES
                    (1, 'Mr', 'Admin', NULL, 'admin', 'admin@example.com', '$password', 'en', NULL, NULL, '6wUbpN3xEjDDyQwCfHiGqO7JkIQgjYoDFeQMxcp09YQXq1Ih1e5EqydddBMz', 1, 0, '0.00', NULL, '2018-01-04 02:15:19', '2018-01-04 02:15:19')");

        // Insert Business data
        $business = [
            ['id' => '1', 'name' => 'ERP', 'currency_id' => '2', 'start_date' => '2018-01-01', 'tax_number_1' => '3412569900', 'tax_label_1' => 'GSTIN', 'tax_number_2' => null, 'tax_label_2' => null, 'default_sales_tax' => null, 'default_profit_percent' => '25.00', 'owner_id' => '1', 'time_zone' => 'America/Phoenix', 'fy_start_month' => '1', 'accounting_method' => 'fifo', 'default_sales_discount' => '10.00', 'sell_price_tax' => 'includes', 'logo' => null, 'sku_prefix' => 'AS', 'enable_product_expiry' => '0', 'expiry_type' => 'add_expiry', 'on_product_expiry' => 'keep_selling', 'stop_selling_before' => '0', 'enable_tooltip' => '1', 'purchase_in_diff_currency' => '0', 'purchase_currency_id' => null, 'p_exchange_rate' => '1.000', 'transaction_edit_days' => '30', 'stock_expiry_alert_days' => '30', 'keyboard_shortcuts' => $shortcuts, 'pos_settings' => '{"disable_pay_checkout":0,"disable_draft":0,"disable_express_checkout":0,"hide_product_suggestion":0,"hide_recent_trans":0,"disable_discount":0,"disable_order_tax":0, "customer_display_screen":1, "display_screen_heading":"<h2 style=\"text-align: center;\">Welcome<\/h2>", "carousel_image_1":"1744193481_20662.jpg","carousel_image_2":"1744193481_9195778.jpg","carousel_image_4":"1744193481_14928.jpg","carousel_image_5":"1744193481_14931.jpg"}', 'enable_brand' => '1', 'enable_category' => '1', 'enable_sub_category' => '1', 'enable_price_tax' => '1', 'enable_purchase_status' => '1', 'enable_lot_number' => '0', 'default_unit' => null, 'enable_racks' => '0', 'enable_row' => '0', 'enable_position' => '0', 'enable_editing_product_from_purchase' => '1', 'sales_cmsn_agnt' => null, 'item_addition_method' => '1', 'enable_inline_tax' => '1', 'currency_symbol_placement' => 'before', 'enabled_modules' => '["purchases","add_sale","pos_sale","stock_transfers","stock_adjustment","expenses","account"]', 'date_format' => 'm/d/Y', 'time_format' => '24', 'ref_no_prefixes' => $prefixes, 'created_at' => '2018-01-04 02:15:19', 'updated_at' => '2018-01-04 02:17:08', 'common_settings' => null],
        ];
        DB::table('business')->insert($business);

        // Insert Business Locations data
        $business_locations = [
            ['id' => '1', 'business_id' => '1', 'location_id' => null, 'name' => 'Awesome Shop', 'landmark' => 'Linking Street', 'country' => 'USA', 'state' => 'Arizona', 'city' => 'Phoenix', 'zip_code' => '85001', 'invoice_scheme_id' => '1', 'invoice_layout_id' => '1', 'sale_invoice_layout_id' => '1', 'selling_price_group_id' => null, 'print_receipt_on_invoice' => '1', 'receipt_printer_type' => 'browser', 'printer_id' => null, 'mobile' => null, 'alternate_number' => null, 'email' => null, 'website' => null, 'is_active' => '1', 'default_payment_accounts' => '{"cash":{"is_enabled":"1","account":null},"card":{"is_enabled":"1","account":null},"cheque":{"is_enabled":"1","account":null},"bank_transfer":{"is_enabled":"1","account":null},"other":{"is_enabled":"1","account":null},"custom_pay_1":{"is_enabled":"1","account":null},"custom_pay_2":{"is_enabled":"1","account":null},"custom_pay_3":{"is_enabled":"1","account":null}}', 'custom_field1' => null, 'custom_field2' => null, 'custom_field3' => null, 'custom_field4' => null, 'deleted_at' => null, 'created_at' => '2018-01-04 02:15:20', 'updated_at' => '2019-12-11 04:53:39'],
        ];
        DB::table('business_locations')->insert($business_locations);

        // Insert Contacts data
        $contacts = [
            ['id' => '1', 'business_id' => '1', 'type' => 'customer', 'supplier_business_name' => null, 'first_name' => 'Walk-In Customer', 'name' => 'Walk-In Customer', 'email' => null, 'contact_id' => 'CO0005', 'tax_number' => null, 'city' => 'Phoenix', 'state' => 'Arizona', 'country' => 'USA', 'address_line_1' => 'Linking Street', 'mobile' => '(378) 400-1234', 'landline' => null, 'alternate_number' => null, 'pay_term_number' => null, 'pay_term_type' => null, 'created_by' => '1', 'is_default' => '1', 'customer_group_id' => null, 'custom_field1' => null, 'custom_field2' => null, 'custom_field3' => null, 'custom_field4' => null, 'deleted_at' => null, 'created_at' => '2018-01-03 20:45:20', 'updated_at' => '2018-06-11 22:22:05'],
        ];
        DB::table('contacts')->insert($contacts);

        // Insert Invoice Schemes data
        DB::insert("INSERT INTO invoice_schemes (id, business_id, name, scheme_type, prefix, start_number, invoice_count, total_digits, is_default, created_at, updated_at) VALUES
                    (1, 1, 'Default', 'blank', 'AS', 1, 5, 4, 1, '2018-01-04 02:15:20', '2018-01-04 02:45:16')");

        // Insert Invoice Layouts data
        $invoice_layouts = [
            ['id' => '1', 'name' => 'Default', 'header_text' => null, 'invoice_no_prefix' => 'Invoice No.', 'quotation_no_prefix' => null, 'invoice_heading' => 'Invoice', 'sub_heading_line1' => null, 'sub_heading_line2' => null, 'sub_heading_line3' => null, 'sub_heading_line4' => null, 'sub_heading_line5' => null, 'invoice_heading_not_paid' => '', 'invoice_heading_paid' => '', 'quotation_heading' => null, 'sub_total_label' => 'Subtotal', 'discount_label' => 'Discount', 'tax_label' => 'Tax', 'total_label' => 'Total', 'total_due_label' => 'Total Due', 'paid_label' => 'Total Paid', 'show_client_id' => '0', 'client_id_label' => null, 'client_tax_label' => null, 'date_label' => 'Date', 'show_time' => '1', 'show_brand' => '0', 'show_sku' => '1', 'show_cat_code' => '1', 'show_sale_description' => '0', 'table_product_label' => 'Product', 'table_qty_label' => 'Quantity', 'table_unit_price_label' => 'Unit Price', 'table_subtotal_label' => 'Subtotal', 'cat_code_label' => null, 'logo' => null, 'show_logo' => '0', 'show_business_name' => '0', 'show_location_name' => '1', 'show_landmark' => '1', 'show_city' => '1', 'show_state' => '1', 'show_zip_code' => '1', 'show_country' => '1', 'show_mobile_number' => '1', 'show_alternate_number' => '0', 'show_email' => '0', 'show_tax_1' => '1', 'show_tax_2' => '0', 'show_barcode' => '0', 'show_payments' => '1', 'show_customer' => '1', 'customer_label' => 'Customer', 'highlight_color' => '#000000', 'footer_text' => '', 'module_info' => null, 'is_default' => '1', 'business_id' => '1', 'design' => 'classic', 'cn_heading' => null, 'cn_no_label' => null, 'cn_amount_label' => null, 'created_at' => '2018-04-03 23:35:32', 'updated_at' => '2018-04-03 23:35:32'],
        ];
        DB::table('invoice_layouts')->insert($invoice_layouts);

        // Insert Units data
        DB::insert("INSERT INTO units (id, business_id, actual_name, short_name, allow_decimal, base_unit_id, base_unit_multiplier, created_by, deleted_at, created_at, updated_at) VALUES
                    (1, 1, 'Pieces', 'Pc(s)', 0, NULL, NULL, 1, NULL, '2018-01-03 15:15:20', '2018-01-03 15:15:20')");

        // Insert System data
        $system = [
            ['key' => 'default_business_active_status', 'value' => '1'],
            ['key' => 'app_currency_id', 'value' => '2'],
            ['key' => 'invoice_business_name', 'value' => 'Ultimate POS'],
            ['key' => 'invoice_business_landmark', 'value' => 'Linking Street'],
            ['key' => 'invoice_business_zip', 'value' => '85001'],
            ['key' => 'invoice_business_state', 'value' => 'Arizona'],
            ['key' => 'invoice_business_city', 'value' => 'Phoenix'],
            ['key' => 'invoice_business_country', 'value' => 'USA'],
            ['key' => 'email', 'value' => 'admin@gmail.com'],
            ['key' => 'enable_offline_payment', 'value' => '1'],
        ];
        foreach ($system as $row) {
            DB::table('system')->where('key', $row['key'])->update(['value' => $row['value']]);
        }

        // Insert Notification Templates
        $notification_template_data = NotificationTemplate::defaultNotificationTemplates();
        $notification_template_array = [];
        foreach ($notification_template_data as $notification_template) {
            $notification_template['business_id'] = 1;
            $notification_template_array[] = $notification_template;
        }
        DB::table('notification_templates')->insert($notification_template_array);

        // Roles and permissions for business 1
        $admin_role1 = Role::create([
            'name' => 'Admin#1',
            'business_id' => 1,
            'guard_name' => 'web',
            'is_default' => 1,
        ]);
        $cashier_role1 = Role::create([
            'name' => 'Cashier#1',
            'business_id' => 1,
            'guard_name' => 'web',
        ]);

        $cashier_role1->syncPermissions(['sell.view', 'sell.create', 'sell.update', 'sell.delete', 'view_cash_register', 'close_cash_register', 'print_invoice']);

        $admin1 = User::findOrFail(1);
        $admin1->assignRole('Admin#1');

        Permission::create(['name' => 'location.1']);

        DB::statement('SET FOREIGN_KEY_CHECKS = 1');

        DB::commit();
    }
}
