<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Customer Display</title>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="{{ asset('js/customer_display.js') }}"></script>
    <!-- jQuery 3.7.1 -->
    <script src="{{ asset('js/jquery.min.js') }}"></script>

    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="{{ asset('css/bootstrap.min.css') }}">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

    <!-- Custom Styles -->
    <link rel="stylesheet" href="{{ asset('css/customer_display.css') }}">
</head>


<body>
    <div class="customer_display_wrap">

        <div class="customer-display">
            <h2>{{__('lang_v1.customer_display')}}
                <a href="javascript:void(0)" id="fullscreen" class="pull-right">
                    <i class='fa fa-arrows-alt'></i>
                </a>
            </h2>
            

            <!-- Loading spinner -->
            <div id="loading-spinner" style="display:none;">Loading...</div>
            <div class="customer_display_inner_wrapper">
                <!-- Customer Display Header -->



                <!-- Cart Items -->
                <div class="customer_display_body" id="cart-items" role="list">
                    <!-- Dynamic cart items will be loaded here -->
                    <p id="empty-cart-message" style="display:none;">Your cart is empty.</p>
                </div>
            </div>

            <!-- Totals -->



            <div class="customer_display_footer">
                <div class="footer-calculate">
                    <div class="total-item">
                        <span class="footer-header">{{__('lang_v1.total_items')}}:</span><br>
                        <span id="total-items"></span>
                    </div>
                    <div class="tax">
                        <span class="footer-header">{{__('lang_v1.tax')}}:</span><br>
                        <span id="tax_calculation_amount"></span>
                    </div>
                    <div class="charge">
                        <span class="footer-header">{{__('lang_v1.shipping_charges')}}:</span><br>
                        <span id="shipping_charges"></span>
                    </div>
                    <div class="discount">
                        <span class="footer-header">{{__('lang_v1.discount')}}:</span><br>
                        <span id="discount_amount"></span>
                    </div>
                </div>
            </div>
            <div class="total-payable">
                <h2>{{__('lang_v1.total_payable')}}: <span class="total-payable" id="total-payable"></span></h2>
            </div>

        </div>
    </div>


   
</body>

</html>