<table style="padding: 2px; margin: 0 auto; border-spacing: {{$barcode_details->col_distance * 1}}in {{$barcode_details->row_distance * 1}}in;">
    @foreach($page_products as $page_product)
        @if($loop->index % $barcode_details->stickers_in_one_row == 0)
            <!-- create a new row -->
            <tr>
        @endif
            <td align="center" valign="center" style="padding: 2px; border: 1px dotted lightgray;">
				<div style="display: flex; flex-direction: column; align-items: center; text-align: center; margin: 0; padding: 0; width: {{$barcode_details->width * 1}}in; height: {{$barcode_details->height * 1}}in; justify-content: center;">

           <!-- Business Name -->
    @if(!empty($print['business_name']))
	<b style="font-size: {{ $print['business_name_size'] - 2 }}px; margin-bottom: 1px;">{{ $business_name }}</b>
@endif

<!-- Product Name -->
@if(!empty($print['name']))
	<span style="font-size: {{ $print['name_size'] - 2 }}px; margin-bottom: 1px;">
		{{ $page_product->product_actual_name }}
		@if(!empty($print['lot_number']) && !empty($page_product->lot_number))
			<span style="font-size: 8px; margin-left: 2px;">
				({{ $page_product->lot_number }})
			</span>
		@endif
	</span>
@endif

                    <!-- Variation -->
                    @if(!empty($print['variations']) && $page_product->is_dummy != 1)
                        <span style="font-size: {{$print['variations_size']}}px; margin-bottom: 4px;">
                            {{$page_product->product_variation_name}}: <b>{{$page_product->variation_name}}</b>
                        </span>
                    @endif

                    <!-- Custom Fields -->
                    @php
                        $custom_labels = json_decode(session('business.custom_labels'), true);
                        $product_custom_fields = !empty($custom_labels['product']) ? $custom_labels['product'] : [];
                    @endphp
                    @foreach($product_custom_fields as $index => $cf)
                        @php
                            $field_name = 'product_custom_field' . $loop->iteration;
                        @endphp
                        @if(!empty($cf) && !empty($page_product->$field_name) && !empty($print[$field_name]))
                            <span style="font-size: {{ $print[$field_name . '_size'] }}px; margin-bottom: 4px;">
                                <b>{{ $cf }}:</b> {{ $page_product->$field_name }}
                            </span>
                        @endif
                    @endforeach

                    <!-- Price -->
                    @if(!empty($print['price']))
                        <span style="font-size: {{ $print['price_size'] ?? 10 }}px; margin-bottom: 1px;">
                            @lang('lang_v1.price'):
                            <b>{{ session('currency')['symbol'] ?? '' }}
								@if(!empty($print['price_type']) && $print['price_type'] == 'inclusive')
								{{ @num_format($page_product->sell_price_inc_tax) }}
								@else
								{{ @num_format($page_product->default_sell_price) }}
								@endif
                            </b>
                        </span>
                    @endif


					






                    <!-- Expiry Date -->
                    @if(!empty($print['exp_date']) && !empty($page_product->exp_date))
                        <span style="font-size: {{$print['exp_date_size']}}px; margin-bottom: 4px;">
                            <b>@lang('product.exp_date'):</b> {{$page_product->exp_date}}
                        </span>
                    @endif

                    <!-- Packing Date -->
                    @if(!empty($print['packing_date']) && !empty($page_product->packing_date))
                        <span style="font-size: {{$print['packing_date_size']}}px; margin-bottom: 4px;">
                            <b>@lang('lang_v1.packing_date'):</b> {{$page_product->packing_date}}
                        </span>
                    @endif

                    <!-- Small Image & Barcode -->
                    <div style="display: flex; justify-content: center; align-items: center; margin-top: 2px;">
                        <!-- Small Image -->
						@if (!empty($print['image']))
						<img src="https://whatsapp.cloud-horizonsoft.com/assets/images/waiting.jpg" alt="Logo" style="width: {{$print['image_size']}}px; height: {{$print['image_size']}}px; margin-bottom: 1px;">
							
						@endif
                        
                        <!-- Barcode -->
                        @if(!empty($print['barcode']))
                            <img style="max-width: 60%; height: {{$print['barcode_size'] * 0.24}}in; margin-bottom: 1px;" 
                                 src="data:image/png;base64,{{DNS1D::getBarcodePNG($page_product->sub_sku, 'C128', 1, 30, [0, 0, 0], false)}}">
                        @endif

                        <!-- QR Code -->
                        @if(!empty($print['qrcode']))
                            <img style="margin-top: 1px;margin-left: 4px;max-width:100% !important; display: block;" 
                                 src="data:image/png;base64,{{ DNS2D::getBarcodePNG($page_product->sub_sku, 'QRCODE', $print['qrcode_size'], $print['qrcode_size']) }}">

                                 @endif
                    </div>

                    <!-- SKU -->
                    @if(!empty($print['sku']))
					<span style="font-size: {{$print['sku_size']}}px; margin-top: 1px;">
                        {{$page_product->sub_sku}}
                    </span>
                    @endif
                </div>
            </td>
        @if($loop->iteration % $barcode_details->stickers_in_one_row == 0)
            </tr>
        @endif
    @endforeach
</table>

<style type="text/css">
    @media print {
        table { page-break-after: always; }
        @page {
            size: {{$paper_width}}in {{$paper_height}}in;
            margin: {{$margin_top}}in {{$margin_left}}in;
        }
    }
</style>
