@extends('layouts.app')
@section('title', __('barcode.print_labels'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
<br>
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('barcode.print_labels') @show_tooltip(__('tooltip.print_label'))</h1>
    <!-- <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
        <li class="active">Here</li>
    </ol> -->
</section>

<!-- Main content -->
<section class="content no-print">
	{!! Form::open(['url' => '#', 'method' => 'post', 'id' => 'preview_setting_form', 'onsubmit' => 'return false']) !!}
	@component('components.widget', ['class' => 'box-primary', 'title' => __('product.add_product_for_labels')])
		<div class="row">
			<div class="col-sm-8 col-sm-offset-2">
				<div class="form-group">
					<div class="input-group">
						<span class="input-group-addon">
							<i class="fa fa-search"></i>
						</span>
						{!! Form::text('search_product', null, ['class' => 'form-control', 'id' => 'search_product_for_label', 'placeholder' => __('lang_v1.enter_product_name_to_print_labels'), 'autofocus', 'onchange' => 'fetchPreview()']); !!}
					</div>
				</div>
			</div>
		</div>

		<div class="row">
			<div class="col-sm-10 col-sm-offset-1">
				<table class="table table-bordered table-striped table-condensed" id="product_table">
					<thead>
						<tr>
							<th>@lang( 'barcode.products' )</th>
							<th>@lang( 'barcode.no_of_labels' )</th>
							@if(request()->session()->get('business.enable_lot_number') == 1)
								<th>@lang( 'lang_v1.lot_number' )</th>
							@endif
							@if(request()->session()->get('business.enable_product_expiry') == 1)
								<th>@lang( 'product.exp_date' )</th>
							@endif
							<th>@lang('lang_v1.packing_date')</th>
							<th>@lang('lang_v1.selling_price_group')</th>
						</tr>
					</thead>
					<tbody>
						@include('labels.partials.show_table_rows', ['index' => 0])
					</tbody>
				</table>
			</div>
		</div>
	@endcomponent

	@component('components.widget', ['class' => 'box-primary', 'title' => __( 'barcode.info_in_labels' )])
		<div class="row">
		
			
		
			<div class="container">
				<div class="row">
					<!-- Left Section: Form Inputs -->
					<div class="col-md-6">
						
						<h3>Label Settings</h3>

						<form id="label-form">
							<table class="table table-bordered">
								<tr>
									<td colspan="2" style="width: 100%;">
										<div class="form-group">
											{!! Form::label('price_type', @trans( 'barcode.barcode_setting' ) . ':') !!}
											<div class="input-group">
												<span class="input-group-addon">
													<i class="fa fa-cog"></i>
												</span>
												{!! Form::select('barcode_setting', $barcode_settings, !empty($default) ? $default->id : null, ['class' => 'form-control select2', 'onchange' => 'fetchPreview()']); !!}
											</div>
										</div>
									</td>
								</tr>
								<tr>
									<td style="width: 50%;">  <!-- Reduced width for the label column -->
										<div class="checkbox">
											<label>
												{{-- <input type="checkbox" name="print[image]" value="1" class="input-icheck" onchange="fetchPreview()"> --}}
												<input type="checkbox" name="print[image]" value="1" class="input-icheck" onchange="console.log('Checkbox changed'); fetchPreview();">

												<b>@lang( 'business.business' ) @lang( 'lang_v1.image' )</b>
											</label>
										</div>
									</td>
									<td>
										<div class="input-group">
											<div class="input-group-addon"><b>@lang( 'lang_v1.size' )</b></div>
											<input type="text" class="form-control" name="print[image_size]" value="25" onchange="fetchPreview()">
										    <span class="input-group-addon">Pixels</span>

										</div>
									</td>
									
								</tr>
								<tr>
									<td style="width: 50%;">  <!-- Reduced width for the label column -->
										<div class="checkbox">
											<label>
												<input type="checkbox" checked name="print[barcode]" value="1" class="input-icheck">
												
												<b>@lang( 'barcode.barcodes' )</b>
											</label>
										</div>
									</td>
									<td>
										<div class="input-group">
											<div class="input-group-addon"><b>@lang( 'lang_v1.size' )</b></div>
											<input type="text" class="form-control" name="print[barcode_size]" value="0.8" onchange="fetchPreview()">
											<span class="input-group-addon">Inches</span>

										</div>
									</td>
								</tr>
								
								


								<tr>
									<td style="width: 50%;">
										<div class="checkbox">
											<label>
												{!! Form::checkbox('print[qrcode]', 1, false, ['class' => 'input-icheck', 'id' => 'print-qrcode', 'onchange' => 'toggleQRCodeInput(this)']) !!} 
												<b>@lang( 'barcode.print_qrcode' )</b>
											</label>
										</div>
									</td>
									<td>
										<div class="input-group">
											<div class="input-group-addon"><b>@lang( 'lang_v1.size' )</b></div>
											<input type="text" class="form-control" name="print[qrcode_size]" value="1.4" onchange="fetchPreview()">
											<span class="input-group-addon">Inches</span>
										</div>
										<!-- Additional input toggled by checkbox -->
										<div id="qrcode-switch" style="display: none; margin-top: 10px;">
											<label>
												<b>@lang('Switch to SKU or Text')</b>
											</label>
											<input type="text" class="form-control" id="qrcode-input" placeholder="Enter SKU or text" style="margin-top: 5px;">
										</div>
									</td>
								</tr>
								
								




								
								<tr>
									<td style="width: 50%;">
										<div class="checkbox">
											<label>
												<input type="checkbox" name="print[sku]" value="1" class="input-icheck" 
												onchange="console.log('Checkbox changed'); toggleSwitch(this); fetchPreview()"> 
												<b>@lang( 'product.sku' )</b>
											</label>
										</div>
									</td>
									<td>
										<div class="input-group">
											<div class="input-group-addon"><b>@lang( 'lang_v1.size' )</b></div>
											<input type="text" class="form-control" name="print[sku_size]" value="11" onchange="fetchPreview()">
											<span class="input-group-addon">Pixels</span>
										</div>
										
									</td>
								</tr>
								



								<tr>
									<td style="width: 50%;">
										<div class="checkbox">
											<label>
												<input type="checkbox" checked name="print[name]" value="1" class="input-icheck" onchange="fetchPreview()"> 
												<b>@lang( 'barcode.print_name' )</b>
											</label>
										</div>
									</td>
									<td>
										<div class="input-group">
											<div class="input-group-addon"><b>@lang( 'lang_v1.size' )</b></div>
											<input type="text" class="form-control" name="print[name_size]" value="11" onchange="fetchPreview()">
											<span class="input-group-addon">Pixels</span>

										</div>
									</td>
								</tr>
								<tr>
									<td style="width: 50%;">
										<div class="checkbox">
											<label>
												<input type="checkbox" name="print[variations]" value="1" class="input-icheck" onchange="fetchPreview()"> 
												<b>@lang( 'barcode.print_variations' )</b>
											</label>
										</div>
									</td>
									<td>
										<div class="input-group">
											<div class="input-group-addon"><b>@lang( 'lang_v1.size' )</b></div>
											<input type="text" class="form-control" name="print[variations_size]" value="17" onchange="fetchPreview()">
											<span class="input-group-addon">Pixels</span>

										</div>
									</td>
								</tr>
								<tr>
									<td style="width: 50%;">
										<div class="checkbox">
											<label>
												<input type="checkbox" name="print[price]" value="1" id="is_show_price" class="input-icheck" onchange="fetchPreview()"> 
												<b>@lang( 'barcode.print_price' )</b>

											</label>
										</div>
									</td>
									<td>
										<div class="input-group">
											<div class="input-group-addon"><b>@lang( 'lang_v1.size' )</b></div>
											<input type="text" class="form-control" name="print[price_size]" value="9" onchange="fetchPreview()">
											<span class="input-group-addon">Pixels</span>

										</div>
									</td>
								</tr>
								<tr>
									<td style="width: 50%;">
										<div class="checkbox">
											<label>
												<input type="checkbox" name="print[business_name]" value="1" class="input-icheck" onchange="fetchPreview()"> 
												<b>@lang( 'barcode.print_business_name' )</b>
											</label>
										</div>
									</td>
									<td>
										<div class="input-group">
											<div class="input-group-addon"><b>@lang( 'lang_v1.size' )</b></div>
											<input type="text" class="form-control" name="print[business_name_size]" value="20" onchange="fetchPreview()">
											<span class="input-group-addon">Pixels</span>

										</div>
									</td>
								</tr>
								<tr>
									<td style="width: 50%;">
										<div class="checkbox">
											<label>
												<input type="checkbox" name="print[packing_date]" value="1" class="input-icheck" onchange="fetchPreview()"> 
												<b>@lang( 'lang_v1.print_packing_date' )</b>
											</label>
										</div>
									</td>
									<td>
										<div class="input-group">
											<div class="input-group-addon"><b>@lang( 'lang_v1.size' )</b></div>
											<input type="text" class="form-control" name="print[packing_date_size]" value="12" onchange="fetchPreview()">
											<span class="input-group-addon">Pixels</span>

										</div>
									</td>
								</tr>
								@if(request()->session()->get('business.enable_lot_number') == 1)
								<tr>
									<td style="width: 50%;">
										<div class="checkbox">
											<label>
												<input type="checkbox" name="print[lot_number]" value="1" class="input-icheck" onchange="fetchPreview()"> 
												<b>@lang( 'lang_v1.print_lot_number' )</b>
											</label>
										</div>
									</td>
									<td>
										<div class="input-group">
											<div class="input-group-addon"><b>@lang( 'lang_v1.size' )</b></div>
											<input type="text" class="form-control" name="print[lot_number_size]" value="12" onchange="fetchPreview()">
											<span class="input-group-addon">Pixels</span>

										</div>
									</td>
								</tr>
								@endif
								@if(request()->session()->get('business.enable_product_expiry') == 1)
								<tr>
									<td style="width: 50%;">
										<div class="checkbox">
											<label>
												<input type="checkbox" name="print[exp_date]" value="1" class="input-icheck" onchange="fetchPreview()"> 
												<b>@lang( 'lang_v1.print_exp_date' )</b>
											</label>
										</div>
									</td>
									<td>
										<div class="input-group">
											<div class="input-group-addon"><b>@lang( 'lang_v1.size' )</b></div>
											<input type="text" class="form-control" name="print[exp_date_size]" value="12" onchange="fetchPreview()">
											<span class="input-group-addon">Pixels</span>

										</div>
									</td>
								</tr>
								@endif
								@php
									$c = 0;
									$custom_labels = json_decode(session('business.custom_labels'), true);
									$product_custom_fields = !empty($custom_labels['product']) ? $custom_labels['product'] : [];
									$product_cf_details = !empty($custom_labels['product_cf_details']) ? $custom_labels['product_cf_details'] : [];
								@endphp
								@foreach($product_custom_fields as $index => $cf)
									@if(!empty($cf))
										@php
											$field_name = 'product_custom_field' . $loop->iteration;
											$cf_type = !empty($product_cf_details[$loop->iteration]['type']) ? $product_cf_details[$loop->iteration]['type'] : 'text';
											$dropdown = !empty($product_cf_details[$loop->iteration]['dropdown_options']) ? explode(PHP_EOL, $product_cf_details[$loop->iteration]['dropdown_options']) : [];
											$c++;
										@endphp
										<tr>
											<td style="width: 50%;">
												<div class="checkbox">
													<label>
														<input type="checkbox" name="print[{{ $field_name }}]" value="1" class="input-icheck" onchange="fetchPreview()"> 
														<b>{{ $cf }}</b>
													</label>
												</div>
											</td>
											<td>
												<div class="input-group">
													<div class="input-group-addon"><b>@lang( 'lang_v1.size' )</b></div>
													<input type="text" class="form-control" name="print[{{ $field_name }}_size]" value="12" onchange="fetchPreview()">
													<span class="input-group-addon">Pixels</span>

												</div>
											</td>
										</tr>
										@if ($c % 4 == 0)
											</tr>
										@endif
									@endif
								@endforeach

								
							</table>
							
						</form>

						
			
						<div class="clearfix"></div>
						
						
					</div>
			
					<!-- Right Section: Preview -->
					<div class="col-md-5">
						<button type="button" class="tw-dw-btn tw-dw-btn-primary tw-text-white tw-dw-btn-sm" id="print_label">
							@lang('messages.print') @lang('lang_v1.label')
						</button>
						<button type="button" id="labels_preview_qr" class="tw-dw-btn tw-dw-btn-primary tw-text-white tw-dw-btn-sm">
							@lang('messages.print') Qr-code
						</button>
						
						<h3>Label Preview</h3>
						
						<div id="preview_box" style="border: 1px solid #ddd; padding: 20px; min-height: 400px;">
							<!-- The preview HTML will be injected here -->
						</div>
					</div>
				</div>
			</div>

		</div>
	@endcomponent
	<script type="text/javascript">
			   

// 		$(document).ready(function() {



// 	// Also trigger fetchPreview when any input in the preview form changes
// 	$('#preview_setting_form input, #preview_setting_form select').on('input change', function() {
// 		fetchPreview(); // Call fetchPreview when any relevant input changes
// 	});

	
// });
function fetchPreview() {
    const formData = $('#preview_setting_form').serialize();



					$.ajax({
						url: '{{ url('/labels/show_label_preview') }}', // Ensure this route exists and allows POST
						type: 'POST',
						data: formData,
						success: function(response) {
							console.log("Response from server: ", response); // Log server response
							if (response.success) {
								$('#preview_box').html(response.html); // Update the preview section
							} else {
								alert(response.msg, 'Error'); // Show any messages returned from the server
							}
						},
						error: function(xhr, status, error) {
							console.error('AJAX Error:', error); // Log any errors for debugging
							console.error('Status:', status);
							console.error('Response:', xhr.responseText); // Log the response text for additional context
							alert('Error generating preview. Please check your input.'); // Alert user
						}
					});
				}


	</script>
	
			
	{!! Form::close() !!}

	<div class="col-sm-8 hide display_label_div">
		<h3 class="box-title">@lang( 'barcode.preview' )</h3>
		<button type="button" class="col-sm-offset-2 btn btn-success btn-block" id="print_label">Print</button>

	</div>
	<div class="clearfix"></div>
</section>

<!-- Preview section-->
{{-- <div id="preview_box">
</div> --}}
@section('javascript')
	
			<script src="{{ asset('js/labels.js?v=' . $asset_v) }}"></script>
			<script>
$('.input-icheck').on('ifChanged', function(event){
    console.log('Checkbox changed');
    fetchPreview();
});

			</script>

@endsection

<style>
#toggle-switch {
    display: block !important;
    visibility: visible !important;
    opacity: 1 !important;
}

</style>
@stop
