@extends('layouts.app')

@section('title', __('sale.pos_sale'))

@section('content')


    <style>

        .tags {
            margin-bottom: 10px;
        }

        .tags .tag {
            display: inline-block;
            margin-right: 10px;
            padding: 5px 9px;
            font-size: 14px;
            background: #ddd;
            border-radius: 4px;
        }

        .tags .tag span {
            margin-right: 20px;
            display: inline;
        }

        .tags .tag .remove-button {
            display: inline;
            cursor: pointer;
        }
    </style>

    @php
        $is_mobile = isMobile();
    @endphp



    <section class="content no-print">

        <input type="hidden" id="amount_rounding_method" value="{{ $pos_settings['amount_rounding_method'] ?? '' }}">
        @if (!empty($pos_settings['allow_overselling']))
            <input type="hidden" id="is_overselling_allowed">
        @endif
        @if (session('business.enable_rp') == 1)
            <input type="hidden" id="reward_point_enabled">
        @endif
        @php
            $is_discount_enabled = $pos_settings['disable_discount'] != 1 ? true : false;
            $is_rp_enabled = session('business.enable_rp') == 1 ? true : false;
        @endphp

        {!! Form::open(['url' => action([\App\Http\Controllers\SellPosController::class, 'store']), 'method' => 'post', 'id' => 'add_pos_sell_form',]) !!}
        <div class="row mb-12">
            <div class="col-md-12 tw-pt-0 tw-mb-14">
                <div class="row">
                    {{-- <div class="@if (empty($pos_settings['hide_product_suggestion'])) col-md-7 @else col-md-10 col-md-offset-1 @endif no-padding pr-12"> --}}
                        <div class="col-md-9 tw-no-padding tw-px-5" >
    
                            <div class="tw-shadow-[rgba(17,_17,_26,_0.1)_0px_0px_16px] tw-rounded-2xl tw-bg-white tw-mb-2 md:tw-mb-8 tw-p-2">
    
                                {{-- <div class="box box-solid mb-12 @if (!isMobile()) mb-40 @endif"> --}}
                                    <div class="box-body pb-0">
                                        {!! Form::hidden('location_id', $default_location->id ?? null, [
                                            'id' => 'location_id',
                                            'data-receipt_printer_type' => !empty($default_location->receipt_printer_type)
                                                ? $default_location->receipt_printer_type
                                                : 'browser',
                                            'data-default_payment_accounts' => $default_location->default_payment_accounts ?? '',
                                        ]) !!}
                                        <!-- sub_type -->
                                        {!! Form::hidden('sub_type', isset($sub_type) ? $sub_type : null) !!}
                                        <input type="hidden" id="item_addition_method"
                                            value="{{ $business_details->item_addition_method }}">
                                        @include('sale_pos.partials.pos_form')
													
                                        @include('sale_pos.partials.pos_form_totals')
    
                                        @include('sale_pos.partials.payment_modal')
    
                                        @if (empty($pos_settings['disable_suspend']))
                                            @include('sale_pos.partials.suspend_note_modal')
                                        @endif
    
                                        @if (empty($pos_settings['disable_recurring_invoice']))
                                            @include('sale_pos.partials.recurring_invoice_modal')
                                        @endif
                                    </div>
                                {{-- </div> --}}
                            </div>
                        </div>
						  
                        @if (empty($pos_settings['hide_product_suggestion']) && !isMobile())
                        <div class="tw-w-full tw-px-5 col-md-3">
                            @include('sale_pos.partials.pos_sidebar')
                        </div>
                        @endif
                </div>
            </div>


            @if (isset($transaction))
                @include('sale_pos.partials.edit_discount_modal', [
                    'sales_discount' => $transaction->discount_amount,
                    'discount_type' => $transaction->discount_type,
                    'rp_redeemed' => $transaction->rp_redeemed,
                    'rp_redeemed_amount' => $transaction->rp_redeemed_amount,
                    'max_available' => !empty($redeem_details['points']) ? $redeem_details['points'] : 0,
                ])
            @else
                @include('sale_pos.partials.edit_discount_modal', [
                    'sales_discount' => $business_details->default_sales_discount,
                    'discount_type' => 'percentage',
                    'rp_redeemed' => 0,
                    'rp_redeemed_amount' => 0,
                    'max_available' => 0,
                ])
            @endif

            @if (isset($transaction))
                @include('sale_pos.partials.edit_order_tax_modal', ['selected_tax' => $transaction->tax_id])
            @else
                @include('sale_pos.partials.edit_order_tax_modal', [
                    'selected_tax' => $business_details->default_sales_tax,
                ])
            @endif

            @include('sale_pos.partials.edit_shipping_modal')

            @if (!$is_mobile)
                <div class="col-md-12">
                    @include('sale_pos.partials.pos_form_actions')
                </div>
            @endif
        </div>

        @if ($is_mobile)
            @include('sale_pos.partials.pos_form_actions')
        @endif
        {!! Form::close() !!}
</section>

    <!-- This will be printed -->
    <section class="invoice print_section" id="receipt_section">
    </section>
    <div class="modal fade contact_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
        @include('contact.create', ['quick_add' => true])
    </div>
    @if (empty($pos_settings['hide_product_suggestion']) && isMobile())
        @include('sale_pos.partials.mobile_product_suggestions')
    @endif
    <!-- /.content -->
    <div class="modal fade register_details_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
    </div>
    <div class="modal fade close_register_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
    </div>
    <!-- quick product modal -->
    <div class="modal fade quick_add_product_modal" tabindex="-1" role="dialog" aria-labelledby="modalTitle"></div>

    <div class="modal fade" id="expense_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
    </div>

    @include('sale_pos.partials.configure_search_modal')

    @include('sale_pos.partials.recent_transactions_modal')

    @include('sale_pos.partials.weighing_scale_modal')


    <div class="modal fade serial_modal" id="purchases_serial_numberModel" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog" style="width: 50%;" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="exampleModalLabel">Edit Serial Number</h5>
				</div>
				<div class="modal-body">
					<div class="tags_list">
						<div id="tags" class="tags">
							<!-- tag list -->
						</div>
					</div>
					<input value="" id="purchases_serial_number" class="purchases_serial_numberclass form-control input-sm" type="text" class="form-control">
				</div>
				<div class="modal-footer">
					<button type="button" id="modelReload" class="btn btn-primary" data-dismiss="modal">Save</button>
				</div>
			</div>
		</div>
	</div>


@stop
@section('css')
    <!-- include module css -->
    @if (!empty($pos_module_data))
        @foreach ($pos_module_data as $key => $value)
            @if (!empty($value['module_css_path']))
                @includeIf($value['module_css_path'])
            @endif
        @endforeach
    @endif
@stop
@section('javascript')
    <script src="{{ asset('js/pos.js?v=' . $asset_v) }}"></script>
    <script src="{{ asset('js/printer.js?v=' . $asset_v) }}"></script>
    <script src="{{ asset('js/product.js?v=' . $asset_v) }}"></script>
    <script src="{{ asset('js/opening_stock.js?v=' . $asset_v) }}"></script>

<script>

			

		// closs_recent_transaction
		// expend_recent_transactions

		$(document).on('click', '.recent_transaction_button', function(e) {
            $('#recent_transactions').addClass('expend_recent_transactions');
			$('#recent_transaction').addClass('d-none');
            get_recent_transactions('final', $('div#tab_final'));
		});
        
		$(document).on('click', '.closs_recent_transaction', function(e) {
            $('#recent_transactions').removeClass('expend_recent_transactions');
			$('#recent_transaction').removeClass('d-none');
		});
        
   

        $(document).ready( function(){
            // 
            const selectElement = document.getElementById("purchases_serial_number");
            const tagsContainer = document.getElementById("tags");
            let tags = [];

            // ---------------------------------------------------------------------------------
            $(document).on('click', '.purchases_serial_numberModelButton', function (params) {

                // Set ID For Input Id
                var inputfindid = this.value;
                const key = 'inputfindid';
                localStorage.setItem(key, inputfindid);

                // Set ID For Value Set
                var valueSetId = this.getAttribute('data-value');
                const key1 = 'valueSetId';
                localStorage.setItem(key1, valueSetId);
                // Get Previous value
                var previousValue = document.getElementById(valueSetId).value;
                var previousValueArry = previousValue.split(",");
                var previousValueArryLength = previousValueArry.length;
                if (previousValue === "") {
                    // tags = [];
                }else{
                    for (var i = 0; i < previousValueArry.length; i++) {
                        $("#tags").append(
                            "<div class='tag'><span>" + previousValueArry[i] + "</span><div class='remove-button'>x</div></div>"
                        );
                        tags.push(previousValueArry[i]);
                    }
                }

            })

            let lastSelectedValue;
            selectElement.addEventListener("keyup", (event) => {
                if (event.key === "Enter" || event.key === ",") {


                    // var getProductSetId = localStorage.getItem('productSetId');
                    // var getvariationidSetId = localStorage.getItem('variationidSetId');
                    // var location_id = $('select#location_id').find(':selected').val();


                    const value = selectElement.value.trim();
                    if (value) {

                        if (tags.includes(value) || value == "") {
                            
                        } else {
                            // $.ajax({
                            // 	url: '/serial/check_serial',
                            // 	type: 'POST',
                            // 	dataType: 'html',
                            // 	data: {
                            // 		serial_number: value,
                            // 		product_id: getProductSetId,
                            // 		location_id: location_id,
                            // 		variation_id: getvariationidSetId
                            // 	},
                            // 	success: function (result) {
                            // 		if (result == "0") {
                                        addTag(value);
                                        countUpFunction(value);
                            // 			} else {
                            // 				alert("This Serial Number Already Added");
                            // 			}
                            // 		},
                            // 	});
                        }
                        selectElement.value = "";
                    }
                }
            });

            function renderTags() {
                tagsContainer.innerHTML = "";
                tags.forEach((value) => {
                    const tagElement = document.createElement("div");
                    tagElement.classList.add("tag");
                    tagElement.innerHTML = `<span>${value}</span><div class="remove-button">x</div>`;
                    tagElement
                    .querySelector(".remove-button")
                    .addEventListener("click", function () {
                        // removeTag(value);
                        // renderTags();
                    });
                    tagsContainer.appendChild(tagElement);
                });
            }

            function addTag(value) {
                tags.push(value);

                var getValueSetId = localStorage.getItem('valueSetId');

                document.getElementById(getValueSetId).value = tags;

                renderTags();
            }

            function removeTag(value) {
                const index = tags.indexOf(value);
                if (index >= 0) {
                    tags.splice(index, 1);
                }

                var getValueSetId = localStorage.getItem('valueSetId');

                document.getElementById(getValueSetId).value = tags;

                renderTags();
            }

            $(document).on("click", '.remove-button', function () {
                if (event.target.className === "remove-button") {
                    var tag = event.target.closest(".tag");
                    var spanTag = tag.querySelector("span");
                    var value = spanTag.innerHTML;
                    removeTag(value);
                    countDownFunction(value);
                }
            });

            // 
            function countUpFunction(lastSelectedValue) {
                count = 1;
                var getInputFindId = localStorage.getItem('inputfindid');
                var input = $("#" + getInputFindId + "").find('input');
                var qty = __read_number(input);
                if (qty >= 0) {
                    __write_number(input, qty + count);
                    input.change();
                }

            }
            // Count Up

            // Count Down
            function countDownFunction(unselectedValue) {
                count = 1;
                var getInputFindId = localStorage.getItem('inputfindid');

                var input = $("#" + getInputFindId + "")
                    .find('input');
                var qty = __read_number(input);

                if (qty > 0) {
                    __write_number(input, qty - count);
                    input.change();
                }
            }

            // modelReload
            $(document).on('click', '#modelReload', function () {
                tags = []
                $(".tag").remove();
            });
            $(document).on('hidden.bs.modal', '.serial_modal', function (e) {
                tags = []
                $(".tag").remove();
            });

            $('#product_serial_numberP').select2();

            // ---------------------------------------------------------------------------

        });




	</script>

    @include('sale_pos.partials.keyboard_shortcuts')

    <!-- Call restaurant module if defined -->
    @if (in_array('tables', $enabled_modules) ||
            in_array('modifiers', $enabled_modules) ||
            in_array('service_staff', $enabled_modules))
        <script src="{{ asset('js/restaurant.js?v=' . $asset_v) }}"></script>
    @endif
    <!-- include module js -->
    @if (!empty($pos_module_data))
        @foreach ($pos_module_data as $key => $value)
            @if (!empty($value['module_js_path']))
                @includeIf($value['module_js_path'], ['view_data' => $value['view_data']])
            @endif
        @endforeach
    @endif

<!-- Customer display - #Jalal -->
    <script>
    // Function to collect form data and save cart
    function saveCartData() {
        if (!isCustomerDisplayOpen) {
            // console.log("Customer display is not open. Data will not be sent.");
            return; // Exit if the display is not open
        }

        // Serialize the form data into an array
        const formDataArray = $('#add_pos_sell_form').serializeArray();
        // Check if the form data contains products
        const hasProducts = formDataArray.some(item => item.name.startsWith('products['));

        if (!hasProducts) {
            // console.warn('No products in the form data. Data will not be sent.');
            // Call the delete route to clear the server-side JSON file
            $.ajax({
                type: 'POST', // Use the appropriate HTTP method (DELETE)
                url: "/customer-display/delete-cart-data", // Replace with your actual delete route
                data: {
                    _method: 'DELETE'
                }, // Simulate a DELETE request
                success: function(response) {
                    // console.log('Cart data deleted successfully:', response);
                }
                , error: function(error) {
                    // console.error('Error deleting cart data:', error);
                }
            });

            return; // Exit the function after deleting the cart data
        }
        // Convert serialized array into a JSON object
        const formData = {};
        formDataArray.forEach(item => {
            // Handle nested keys in form data
            const keys = item.name.match(/[^[\]]+/g); // Extract keys from nested names like products[1][unit_price]
            if (keys.length > 1) {
                let current = formData;
                keys.forEach((key, index) => {
                    if (index === keys.length - 1) {
                        current[key] = item.value;
                    } else {
                        current[key] = current[key] || {};
                        current = current[key];
                    }
                });
            } else {
                formData[item.name] = item.value;
            }
        });

        // Convert the form object to JSON
        const formDataJson = JSON.stringify(formData);


        // Send JSON data via AJAX
        $.ajax({
            type: 'POST'
            , url: "/customer-display/save", // Adjust the route if necessary
            data: formDataJson
            , contentType: 'application/json'
            , success: function(response) {
                // console.log('Data sent successfully:', response);
            }
            , error: function(error) {
                // console.error('Error sending data:', error);
            }
        });
    }

    // Event listener for the save cart button
    $("#saveCartButton").on("click", function() {
        saveCartData();
    });

</script>
@endsection
