@extends('layouts.app')

@section('title', "Add Service")
@section('content')


<!-- Content Header (Page header) -->
<section class="content-header">
  <h1>Add Service</h1>
</section>


<!-- Main content -->
<section class="content no-print">

  {!! Form::open(['url' => action([\App\Http\Controllers\WarrantyController::class, 'AddwarrantyServicePost']), 'method' => 'post', 'id' =>
  'add_warranty_service_form' ]) !!}

  <div class="box box-solid">
    <div class="box-body">
      <br><br><br>

      <div class="row">

        <div class="col-sm-8 col-sm-offset-2">

      
          <div class="form-group">
            {!! Form::label('serial_number', __('Enter Product serial number') . ':*') !!}
            {!! Form::text('serial_number', null, ['class' => 'form-control', 'id'=>'search_warrnty', 'placeholder' =>
            __('Search serial'), 'required']); !!}
          </div>
        </div>

      </div>
      <br><br><br>


      <div class="row" id="warrnty_service_box">

      </div>


    </div>
  </div>





  {!! Form::close() !!}
</section>
<!-- /.content -->

@stop



@section('javascript')

<script src="{{ asset('js/pos.js?v=' . $asset_v) }}"></script>
<script src="{{ asset('js/product.js?v=' . $asset_v) }}"></script>
<script src="{{ asset('js/purchase.js?v=' . $asset_v) }}"></script>
<script src="{{ asset('js/opening_stock.js?v=' . $asset_v) }}"></script>
{{-- <script src="{{ asset('js/restaurant.js?v=' . $asset_v) }}"></script> --}}
<!-- Call restaurant module if defined -->

<script type="text/javascript">


  $(document).ready(function () {

    $(document).on('click', '#warranty_recived, #warranty_replace', function (e) {
      e.preventDefault(); // Prevent the form from submitting normally
      var form = $(this).closest('form'); // Get the closest form element
      var url = form.attr('action'); // Get the form action URL
      $.ajax({
          type: 'POST',
          url: url,
          data: form.serialize(), // Serialize the form data
          success: function (response) {

            // console.log(response);

            // Handle the successful response here
            var printContents = document.createElement('div');
            // Set the innerHTML of the div to the response data
            printContents.innerHTML = response.html_content;
            // // Append the div to the body
            document.body.appendChild(printContents);
            // // Print the contents of the div
            window.print();
            // // Remove the div from the body
            document.body.removeChild(printContents);

            
          },
          error: function (xhr, status, error) {
              // Handle the error here
              console.error(error);
          }
      });
    });






    $(document).on('click', '.servicetype', function() {
      
        if (this.value == 'replacement') {
            $('div.replacement').show();
            $('div.service').hide();
        } else if (this.value == 'service') {
            $('div.replacement').hide();
            $('div.service').show();
        }

    });











    $('#status').change(function () {
      if ($(this).val() == 'final') {
        $('#payment_rows_div').removeClass('hide');
      } else {
        $('#payment_rows_div').addClass('hide');
      }
    });
    $('.paid_on').datetimepicker({
      format: moment_date_format + ' ' + moment_time_format,
      ignoreReadonly: true,
    });

    $('#shipping_documents').fileinput({
      showUpload: false,
      showPreview: false,
      browseLabel: LANG.file_browse_label,
      removeLabel: LANG.remove,
    });

    $(document).on('change', '#prefer_payment_method', function (e) {
      var default_accounts = $('select#select_location_id').length ?
        $('select#select_location_id')
        .find(':selected')
        .data('default_payment_accounts') : $('#location_id').data('default_payment_accounts');
      var payment_type = $(this).val();
      if (payment_type) {
        var default_account = default_accounts && default_accounts[payment_type]['account'] ?
          default_accounts[payment_type]['account'] : '';
        var account_dropdown = $('select#prefer_payment_account');
        if (account_dropdown.length && default_accounts) {
          account_dropdown.val(default_account);
          account_dropdown.change();
        }
      }
    });

    function setPreferredPaymentMethodDropdown() {
      var payment_settings = $('#location_id').data('default_payment_accounts');
      payment_settings = payment_settings ? payment_settings : [];
      enabled_payment_types = [];
      for (var key in payment_settings) {
        if (payment_settings[key] && payment_settings[key]['is_enabled']) {
          enabled_payment_types.push(key);
        }
      }
      if (enabled_payment_types.length) {
        $("#prefer_payment_method > option").each(function () {
          if (enabled_payment_types.indexOf($(this).val()) != -1) {
            $(this).removeClass('hide');
          } else {
            $(this).addClass('hide');
          }
        });
      }
    }

    setPreferredPaymentMethodDropdown();

    $('#is_export').on('change', function () {
      if ($(this).is(':checked')) {
        $('div.export_div').show();
      } else {
        $('div.export_div').hide();
      }
    });

  });


  window.addEventListener('afterprint', function() {
			location.reload();
		});
</script>
@endsection