<?php $__env->startSection('title', __('Inventory Turnover Report')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header -->
<section class="content-header no-print">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">
        <?php echo e(__('Inventory Turnover Report'), false); ?>

        <small class="text-muted"><?php echo app('translator')->get('Stock Rotation Analysis, Movement Classification & Optimal Stock Recommendations'); ?></small>
    </h1>
</section>

<!-- Main content -->
<section class="content no-print">

    <!-- Enhanced Filters Section -->
    <div class="row">
        <div class="col-md-12">
            <?php $__env->startComponent('components.filters', [
            'title' => __('Filters'),
            'class' => 'box-primary'
            ]); ?>
            <div class="col-md-3">
                <div class="form-group">
                    <?php echo Form::label('it_date_range', __('Date Range:')); ?>

                    <?php echo Form::text('it_date_range', null, ['placeholder' => __('Select Date Range'), 'class' =>
                    'form-control', 'id' => 'it_date_range', 'readonly']); ?>

                </div>
            </div>
            <div class="col-md-2">
                <div class="form-group">
                    <?php echo Form::label('it_location_id', __('Location:')); ?>

                    <?php echo Form::select('it_location_id', $business_locations, null, ['class' => 'form-control select2',
                    'style' => 'width:100%',
                    'placeholder' => __('All Locations'), 'id' => 'it_location_id']); ?>

                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <?php echo Form::label('it_category_id', __('Category:')); ?>

                    <?php echo Form::select('it_category_id', $categories, null, ['class' => 'form-control select2',
                    'style' => 'width:100%',
                    'placeholder' => __('All Categories'), 'id' => 'it_category_id']); ?>

                </div>
            </div>
            <div class="col-md-2">
                <div class="form-group">
                    <?php echo Form::label('it_supplier_id', __('Supplier:')); ?>

                    <?php echo Form::select('it_supplier_id', $suppliers, null, ['class' => 'form-control select2',
                    'style' => 'width:100%',
                    'placeholder' => __('All Suppliers'), 'id' => 'it_supplier_id']); ?>

                </div>
            </div>
            <div class="col-md-2">
                <div class="form-group">
                    <label>&nbsp;</label><br>
                    <button type="button" class="btn btn-primary" id="it_filter_btn">
                        <i class="fa fa-filter"></i> <?php echo app('translator')->get('Filter'); ?>
                    </button>
                </div>
            </div>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="row">
        <div class="col-lg-3 col-md-6 col-sm-12">
            <div class="info-box">
                <span class="info-box-icon bg-blue"><i class="fa fa-cubes"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Total Products</span>
                    <span class="info-box-number" id="it_total_products">0</span>
                    <div class="progress">
                        <div class="progress-bar bg-blue" style="width: 100%"></div>
                    </div>
                    <span class="progress-description" id="it_products_sold">0 products sold</span>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-12">
            <div class="info-box">
                <span class="info-box-icon bg-green"><i class="fa fa-refresh"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Avg Turnover Ratio</span>
                    <span class="info-box-number" id="it_avg_turnover">0</span>
                    <div class="progress">
                        <div class="progress-bar bg-green" style="width: 100%"></div>
                    </div>
                    <span class="progress-description" id="it_daily_velocity">0 units/day</span>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-12">
            <div class="info-box">
                <span class="info-box-icon bg-yellow"><i class="fa fa-dollar"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Stock Value</span>
                    <span class="info-box-number" id="it_stock_value">$0</span>
                    <div class="progress">
                        <div class="progress-bar bg-yellow" style="width: 100%"></div>
                    </div>
                    <span class="progress-description" id="it_stock_qty">0 units</span>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-12">
            <div class="info-box">
                <span class="info-box-icon bg-red"><i class="fa fa-exclamation-triangle"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Stock Health</span>
                    <span class="info-box-number" id="it_stock_health">0%</span>
                    <div class="progress">
                        <div class="progress-bar bg-red" id="it_health_bar" style="width: 0%"></div>
                    </div>
                    <span class="progress-description" id="it_dead_stock">0 dead stock items</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Stock Movement Classification -->
    <div class="row">
        <div class="col-md-8">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-pie-chart"></i> Stock Movement Classification</h3>
                    <div class="box-tools pull-right">
                        <button type="button" class="btn btn-sm btn-default" id="movement_chart_toggle">
                            <i class="fa fa-bar-chart"></i> Bar Chart
                        </button>
                    </div>
                </div>
                <div class="box-body">
                    <canvas id="movementClassificationChart" height="400"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="box box-info">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-clock-o"></i> Inventory Aging</h3>
                </div>
                <div class="box-body">
                    <canvas id="inventoryAgingChart" height="400"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Turnover Analysis -->
    <div class="row">
        <div class="col-md-6">
            <div class="box box-success">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-line-chart"></i> Category Movement Analysis</h3>
                    <div class="box-tools pull-right">
                        <button type="button" class="btn btn-sm btn-default" id="category_chart_toggle">
                            <i class="fa fa-pie-chart"></i> Pie Chart
                        </button>
                    </div>
                </div>
                <div class="box-body">
                    <canvas id="categoryMovementChart" height="300"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="box box-warning">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-exclamation"></i> Risk Analysis</h3>
                </div>
                <div class="box-body">
                    <canvas id="riskAnalysisChart" height="300"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Stock Recommendations -->
    <div class="row">
        <div class="col-md-12">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-lightbulb-o"></i> Stock Level Recommendations</h3>
                    <div class="box-tools pull-right">
                        <div class="form-group" style="margin-bottom: 0;">
                            <select id="recommendation_filter" class="form-control input-sm" style="width: 150px;">
                                <option value="">All Actions</option>
                                <option value="REORDER NOW">Reorder Now</option>
                                <option value="REDUCE STOCK">Reduce Stock</option>
                                <option value="LIQUIDATE">Liquidate</option>
                                <option value="MAINTAIN">Maintain</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="info-box bg-yellow">
                                <span class="info-box-icon"><i class="fa fa-shopping-cart"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Reorder Now</span>
                                    <span class="info-box-number" id="reorder_count">0</span>
                                    <div class="progress">
                                        <div class="progress-bar" style="width: 100%"></div>
                                    </div>
                                    <span class="progress-description" id="reorder_value">$0 value</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box bg-red">
                                <span class="info-box-icon"><i class="fa fa-arrow-down"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Reduce Stock</span>
                                    <span class="info-box-number" id="reduce_count">0</span>
                                    <div class="progress">
                                        <div class="progress-bar" style="width: 100%"></div>
                                    </div>
                                    <span class="progress-description" id="reduce_savings">$0 potential savings</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box bg-gray">
                                <span class="info-box-icon"><i class="fa fa-times"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Liquidate</span>
                                    <span class="info-box-number" id="liquidate_count">0</span>
                                    <div class="progress">
                                        <div class="progress-bar" style="width: 100%"></div>
                                    </div>
                                    <span class="progress-description" id="liquidate_value">$0 value</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="recommendations_table">
                            <thead>
                                <tr>
                                    <th>Product</th>
                                    <th>Category</th>
                                    <th>Current Stock</th>
                                    <th>Velocity</th>
                                    <th>Turnover Ratio</th>
                                    <th>Action</th>
                                    <th>Recommended Qty</th>
                                    <th>Impact</th>
                                    <th>Reason</th>
                                </tr>
                            </thead>
                            <tbody id="recommendations_tbody">
                                <!-- Recommendations will be populated here -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Top Performers vs Worst Performers -->
    <div class="row">
        <div class="col-md-6">
            <div class="box box-success">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-star"></i> Top Performers (Fast Moving)</h3>
                </div>
                <div class="box-body">
                    <div class="table-responsive">
                        <table class="table table-condensed">
                            <thead>
                                <tr>
                                    <th>Product</th>
                                    <th>Turnover</th>
                                    <th>Velocity</th>
                                    <th>Stock</th>
                                </tr>
                            </thead>
                            <tbody id="top_performers_tbody">
                                <!-- Top performers will be populated here -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="box box-danger">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-warning"></i> Worst Performers (Dead Stock)</h3>
                </div>
                <div class="box-body">
                    <div class="table-responsive">
                        <table class="table table-condensed">
                            <thead>
                                <tr>
                                    <th>Product</th>
                                    <th>Stock Value</th>
                                    <th>Days in Stock</th>
                                    <th>Last Sale</th>
                                </tr>
                            </thead>
                            <tbody id="worst_performers_tbody">
                                <!-- Worst performers will be populated here -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

</section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<!-- Chart.js Library -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    $(document).ready(function() {
        // Initialize date picker
        $('#it_date_range').daterangepicker({
            startDate: moment().subtract(6, 'months'),
            endDate: moment(),
            ranges: {
                'Last 3 Months': [moment().subtract(3, 'months'), moment()],
                'Last 6 Months': [moment().subtract(6, 'months'), moment()],
                'Last Year': [moment().subtract(1, 'year'), moment()],
                'This Year': [moment().startOf('year'), moment().endOf('year')]
            },
            locale: {
                format: 'YYYY-MM-DD'
            }
        });

        // Initialize Select2
        $('.select2').select2();

        // Chart variables
        let movementClassificationChart, inventoryAgingChart, categoryMovementChart, riskAnalysisChart;

        // Load analytics data
        function loadAnalytics() {
            const dateRange = $('#it_date_range').val().split(' - ');
            const startDate = dateRange[0];
            const endDate = dateRange[1];
            const locationId = $('#it_location_id').val() || 'all';
            const categoryId = $('#it_category_id').val() || 'all';
            const supplierId = $('#it_supplier_id').val() || 'all';

            $.ajax({
                url: '<?php echo e(route("advancedreports.inventory-turnover.analytics"), false); ?>',
                type: 'GET',
                data: {
                    start_date: startDate,
                    end_date: endDate,
                    location_id: locationId,
                    category_id: categoryId,
                    supplier_id: supplierId
                },
                success: function(data) {
                    updateSummaryCards(data.summary_cards || {});
                    updateMovementClassification(data.movement_classification || {});
                    updateInventoryAging(data.inventory_aging || {});
                    updateStockRecommendations(data.stock_recommendations || {});
                    updatePerformanceTables(data.movement_classification || {});
                },
                error: function(xhr, status, error) {
                    console.error('Error loading analytics:', error);
                }
            });
        }

        // Update summary cards
        function updateSummaryCards(data) {
            $('#it_total_products').text(data.total_products || 0);
            $('#it_products_sold').text((data.products_sold || 0) + ' products sold');
            $('#it_avg_turnover').text(data.avg_turnover_ratio || 0);
            $('#it_daily_velocity').text((data.avg_daily_velocity || 0) + ' units/day');
            $('#it_stock_value').text(data.formatted_stock_value || '$0');
            $('#it_stock_qty').text((data.total_stock_qty || 0) + ' units');
            $('#it_stock_health').text((data.stock_health_percentage || 0) + '%');
            $('#it_dead_stock').text((data.dead_stock_count || 0) + ' dead stock items');
            
            // Update health bar
            const healthPercentage = data.stock_health_percentage || 0;
            $('#it_health_bar').css('width', healthPercentage + '%');
            
            // Update health bar color based on percentage
            if (healthPercentage >= 70) {
                $('#it_health_bar').removeClass('bg-red bg-yellow').addClass('bg-green');
            } else if (healthPercentage >= 40) {
                $('#it_health_bar').removeClass('bg-red bg-green').addClass('bg-yellow');
            } else {
                $('#it_health_bar').removeClass('bg-green bg-yellow').addClass('bg-red');
            }
        }

        // Update movement classification
        function updateMovementClassification(data) {
            // Movement Classification Chart
            const classificationData = Array.isArray(data.classifications) ? data.classifications : [];
            const labels = classificationData.map(c => c.classification);
            const counts = classificationData.map(c => c.count);
            const colors = ['#28a745', '#ffc107', '#fd7e14', '#dc3545'];

            if (movementClassificationChart) movementClassificationChart.destroy();
            
            const ctx1 = document.getElementById('movementClassificationChart').getContext('2d');
            movementClassificationChart = new Chart(ctx1, {
                type: 'doughnut',
                data: {
                    labels: labels,
                    datasets: [{
                        data: counts,
                        backgroundColor: colors.slice(0, labels.length),
                        borderWidth: 2,
                        borderColor: '#ffffff'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'bottom'
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    const classification = classificationData[context.dataIndex];
                                    return `${context.label}: ${context.parsed} products ($${Math.round(classification.total_stock_value || 0).toLocaleString()})`;
                                }
                            }
                        }
                    }
                }
            });

            // Category Movement Chart
            const categoryData = Array.isArray(data.category_movement) ? data.category_movement : [];
            const categoryLabels = categoryData.map(c => c.category);
            const fastMovingPercentages = categoryData.map(c => c.fast_moving_percentage);

            if (categoryMovementChart) categoryMovementChart.destroy();
            const categoryCtx = document.getElementById('categoryMovementChart').getContext('2d');
            categoryMovementChart = new Chart(categoryCtx, {
                type: 'bar',
                data: {
                    labels: categoryLabels,
                    datasets: [{
                        label: 'Fast Moving %',
                        data: fastMovingPercentages,
                        backgroundColor: '#28a745',
                        borderColor: '#1e7e34',
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true,
                            max: 100,
                            ticks: {
                                callback: function(value) {
                                    return value + '%';
                                }
                            }
                        }
                    }
                }
            });
        }

        // Update inventory aging
        function updateInventoryAging(data) {
            const agingData = Array.isArray(data.aging_buckets) ? data.aging_buckets : [];
            const agingLabels = agingData.map(a => a.bucket);
            const agingCounts = agingData.map(a => a.count);
            const agingColors = ['#28a745', '#6f42c1', '#ffc107', '#fd7e14', '#dc3545', '#6c757d'];

            if (inventoryAgingChart) inventoryAgingChart.destroy();
            const agingCtx = document.getElementById('inventoryAgingChart').getContext('2d');
            inventoryAgingChart = new Chart(agingCtx, {
                type: 'doughnut',
                data: {
                    labels: agingLabels,
                    datasets: [{
                        data: agingCounts,
                        backgroundColor: agingColors.slice(0, agingLabels.length),
                        borderWidth: 2,
                        borderColor: '#ffffff'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'bottom'
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    const bucket = agingData[context.dataIndex];
                                    return `${context.label}: ${context.parsed} items ($${Math.round(bucket.total_stock_value || 0).toLocaleString()})`;
                                }
                            }
                        }
                    }
                }
            });

            // Risk Analysis Chart
            const riskData = Array.isArray(data.risk_analysis) ? data.risk_analysis : [];
            const riskLabels = riskData.map(r => r.risk_level);
            const riskPercentages = riskData.map(r => r.percentage);
            const riskColors = ['#28a745', '#ffc107', '#dc3545', '#6c757d'];

            if (riskAnalysisChart) riskAnalysisChart.destroy();
            const riskCtx = document.getElementById('riskAnalysisChart').getContext('2d');
            riskAnalysisChart = new Chart(riskCtx, {
                type: 'bar',
                data: {
                    labels: riskLabels,
                    datasets: [{
                        data: riskPercentages,
                        backgroundColor: riskColors.slice(0, riskLabels.length),
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: { display: false }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            max: 100,
                            ticks: {
                                callback: function(value) {
                                    return value + '%';
                                }
                            }
                        }
                    }
                }
            });
        }

        // Update stock recommendations
        function updateStockRecommendations(data) {
            const actionSummary = Array.isArray(data.action_summary) ? data.action_summary : [];
            
            // Update action summary cards
            const reorderAction = actionSummary.find(a => a.action === 'REORDER NOW') || {};
            const reduceAction = actionSummary.find(a => a.action === 'REDUCE STOCK') || {};
            const liquidateAction = actionSummary.find(a => a.action === 'LIQUIDATE') || {};
            
            $('#reorder_count').text(reorderAction.count || 0);
            $('#reorder_value').text('$' + Math.round(Math.abs(reorderAction.potential_impact || 0)).toLocaleString() + ' risk');
            
            $('#reduce_count').text(reduceAction.count || 0);
            $('#reduce_savings').text('$' + Math.round(reduceAction.potential_impact || 0).toLocaleString() + ' potential savings');
            
            $('#liquidate_count').text(liquidateAction.count || 0);
            $('#liquidate_value').text('$' + Math.round(liquidateAction.total_stock_value || 0).toLocaleString() + ' value');

            // Update recommendations table
            updateRecommendationsTable(data.recommendations || []);
        }

        function updateRecommendationsTable(recommendations) {
            let html = '';
            // Ensure recommendations is an array
            const recArray = Array.isArray(recommendations) ? recommendations : [];
            recArray.forEach((rec, index) => {
                const actionBadge = getActionBadge(rec.action, rec.priority);
                const impact = rec.potential_savings >= 0 ? 
                    '+$' + rec.potential_savings.toLocaleString() : 
                    '-$' + Math.abs(rec.potential_savings).toLocaleString();
                
                html += `
                    <tr>
                        <td>
                            <strong>${rec.product_name}</strong><br>
                            <small class="text-muted">${rec.product_sku}</small>
                        </td>
                        <td>${rec.category_name}</td>
                        <td>${rec.current_stock}</td>
                        <td>${rec.velocity.toFixed(2)}/day</td>
                        <td>${rec.turnover_ratio.toFixed(2)}</td>
                        <td>${actionBadge}</td>
                        <td>${rec.recommended_qty}</td>
                        <td style="color: ${rec.potential_savings >= 0 ? 'green' : 'red'}">${impact}</td>
                        <td><small>${rec.reason}</small></td>
                    </tr>
                `;
            });
            $('#recommendations_tbody').html(html);
        }

        function getActionBadge(action, priority) {
            let colorClass = 'bg-gray';
            if (action === 'REORDER NOW') colorClass = 'bg-red';
            else if (action === 'REDUCE STOCK') colorClass = 'bg-yellow';
            else if (action === 'LIQUIDATE') colorClass = 'bg-gray';
            else if (action === 'MAINTAIN') colorClass = 'bg-green';
            
            return `<span class="badge ${colorClass}">${action}</span>`;
        }

        // Update performance tables
        function updatePerformanceTables(data) {
            // Top performers - ensure it's an array
            let topPerformers = [];
            if (data && data.top_performers && Array.isArray(data.top_performers)) {
                topPerformers = data.top_performers;
            }
            
            let topHtml = '';
            if (topPerformers.length > 0) {
                topPerformers.slice(0, 10).forEach((product, index) => {
                    // Ensure product object has required properties
                    if (product && product.product_name) {
                        topHtml += `
                            <tr>
                                <td>
                                    <strong>${product.product_name || 'N/A'}</strong><br>
                                    <small class="text-muted">${product.product_sku || 'N/A'}</small>
                                </td>
                                <td><span class="badge bg-green">${product.turnover_ratio || 0}</span></td>
                                <td>${(product.velocity || 0).toFixed(2)}/day</td>
                                <td>${product.current_stock || 0}</td>
                            </tr>
                        `;
                    }
                });
            } else {
                topHtml = '<tr><td colspan="4" class="text-center">No fast-moving products found</td></tr>';
            }
            $('#top_performers_tbody').html(topHtml);

            // Worst performers - ensure it's an array
            let worstPerformers = [];
            if (data && data.worst_performers && Array.isArray(data.worst_performers)) {
                worstPerformers = data.worst_performers;
            }
            
            let worstHtml = '';
            if (worstPerformers.length > 0) {
                worstPerformers.slice(0, 10).forEach((product, index) => {
                    // Ensure product object has required properties
                    if (product && product.product_name) {
                        const lastSale = product.last_sale_date ? new Date(product.last_sale_date).toLocaleDateString() : 'Never';
                        worstHtml += `
                            <tr>
                                <td>
                                    <strong>${product.product_name || 'N/A'}</strong><br>
                                    <small class="text-muted">${product.product_sku || 'N/A'}</small>
                                </td>
                                <td>$${Math.round(product.stock_value || 0).toLocaleString()}</td>
                                <td>${Math.round(product.days_inventory_outstanding || 0)} days</td>
                                <td><small>${lastSale}</small></td>
                            </tr>
                        `;
                    }
                });
            } else {
                worstHtml = '<tr><td colspan="4" class="text-center">No dead stock found</td></tr>';
            }
            $('#worst_performers_tbody').html(worstHtml);
        }

        // Chart toggle functions
        $('#movement_chart_toggle').click(function() {
            if (movementClassificationChart.config.type === 'doughnut') {
                movementClassificationChart.config.type = 'bar';
                movementClassificationChart.options.plugins.legend.position = 'top';
                $(this).html('<i class="fa fa-pie-chart"></i> Pie Chart');
            } else {
                movementClassificationChart.config.type = 'doughnut';
                movementClassificationChart.options.plugins.legend.position = 'bottom';
                $(this).html('<i class="fa fa-bar-chart"></i> Bar Chart');
            }
            movementClassificationChart.update();
        });

        $('#category_chart_toggle').click(function() {
            if (categoryMovementChart.config.type === 'bar') {
                categoryMovementChart.config.type = 'pie';
                $(this).html('<i class="fa fa-bar-chart"></i> Bar Chart');
            } else {
                categoryMovementChart.config.type = 'bar';
                $(this).html('<i class="fa fa-pie-chart"></i> Pie Chart');
            }
            categoryMovementChart.update();
        });

        // Event handlers
        $('#it_filter_btn').click(function() {
            loadAnalytics();
        });

        // Recommendation filter
        $('#recommendation_filter').change(function() {
            const selectedAction = $(this).val();
            if (selectedAction) {
                $('#recommendations_table tbody tr').hide();
                $('#recommendations_table tbody tr').each(function() {
                    const actionText = $(this).find('td:nth-child(6)').text().trim();
                    if (actionText.includes(selectedAction)) {
                        $(this).show();
                    }
                });
            } else {
                $('#recommendations_table tbody tr').show();
            }
        });

        // Load initial data
        loadAnalytics();
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('advancedreports::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/procharmate/public_html/serial.procharmate.com/Modules/AdvancedReports/Resources/views/inventory-turnover/index.blade.php ENDPATH**/ ?>