<?php $__env->startSection('title', __('mosque::mosque.menu_tenancy') . ' | ' . __('mosque::mosque.tenancy_dashboard')); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black"><?php echo app('translator')->get('mosque::mosque.menu_tenancy'); ?></h1>
</section>

<style>
    .tenancy-dashboard-card {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 16px;
        padding: 24px;
        color: white;
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.25);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
    }
    .tenancy-dashboard-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 25px rgba(102, 126, 234, 0.35);
    }
    .td-card-icon {
        width: 56px;
        height: 56px;
        border-radius: 14px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        margin-bottom: 16px;
        background: rgba(255, 255, 255, 0.2);
    }
    .td-card-title {
        font-size: 14px;
        font-weight: 600;
        opacity: 0.9;
        margin-bottom: 4px;
        text-transform: uppercase;
        letter-spacing: 1px;
    }
    .td-card-value {
        font-size: 36px;
        font-weight: 800;
        line-height: 1.1;
    }
    .td-card-label {
        font-size: 13px;
        opacity: 0.85;
        margin-top: 4px;
    }
    
    .tenancy-stat-grid {
        background: white;
        border-radius: 16px;
        padding: 20px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
        margin-bottom: 20px;
    }
    .ts-card {
        background: #f8f9fa;
        border-radius: 12px;
        padding: 20px;
        text-align: center;
        transition: all 0.3s ease;
        border: 1px solid #e9ecef;
    }
    .ts-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 16px rgba(0, 0, 0, 0.12);
    }
    .ts-card-available { background: #ecfdf5; border-color: #10b981; }
    .ts-card-occupied { background: #fef2f2; border-color: #ef4444; }
    .ts-card-leaving { background: #fffbeb; border-color: #f59e0b; }
    .ts-card-maintenance { background: #f1f5f9; border-color: #6b7280; }
    
    .ts-card-icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
        margin: 0 auto 12px;
    }
    .ts-card-available .ts-card-icon { background: #10b981; color: white; }
    .ts-card-occupied .ts-card-icon { background: #ef4444; color: white; }
    .ts-card-leaving .ts-card-icon { background: #f59e0b; color: white; }
    .ts-card-maintenance .ts-card-icon { background: #6b7280; color: white; }
    
    .ts-card-value {
        font-size: 32px;
        font-weight: 800;
        margin-bottom: 4px;
    }
    .ts-card-available .ts-card-value { color: #059669; }
    .ts-card-occupied .ts-card-value { color: #dc2626; }
    .ts-card-leaving .ts-card-value { color: #d97706; }
    .ts-card-maintenance .ts-card-value { color: #475569; }
    
    .ts-card-label {
        font-size: 13px;
        color: #6b7280;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
</style>

<section class="content">
    <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
        <?php echo $__env->make('mosque::tenancy.partials.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div style="margin-top:20px;">
            <?php if(!empty($missing_tables)): ?>
                <div class="alert alert-danger" style="border-radius:10px;"><?php echo app('translator')->get('mosque::mosque.tenancy_missing_tables'); ?></div>
            <?php elseif(!empty($tenancy_disabled)): ?>
                <div class="alert alert-warning" style="border-radius:10px;"><?php echo app('translator')->get('mosque::mosque.tenancy_disabled_msg'); ?></div>
            <?php else: ?>
                <!-- Top Stats Cards -->
                <div class="row" style="margin-bottom:25px;">
                    <div class="col-sm-6">
                        <div class="tenancy-dashboard-card">
                            <div class="td-card-icon"><i class="fa fa-building"></i></div>
                            <div class="td-card-title"><?php echo app('translator')->get('mosque::mosque.tenancy_buildings'); ?></div>
                            <div class="td-card-value"><?php echo e($stats['buildings'] ?? 0, false); ?></div>
                            <div class="td-card-label">Total buildings</div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="tenancy-dashboard-card" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                            <div class="td-card-icon"><i class="fa fa-layer-group"></i></div>
                            <div class="td-card-title"><?php echo app('translator')->get('mosque::mosque.tenancy_floors'); ?></div>
                            <div class="td-card-value"><?php echo e($stats['floors'] ?? 0, false); ?></div>
                            <div class="td-card-label">Total floors</div>
                        </div>
                    </div>
                </div>

                <!-- Stats Grid -->
                <div class="tenancy-stat-grid">
                    <div style="font-size:16px;font-weight:700;color:#0b1020;margin-bottom:20px;padding-bottom:10px;border-bottom:2px solid #e9ecef;">
                        <i class="fa fa-bed" style="margin-right:10px;"></i> <?php echo app('translator')->get('mosque::mosque.tenancy_seats_total'); ?>
                    </div>
                    <div class="row">
                        <div class="col-sm-3">
                            <div class="ts-card ts-card-available">
                                <div class="ts-card-icon"><i class="fa fa-check-circle"></i></div>
                                <div class="ts-card-value"><?php echo e($stats['seats_available'] ?? 0, false); ?></div>
                                <div class="ts-card-label"><?php echo app('translator')->get('mosque::mosque.tenancy_seats_available'); ?></div>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="ts-card ts-card-occupied">
                                <div class="ts-card-icon"><i class="fa fa-user"></i></div>
                                <div class="ts-card-value"><?php echo e($stats['seats_occupied'] ?? 0, false); ?></div>
                                <div class="ts-card-label"><?php echo app('translator')->get('mosque::mosque.tenancy_seats_occupied'); ?></div>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="ts-card ts-card-leaving">
                                <div class="ts-card-icon"><i class="fa fa-clock"></i></div>
                                <div class="ts-card-value"><?php echo e($stats['seats_leaving_soon'] ?? 0, false); ?></div>
                                <div class="ts-card-label"><?php echo app('translator')->get('mosque::mosque.tenancy_seats_leaving_soon'); ?></div>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="ts-card ts-card-maintenance">
                                <div class="ts-card-icon"><i class="fa fa-wrench"></i></div>
                                <div class="ts-card-value"><?php echo e($stats['seats_maintenance'] ?? 0, false); ?></div>
                                <div class="ts-card-label"><?php echo app('translator')->get('mosque::mosque.tenancy_seats_maintenance'); ?></div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Secondary Stats -->
                <div class="tenancy-stat-grid">
                    <div style="font-size:16px;font-weight:700;color:#0b1020;margin-bottom:20px;padding-bottom:10px;border-bottom:2px solid #e9ecef;">
                        <i class="fa fa-inbox" style="margin-right:10px;"></i> <?php echo app('translator')->get('mosque::mosque.tenancy_bills'); ?>
                    </div>
                    <div class="row">
                        <div class="col-sm-4">
                            <div class="ts-card ts-card-available" style="border-color:#3498db;background:#f0f9ff;">
                                <div class="ts-card-icon" style="background:#3498db;"><i class="fa fa-inbox"></i></div>
                                <div class="ts-card-value" style="color:#2563eb;"><?php echo e($stats['requests_pending'] ?? 0, false); ?></div>
                                <div class="ts-card-label"><?php echo app('translator')->get('mosque::mosque.tenancy_requests_pending'); ?></div>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="ts-card ts-card-occupied" style="border-color:#e74c3c;background:#fef2f2;">
                                <div class="ts-card-icon" style="background:#e74c3c;"><i class="fa fa-file-invoice-dollar"></i></div>
                                <div class="ts-card-value" style="color:#dc2626;"><?php echo e($stats['bills_due'] ?? 0, false); ?></div>
                                <div class="ts-card-label"><?php echo app('translator')->get('mosque::mosque.tenancy_bills_due'); ?></div>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="ts-card ts-card-leaving" style="border-color:#8b5cf6;background:#fff7ed;">
                                <div class="ts-card-icon" style="background:#8b5cf6;"><i class="fa fa-exclamation-triangle"></i></div>
                                <div class="ts-card-value" style="color:#7c3aed;"><?php echo e($stats['cases_total'] ?? 0, false); ?></div>
                                <div class="ts-card-label"><?php echo app('translator')->get('mosque::mosque.tenancy_cases'); ?></div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Room Type Stats -->
                <div class="tenancy-stat-grid">
                    <div style="font-size:16px;font-weight:700;color:#0b1020;margin-bottom:20px;padding-bottom:10px;border-bottom:2px solid #e9ecef;">
                        <i class="fa fa-th-large" style="margin-right:10px;"></i> <?php echo app('translator')->get('mosque::mosque.tenancy_rooms_by_type'); ?>
                    </div>
                    <div class="row">
                        <div class="col-sm-4">
                            <div class="ts-card" style="background:#f0fdf4;border-color:#10b981;">
                                <div class="ts-card-icon" style="background:#10b981;color:#fff;"><i class="fa fa-door-open"></i></div>
                                <div class="ts-card-value" style="color:#059669;"><?php echo e($stats['rooms_count'] ?? 0, false); ?></div>
                                <div class="ts-card-label"><?php echo app('translator')->get('mosque::mosque.tenancy_type_room'); ?></div>
                                <div style="font-size:12px;color:#6b7280;margin-top:8px;"><?php echo e($stats['rooms_seats_count'] ?? 0, false); ?> beds</div>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="ts-card" style="background:#fef3c7;border-color:#f59e0b;">
                                <div class="ts-card-icon" style="background:#f59e0b;color:#fff;"><i class="fa fa-building-o"></i></div>
                                <div class="ts-card-value" style="color:#d97706;"><?php echo e($stats['apartments_count'] ?? 0, false); ?></div>
                                <div class="ts-card-label"><?php echo app('translator')->get('mosque::mosque.tenancy_type_apartment'); ?></div>
                                <div style="font-size:12px;color:#6b7280;margin-top:8px;"><?php echo e($stats['apartments_seats_count'] ?? 0, false); ?> beds</div>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="ts-card" style="background:#e0e7ff;border-color:#8b5cf6;">
                                <div class="ts-card-icon" style="background:#8b5cf6;color:#fff;"><i class="fa fa-hospital-o"></i></div>
                                <div class="ts-card-value" style="color:#7c3aed;"><?php echo e($stats['wards_count'] ?? 0, false); ?></div>
                                <div class="ts-card-label"><?php echo app('translator')->get('mosque::mosque.tenancy_type_ward'); ?></div>
                                <div style="font-size:12px;color:#6b7280;margin-top:8px;"><?php echo e($stats['wards_seats_count'] ?? 0, false); ?> beds</div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Due Bills Preview -->
                <?php if(!empty($preview_due) && count($preview_due)): ?>
                    <div class="tenancy-stat-grid" style="background:#fff;border:1px solid #e9ecef;">
                        <div style="font-size:16px;font-weight:700;color:#0b1020;margin-bottom:20px;">
                            <i class="fa fa-calendar" style="margin-right:10px;"></i> <?php echo app('translator')->get('mosque::mosque.tenancy_due_bills_preview'); ?>
                        </div>
                        <div class="table-responsive">
                            <table class="table" style="margin:0;">
                                <thead>
                                    <tr style="background:#f8f9fa;">
                                        <th style="border:none;padding:12px;font-weight:700;color:#0b1020;"><?php echo app('translator')->get('mosque::mosque.tenancy_next_bill_on'); ?></th>
                                        <th style="border:none;padding:12px;font-weight:700;color:#0b1020;"><?php echo app('translator')->get('mosque::mosque.tenancy_tenant'); ?></th>
                                        <th style="border:none;padding:12px;font-weight:700;color:#0b1020;"><?php echo app('translator')->get('mosque::mosque.tenancy_seat'); ?></th>
                                        <th style="border:none;padding:12px;font-weight:700;color:#0b1020;"><?php echo app('translator')->get('mosque::mosque.tenancy_amount'); ?></th>
                                        <th style="border:none;padding:12px;font-weight:700;color:#0b1020;"><?php echo app('translator')->get('mosque::mosque.tenancy_cycle'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $preview_due; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr style="border-bottom:1px solid #e9ecef;">
                                            <td style="padding:12px;"><?php echo e($r->next_bill_on, false); ?></td>
                                            <td style="padding:12px;font-weight:600;"><?php echo e($r->tenant, false); ?></td>
                                            <td style="padding:12px;"><?php echo e($r->seat_label, false); ?></td>
                                            <td style="padding:12px;font-weight:700;color:#10b981;"><span class="display_currency" data-currency_symbol="true" data-orig-value="<?php echo e((float) $r->rent_amount, false); ?>"><?php echo e((float) $r->rent_amount, false); ?></span></td>
                                            <td style="padding:12px;"><span class="label" style="background:#eef2ff;color:#3730a3;padding:4px 8px;border-radius:12px;font-size:11px;font-weight:600;"><?php echo e($r->billing_cycle, false); ?></span></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    <?php echo $__env->renderComponent(); ?>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script>
    $(document).ready(function () {
        if (typeof __currency_convert_recursively === 'function') {
            __currency_convert_recursively($(document));
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('mosque::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/procharmate/public_html/serial.procharmate.com/Modules/Mosque/Providers/../Resources/views/tenancy/dashboard.blade.php ENDPATH**/ ?>