<?php $__env->startSection('title', __('mosque::mosque.mosque') . ' | Donation QR'); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Donation QR Page</h1>
</section>

<section class="content">
<?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
        <div class="row">
            <div class="col-sm-6">
                <p class="text-muted">Scan link for public donation submission (goes to approval queue; no finance entry is created until approved).</p>
                <p><strong>Public URL:</strong> <a href="<?php echo e($donateUrl, false); ?>" target="_blank"><?php echo e($donateUrl, false); ?></a></p>

                <?php
                    $regenCount = (int) ($link->regenerate_count ?? 0);
                ?>
                <form method="post" action="<?php echo e(route('mosque.donations.qr.regenerate'), false); ?>" style="display:inline-block;">
                    <?php echo e(csrf_field(), false); ?>

                    <button type="submit" class="btn btn-danger" <?php echo e($regenCount >= 1 ? 'disabled' : '', false); ?>><i class="fa fa-refresh"></i> Regenerate Link</button>
                </form>
                <?php if($regenCount >= 1): ?>
                    <p class="text-muted" style="margin-top:6px;margin-bottom:0;">Regenerate is allowed only once for security.</p>
                <?php endif; ?>
            </div>
            <div class="col-sm-6 text-center">
                <img id="qr_image" src="<?php echo e($qrImageUrl, false); ?>" alt="QR" class="mw-100" style="max-width: 260px;">
                <div class="text-muted" style="margin-top:6px; font-weight:600;"><?php echo e($title, false); ?></div>
                <div style="margin-top:10px;">
                    <a id="download_qr" href="<?php echo e($qrDownloadUrl, false); ?>" class="btn btn-success">
                        <i class="fa fa-download"></i> Download
                    </a>
                </div>
            </div>
        </div>
    <?php echo $__env->renderComponent(); ?>

    <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
        <form method="post" action="<?php echo e(route('mosque.donations.qr.update'), false); ?>">
            <?php echo e(csrf_field(), false); ?>

            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>Title</label>
                        <input type="text" name="title" class="form-control" value="<?php echo e($title, false); ?>">
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>Primary Color</label>
                        <input type="text" name="primary_color" class="form-control" value="<?php echo e($primaryColor, false); ?>" placeholder="#000000">
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="checkbox" style="margin-top:25px;">
                        <label>
                            <input type="checkbox" name="enabled" value="1" <?php echo e(!empty($link) && $link->enabled ? 'checked' : '', false); ?>>
                            Enabled
                        </label>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 text-right">
                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('messages.save'); ?></button>
                </div>
            </div>
        </form>
    <?php echo $__env->renderComponent(); ?>

    <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
        <h4 style="margin-top:0;">QR Donation Requests (Approval)</h4>
        <p class="text-muted">Requests submitted via public QR page stay here until approved. Approved requests create a Donation + Finance income entry.</p>

        <div class="row" style="margin-bottom:10px;">
            <div class="col-sm-4">
                <div class="form-group">
                    <label><?php echo app('translator')->get('report.date_range'); ?></label>
                    <input type="text" id="mqr_date_range" class="form-control" readonly autocomplete="off" placeholder="<?php echo app('translator')->get('lang_v1.select_a_date_range'); ?>">
                    <input type="hidden" id="mqr_start_date" value="<?php echo e(now()->startOfYear()->format('Y-m-d'), false); ?>">
                    <input type="hidden" id="mqr_end_date" value="<?php echo e(now()->endOfYear()->format('Y-m-d'), false); ?>">
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>Status</label>
                    <select id="mqr_status" class="form-control">
                        <option value=""><?php echo app('translator')->get('lang_v1.all'); ?></option>
                        <option value="pending" selected>Pending</option>
                        <option value="approved">Approved</option>
                        <option value="rejected">Rejected</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>Type</label>
                    <select id="mqr_type" class="form-control">
                        <option value=""><?php echo app('translator')->get('lang_v1.all'); ?></option>
                        <option value="zakat">Zakat</option>
                        <option value="sadaqah">Sadaqah</option>
                        <option value="fitrah">Fitrah</option>
                        <option value="general">General</option>
                        <option value="event">Event</option>
                        <option value="waqf">Waqf</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>Channel</label>
                    <select id="mqr_channel" class="form-control">
                        <option value=""><?php echo app('translator')->get('lang_v1.all'); ?></option>
                        <option value="cash">Cash</option>
                        <option value="bank">Bank</option>
                        <option value="card">Card</option>
                        <option value="online">Online</option>
                    </select>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_qr_donation_requests_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Donor</th>
                        <th>Type</th>
                        <th>Channel</th>
                        <th>Amount</th>
                        <th>Transaction</th>
                        <th>Status</th>
                        <th><?php echo app('translator')->get('messages.action'); ?></th>
                    </tr>
                </thead>
            </table>
        </div>
        <div class="text-right text-muted" id="mosque_qr_donation_requests_table_count" style="margin-top:6px;"></div>
    <?php echo $__env->renderComponent(); ?>

    <div class="modal fade" id="mosque_qr_reject_modal" tabindex="-1" role="dialog" aria-labelledby="mosque_qr_reject_modal_label">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="mosque_qr_reject_modal_label">Reject Request</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>Reason <span class="text-danger">*</span></label>
                        <textarea class="form-control" id="mosque_qr_reject_reason" rows="3" placeholder="Write the reason"></textarea>
                        <input type="hidden" id="mosque_qr_reject_id" value="">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" id="mosque_qr_reject_btn">Reject</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo app('translator')->get('messages.close'); ?></button>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">
    $(document).ready(function () {
        function resetQrFiltersToDefault() {
            var s = moment().startOf('year');
            var e = moment().endOf('year');
            $('#mqr_start_date').val(s.format('YYYY-MM-DD'));
            $('#mqr_end_date').val(e.format('YYYY-MM-DD'));
            $('#mqr_status').val('pending');
            $('#mqr_type').val('');
            $('#mqr_channel').val('');
            if ($('#mqr_date_range').length && typeof moment_date_format !== 'undefined') {
                $('#mqr_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
            }
        }

        resetQrFiltersToDefault();

        if (typeof dateRangeSettings !== 'undefined' && $('#mqr_date_range').length) {
            var start = moment($('#mqr_start_date').val(), 'YYYY-MM-DD');
            var end = moment($('#mqr_end_date').val(), 'YYYY-MM-DD');
            $('#mqr_date_range').daterangepicker(
                $.extend({}, dateRangeSettings, { startDate: start, endDate: end }),
                function (s, e) {
                    $('#mqr_start_date').val(s.format('YYYY-MM-DD'));
                    $('#mqr_end_date').val(e.format('YYYY-MM-DD'));
                    $('#mqr_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
                    reqTable.ajax.reload();
                }
            );
            $('#mqr_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
        }

        var reqTable = $('#mosque_qr_donation_requests_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '<?php echo e(route("mosque.donations.qr.requests.data"), false); ?>',
                data: function (d) {
                    d.start_date = $('#mqr_start_date').val();
                    d.end_date = $('#mqr_end_date').val();
                    d.status = $('#mqr_status').val();
                    d.type = $('#mqr_type').val();
                    d.channel = $('#mqr_channel').val();
                }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'created_at', name: 'created_at' },
                { data: 'donor', name: 'donor_name', orderable: false, searchable: true },
                { data: 'type', name: 'type' },
                { data: 'channel', name: 'channel' },
                { data: 'amount', name: 'amount', orderable: false, searchable: false },
                { data: 'transaction', name: 'transaction_ref', orderable: false, searchable: true },
                { data: 'status', name: 'status' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            drawCallback: function () {
                __currency_convert_recursively($('#mosque_qr_donation_requests_table'));
                var info = reqTable ? reqTable.page.info() : null;
                if (info) {
                    $('#mosque_qr_donation_requests_table_count').text('Total rows: ' + info.recordsDisplay);
                }
            }
        });

        reqTable.on('init.dt', function () {
            $('#mosque_qr_donation_requests_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
        });

        $(document).on('change', '#mqr_status, #mqr_type, #mqr_channel', function () {
            reqTable.ajax.reload();
        });

        $(document).on('click', '.mosque_qr_approve', function () {
            var id = $(this).data('id');
            if (!id) return;
            swal({
                title: 'Approve this request?',
                text: 'This will create a Donation entry and a Finance income entry.',
                icon: 'warning',
                buttons: true,
            }).then(function (ok) {
                if (!ok) return;
                $.ajax({
                    method: 'POST',
                    url: '<?php echo e(url("mosque/donations/qr/requests"), false); ?>/' + id + '/approve',
                    data: { _token: '<?php echo e(csrf_token(), false); ?>' },
                    success: function (result) {
                        if (result.success) {
                            toastr.success(result.msg);
                            reqTable.ajax.reload();
                        } else {
                            toastr.error(result.msg || '<?php echo app('translator')->get("messages.something_went_wrong"); ?>');
                        }
                    },
                    error: function () {
                        toastr.error('<?php echo app('translator')->get("messages.something_went_wrong"); ?>');
                    }
                });
            });
        });

        $(document).on('click', '.mosque_qr_reject', function () {
            var id = $(this).data('id');
            $('#mosque_qr_reject_id').val(id || '');
            $('#mosque_qr_reject_reason').val('');
            $('#mosque_qr_reject_modal').modal('show');
        });

        $('#mosque_qr_reject_btn').on('click', function () {
            var id = $('#mosque_qr_reject_id').val();
            var reason = ($('#mosque_qr_reject_reason').val() || '').trim();
            if (!id) return;
            if (reason === '') {
                toastr.error('Reason is required.');
                return;
            }
            $.ajax({
                method: 'POST',
                url: '<?php echo e(url("mosque/donations/qr/requests"), false); ?>/' + id + '/reject',
                data: { _token: '<?php echo e(csrf_token(), false); ?>', reason: reason },
                success: function (result) {
                    if (result.success) {
                        $('#mosque_qr_reject_modal').modal('hide');
                        toastr.success(result.msg);
                        reqTable.ajax.reload();
                    } else {
                        toastr.error(result.msg || '<?php echo app('translator')->get("messages.something_went_wrong"); ?>');
                    }
                },
                error: function () {
                    toastr.error('<?php echo app('translator')->get("messages.something_went_wrong"); ?>');
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('mosque::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/procharmate/public_html/serial.procharmate.com/Modules/Mosque/Providers/../Resources/views/donations/qr.blade.php ENDPATH**/ ?>