<?php $__env->startSection('title', __('Business Analytics Dashboard')); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <h1>Business Analytics Dashboard</h1>
    <p>View data usage across all businesses</p>
</section>

<section class="content">
    <!-- Overview Cards -->
    <div class="row">
        <div class="col-lg-3 col-md-6">
            <div class="small-box bg-aqua">
                <div class="inner">
                    <h3 id="total_businesses">0</h3>
                    <p>Total Businesses</p>
                </div>
                <div class="icon"><i class="fa fa-building"></i></div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="small-box bg-green">
                <div class="inner">
                    <h3 id="actual_db_size">0 GB</h3>
                    <p>Actual DB Size</p>
                </div>
                <div class="icon"><i class="fa fa-database"></i></div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="small-box bg-yellow">
                <div class="inner">
                    <h3 id="total_records">0</h3>
                    <p>Total Records</p>
                </div>
                <div class="icon"><i class="fa fa-table"></i></div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="small-box bg-red">
                <div class="inner">
                    <h3 id="avg_business_size">0 MB</h3>
                    <p>Avg Business Size</p>
                </div>
                <div class="icon"><i class="fa fa-calculator"></i></div>
            </div>
        </div>
    </div>

    <!-- Main Data Table -->
    <div class="row">
        <div class="col-md-12">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        <i class="fa fa-chart-bar"></i> Business Data Analytics
                    </h3>
                    <div class="box-tools pull-right">
                        <button type="button" class="btn btn-success btn-sm" id="export_excel">
                            <i class="fa fa-download"></i> Export Excel
                        </button>
                        <button type="button" class="btn btn-primary btn-sm" id="print_table">
                            <i class="fa fa-print"></i> Print
                        </button>
                        <button type="button" class="btn btn-info btn-sm" id="refresh_data">
                            <i class="fa fa-refresh"></i> Refresh
                        </button>
                    </div>
                </div>
                <div class="box-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="business_analytics_table">
                            <thead>
                                <tr>
                                    <th>Business Name</th>
                                    <th>Created At</th>
                                    <th>Users</th>
                                    <th>Products</th>
                                    <th>Sales</th>
                                    <th>Purchases</th>
                                    <th>Contacts</th>
                                    <th>Locations</th>
                                    <th>Total Records</th>
                                    <th>Size (MB)</th>
                                    <th>Top Tables</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Data will be populated by JavaScript -->
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="overlay" id="loading_overlay" style="display: none;">
                    <i class="fa fa-refresh fa-spin"></i>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
/* Status color classes for table cells */
.status-success {
    background-color: #d4edda !important;
    color: #155724;
}

.status-warning {
    background-color: #fff3cd !important;
    color: #856404;
}

.status-danger {
    background-color: #f8d7da !important;
    color: #721c24;
}

/* Tag styling for top tables */
.table-tag {
    display: inline-block;
    padding: 2px 6px;
    margin: 1px;
    background-color: #f0f0f0;
    border: 1px solid #ddd;
    border-radius: 3px;
    font-size: 11px;
    white-space: nowrap;
}

.table-tag.high-count {
    background-color: #ffebee;
    border-color: #e57373;
    color: #d32f2f;
}

.table-tag.medium-count {
    background-color: #fff3e0;
    border-color: #ffb74d;
    color: #ef6c00;
}

.table-tag.low-count {
    background-color: #e8f5e8;
    border-color: #81c784;
    color: #388e3c;
}

/* Loading overlay */
.overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(255, 255, 255, 0.8);
    z-index: 1000;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 30px;
}

/* Responsive table improvements */
@media (max-width: 768px) {
    .table-responsive {
        font-size: 12px;
    }
    
    .table-tag {
        font-size: 10px;
        padding: 1px 4px;
    }
}
</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script>
$(document).ready(function() {
    let businessAnalyticsTable;
    
    // Initialize DataTable
    initializeDataTable();
    
    // Load initial data
    loadSummaryData();
    loadTableData();
    
    // Event handlers
    $('#refresh_data').click(function() {
        loadSummaryData();
        loadTableData();
    });
    
    $('#export_excel').click(function() {
        exportToExcel();
    });
    
    $('#print_table').click(function() {
        printTable();
    });
    
    function initializeDataTable() {
        businessAnalyticsTable = $('#business_analytics_table').DataTable({
            processing: true,
            ordering: true,
            searching: true,
            paging: true,
            info: true,
            responsive: true,
            pageLength: 25,
            order: [[8, 'desc']], // Order by Total Records descending
            columnDefs: [
                {
                    targets: [2, 3, 4, 5, 6, 7, 8], // Numeric columns
                    className: 'text-right'
                },
                {
                    targets: [9], // Size column
                    className: 'text-right'
                }
            ],
            language: {
                processing: "Loading business analytics...",
                emptyTable: "No business data available",
                zeroRecords: "No matching businesses found"
            }
        });
    }
    
    function loadSummaryData() {
        $.ajax({
            url: '<?php echo e(route("advancedreports.business-analytics.summary"), false); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                $('#total_businesses').text(response.total_businesses);
                $('#actual_db_size').text(response.actual_db_size);
                $('#total_records').text(response.total_records);
                $('#avg_business_size').text(response.avg_business_size);
            },
            error: function(xhr, status, error) {
                console.error('Failed to load summary data:', error);
                toastr.error('Failed to load summary data');
            }
        });
    }
    
    function loadTableData() {
        showLoading(true);
        
        $.ajax({
            url: '<?php echo e(route("advancedreports.business-analytics.data"), false); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                populateTable(response.data);
                showLoading(false);
            },
            error: function(xhr, status, error) {
                console.error('Failed to load table data:', error);
                toastr.error('Failed to load business analytics data');
                showLoading(false);
            }
        });
    }
    
    function populateTable(data) {
        businessAnalyticsTable.clear();
        
        data.forEach(function(row) {
            // Format top tables as tags
            let topTablesHtml = '';
            row.top_tables.forEach(function(table, index) {
                let tagClass = 'table-tag';
                if (table.count > 50000) {
                    tagClass += ' high-count';
                } else if (table.count > 10000) {
                    tagClass += ' medium-count';
                } else {
                    tagClass += ' low-count';
                }
                
                topTablesHtml += `<span class="${tagClass}">${table.name} (${formatNumber(table.count)})</span>`;
                if (index < row.top_tables.length - 1) {
                    topTablesHtml += ' ';
                }
            });
            
            businessAnalyticsTable.row.add([
                row.business_name,
                row.created_at,
                formatNumber(row.users_count),
                formatNumber(row.products_count),
                formatNumber(row.sales_count),
                formatNumber(row.purchase_count),
                formatNumber(row.contacts_count),
                formatNumber(row.locations_count),
                formatNumber(row.total_records),
                row.actual_size_mb,
                topTablesHtml
            ]);
        });
        
        businessAnalyticsTable.draw();
        
        // Apply status colors after drawing
        applyStatusColors(data);
    }
    
    function applyStatusColors(data) {
        data.forEach(function(row, index) {
            const tableRow = businessAnalyticsTable.row(index).node();
            
            // Apply color to Total Records column (index 8)
            $(tableRow).find('td:eq(8)').addClass('status-' + row.records_status);
            
            // Apply color to Size column (index 9)
            $(tableRow).find('td:eq(9)').addClass('status-' + row.size_status);
            
            // Apply color to Top Tables column (index 10) based on number of tables
            if (row.top_tables_status === 'warning') {
                $(tableRow).find('td:eq(10)').addClass('status-warning');
            }
        });
    }
    
    function showLoading(show) {
        if (show) {
            $('#loading_overlay').show();
        } else {
            $('#loading_overlay').hide();
        }
    }
    
    function formatNumber(num) {
        return new Intl.NumberFormat().format(num);
    }
    
    function exportToExcel() {
        showLoading(true);
        
        window.location.href = '<?php echo e(route("advancedreports.business-analytics.export"), false); ?>';
        
        setTimeout(function() {
            showLoading(false);
        }, 3000);
    }
    
    function printTable() {
        // Create a new window for printing
        const printWindow = window.open('', '_blank');
        const printContent = `
            <!DOCTYPE html>
            <html>
            <head>
                <title>Business Analytics Dashboard</title>
                <style>
                    body { font-family: Arial, sans-serif; }
                    table { border-collapse: collapse; width: 100%; }
                    th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
                    th { background-color: #f2f2f2; font-weight: bold; }
                    .status-success { background-color: #d4edda; }
                    .status-warning { background-color: #fff3cd; }
                    .status-danger { background-color: #f8d7da; }
                    .table-tag { 
                        display: inline-block; 
                        padding: 2px 6px; 
                        margin: 1px;
                        background-color: #f0f0f0; 
                        border: 1px solid #ddd; 
                        border-radius: 3px; 
                        font-size: 11px; 
                    }
                    .high-count { background-color: #ffebee; border-color: #e57373; }
                    .medium-count { background-color: #fff3e0; border-color: #ffb74d; }
                    .low-count { background-color: #e8f5e8; border-color: #81c784; }
                    @media print {
                        body { -webkit-print-color-adjust: exact; }
                    }
                </style>
            </head>
            <body>
                <h1>Business Analytics Dashboard</h1>
                <p>Generated on: ${new Date().toLocaleString()}</p>
                ${$('#business_analytics_table')[0].outerHTML}
            </body>
            </html>
        `;
        
        printWindow.document.write(printContent);
        printWindow.document.close();
        printWindow.focus();
        
        setTimeout(() => {
            printWindow.print();
            printWindow.close();
        }, 250);
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/procharmate/public_html/serial.procharmate.com/Modules/AdvancedReports/Resources/views/business-analytics/index.blade.php ENDPATH**/ ?>