<?php $__env->startSection('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.menu_donations')); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black"><?php echo app('translator')->get('mosque::mosque.menu_donations'); ?></h1>
</section>

<section class="content">
    <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
        <div class="row">
            <div class="col-sm-2" style="display:none;">
                <div class="form-group">
                    <label><?php echo app('translator')->get('lang_v1.start_date'); ?></label>
                    <input type="date" id="md_start_date" class="form-control" value="<?php echo e(now()->startOfYear()->format('Y-m-d'), false); ?>">
                </div>
            </div>
            <div class="col-sm-2" style="display:none;">
                <div class="form-group">
                    <label><?php echo app('translator')->get('lang_v1.end_date'); ?></label>
                    <input type="date" id="md_end_date" class="form-control" value="<?php echo e(now()->endOfYear()->format('Y-m-d'), false); ?>">
                </div>
            </div>
            <div class="col-sm-4">
                <div class="form-group">
                    <label><?php echo app('translator')->get('report.date_range'); ?></label>
                    <input type="text" id="md_date_range" class="form-control" readonly autocomplete="off" placeholder="<?php echo app('translator')->get('lang_v1.select_a_date_range'); ?>">
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>Type</label>
                    <select id="md_type" class="form-control">
                        <option value=""><?php echo app('translator')->get('lang_v1.all'); ?></option>
                        <option value="zakat">Zakat</option>
                        <option value="sadaqah">Sadaqah</option>
                        <option value="fitrah">Fitrah</option>
                        <option value="general">General</option>
                        <option value="event">Event</option>
                        <option value="waqf">Waqf</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>Channel</label>
                    <select id="md_channel" class="form-control">
                        <option value=""><?php echo app('translator')->get('lang_v1.all'); ?></option>
                        <option value="cash">Cash</option>
                        <option value="bank">Bank</option>
                        <option value="card">Card</option>
                        <option value="online">Online</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-4 text-right">
                <a href="<?php echo e(route('mosque.donations.qr'), false); ?>" class="btn btn-default">
                    <i class="fa fa-qrcode"></i> Donation QR
                </a>
                <a href="<?php echo e(route('mosque.donations.reports'), false); ?>" class="btn btn-default">
                    <i class="fa fa-bar-chart"></i> <?php echo app('translator')->get('mosque::mosque.menu_donations_reports'); ?>
                </a>
                <a href="<?php echo e(route('mosque.donors'), false); ?>" class="btn btn-default">
                    <i class="fa fa-users"></i> Donors
                </a>
                <button type="button" class="btn btn-primary btn-modal" data-href="<?php echo e(route('mosque.donations.create'), false); ?>" data-container=".mosque_donation_modal">
                    <i class="fa fa-plus"></i> <?php echo app('translator')->get('messages.add'); ?>
                </button>
            </div>
        </div>
    <?php echo $__env->renderComponent(); ?>

    <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
        <style>
            #md_type_totals .md-tt-card { border-radius: 6px; padding: 10px 12px; border: 1px solid rgba(0,0,0,.08); }
            #md_type_totals .md-tt-label { font-weight: 800; font-size: 12px; letter-spacing: .02em; }
            #md_type_totals .md-tt-val { font-weight: 900; font-size: 16px; margin-top: 2px; }
        </style>
        <div class="row" id="md_type_totals">
            <div class="col-sm-2">
                <div class="md-tt-card" style="background:#e8f5e9;">
                    <div class="md-tt-label" style="color:#1b5e20;">Zakat</div>
                    <div class="md-tt-val" style="color:#0b3d14;">
                        <span id="md_total_zakat" class="display_currency" data-currency_symbol="true" data-orig-value="0">0</span>
                    </div>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="md-tt-card" style="background:#e3f2fd;">
                    <div class="md-tt-label" style="color:#0d47a1;">Sadaqah</div>
                    <div class="md-tt-val" style="color:#082f6e;">
                        <span id="md_total_sadaqah" class="display_currency" data-currency_symbol="true" data-orig-value="0">0</span>
                    </div>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="md-tt-card" style="background:#fff3e0;">
                    <div class="md-tt-label" style="color:#e65100;">Fitrah</div>
                    <div class="md-tt-val" style="color:#8a3600;">
                        <span id="md_total_fitrah" class="display_currency" data-currency_symbol="true" data-orig-value="0">0</span>
                    </div>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="md-tt-card" style="background:#ede7f6;">
                    <div class="md-tt-label" style="color:#4527a0;">General</div>
                    <div class="md-tt-val" style="color:#2f1b72;">
                        <span id="md_total_general" class="display_currency" data-currency_symbol="true" data-orig-value="0">0</span>
                    </div>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="md-tt-card" style="background:#fce4ec;">
                    <div class="md-tt-label" style="color:#880e4f;">Event</div>
                    <div class="md-tt-val" style="color:#5a0933;">
                        <span id="md_total_event" class="display_currency" data-currency_symbol="true" data-orig-value="0">0</span>
                    </div>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="md-tt-card" style="background:#e0f2f1;">
                    <div class="md-tt-label" style="color:#004d40;">Waqf</div>
                    <div class="md-tt-val" style="color:#00352c;">
                        <span id="md_total_waqf" class="display_currency" data-currency_symbol="true" data-orig-value="0">0</span>
                    </div>
                </div>
            </div>
        </div>
    <?php echo $__env->renderComponent(); ?>

    <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_donations_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Receipt</th>
                        <th>Contact</th>
                        <th>Type</th>
                        <th>Channel</th>
                        <th>Amount</th>
                        <th><?php echo app('translator')->get('messages.action'); ?></th>
                    </tr>
                </thead>
            </table>
        </div>
    <?php echo $__env->renderComponent(); ?>

    <div class="modal fade mosque_donation_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>

    <div class="modal fade" id="mosque_donation_confirm_delete_modal" tabindex="-1" role="dialog" aria-labelledby="mosque_donation_confirm_delete_modal_label">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="mosque_donation_confirm_delete_modal_label"><?php echo app('translator')->get('messages.delete'); ?></h4>
                </div>
                <div class="modal-body">
                    <p class="text-danger" style="margin-bottom:6px;">Permanent delete: removes this donation and its linked finance entry (only audit logs remain).</p>
                    <p>Type <strong>Confirm</strong> (case-sensitive) to delete.</p>
                    <div class="form-group">
                        <input type="text" class="form-control" id="mosque_donation_confirm_delete_input" placeholder="Confirm" autocomplete="off">
                        <input type="hidden" id="mosque_donation_confirm_delete_url" value="">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" id="mosque_donation_confirm_delete_btn"><?php echo app('translator')->get('messages.delete'); ?></button>
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo app('translator')->get('messages.close'); ?></button>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">
    $(document).ready(function () {
        function resetDonationFiltersToDefault() {
            var s = moment().startOf('year');
            var e = moment().endOf('year');
            $('#md_start_date').val(s.format('YYYY-MM-DD'));
            $('#md_end_date').val(e.format('YYYY-MM-DD'));
            if ($('#md_date_range').length && typeof moment_date_format !== 'undefined') {
                $('#md_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
            }
        }

        // Force defaults on reload (avoid browser restoring old values).
        resetDonationFiltersToDefault();

        if (typeof dateRangeSettings !== 'undefined' && $('#md_date_range').length) {
            var start = moment($('#md_start_date').val(), 'YYYY-MM-DD');
            var end = moment($('#md_end_date').val(), 'YYYY-MM-DD');
            $('#md_date_range').daterangepicker(
                $.extend({}, dateRangeSettings, { startDate: start, endDate: end }),
                function (s, e) {
                    $('#md_start_date').val(s.format('YYYY-MM-DD'));
                    $('#md_end_date').val(e.format('YYYY-MM-DD'));
                    $('#md_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
                    table.ajax.reload();
                }
            );
            $('#md_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
            $('#md_date_range').on('cancel.daterangepicker', function() {
                resetDonationFiltersToDefault();
                table.ajax.reload();
            });
        }

        var table = $('#mosque_donations_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '<?php echo e(route("mosque.donations.data"), false); ?>',
                data: function (d) {
                    d.start_date = $('#md_start_date').val();
                    d.end_date = $('#md_end_date').val();
                    d.type = $('#md_type').val();
                    d.channel = $('#md_channel').val();
                }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'date', name: 'date' },
                { data: 'receipt_no', name: 'receipt_no' },
                { data: 'contact', name: 'donor_name', orderable: false, searchable: true },
                { data: 'type', name: 'type' },
                { data: 'channel', name: 'channel' },
                { data: 'amount', name: 'amount', orderable: false, searchable: false },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            drawCallback: function () {
                __currency_convert_recursively($('#mosque_donations_table'));
            }
        });

        function applyTypeTotals(summary) {
            var totals = (summary && summary.type_totals) ? summary.type_totals : {};
            var keys = ['zakat','sadaqah','fitrah','general','event','waqf'];
            keys.forEach(function (k) {
                var v = (totals && totals[k] != null) ? totals[k] : 0;
                var $el = $('#md_total_' + k);
                $el.attr('data-orig-value', v);
                $el.text(v);
            });
            __currency_convert_recursively($('#md_type_totals'));
        }

        table.on('xhr.dt', function (e, settings, json) {
            if (json && json.summary) {
                applyTypeTotals(json.summary);
            }
        });

        table.on('init.dt', function () {
            $('#mosque_donations_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
        });

        // Ensure defaults also apply on BFCache restores (Back/Forward + some reload flows).
        window.addEventListener('pageshow', function () {
            resetDonationFiltersToDefault();
            if ($('#md_date_range').data('daterangepicker')) {
                var s = moment($('#md_start_date').val(), 'YYYY-MM-DD');
                var e = moment($('#md_end_date').val(), 'YYYY-MM-DD');
                $('#md_date_range').data('daterangepicker').setStartDate(s);
                $('#md_date_range').data('daterangepicker').setEndDate(e);
                $('#md_date_range').val(s.format(moment_date_format) + ' ~ ' + e.format(moment_date_format));
            }
            table.ajax.reload();
        });

        $(document).on('change', '#md_type, #md_channel', function () {
            table.ajax.reload();
        });

        $(document).on('submit', 'form#mosque_donation_form', function (e) {
            e.preventDefault();
            var $form = $(this);
            $.ajax({
                method: $form.find('input[name=_method]').val() || $form.attr('method'),
                url: $form.attr('action'),
                data: $form.serialize(),
                success: function (result) {
                    if (result.success) {
                        $('.mosque_donation_modal').modal('hide');
                        toastr.success(result.msg);
                        table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                },
                error: function () {
                    toastr.error('<?php echo app('translator')->get("messages.something_went_wrong"); ?>');
                }
            });
        });

        $(document).on('click', '.delete_mosque_donation', function (e) {
            e.preventDefault();
            var href = $(this).data('href');
            $('#mosque_donation_confirm_delete_url').val(href);
            $('#mosque_donation_confirm_delete_input').val('');
            $('#mosque_donation_confirm_delete_modal').modal('show');
        });

        $('#mosque_donation_confirm_delete_btn').on('click', function () {
            var txt = ($('#mosque_donation_confirm_delete_input').val() || '').trim();
            if (txt !== 'Confirm') {
                toastr.error('Please type Confirm (case-sensitive).');
                return;
            }
            var href = $('#mosque_donation_confirm_delete_url').val();
            $.ajax({
                method: 'DELETE',
                url: href,
                data: { _token: '<?php echo e(csrf_token(), false); ?>' },
                success: function (result) {
                    if (result.success || result.ok) {
                        $('#mosque_donation_confirm_delete_modal').modal('hide');
                        toastr.success(result.msg || result.toast || '<?php echo app('translator')->get("lang_v1.success"); ?>');
                        table.ajax.reload();
                    } else {
                        toastr.error(result.msg || result.toast || '<?php echo app('translator')->get("messages.something_went_wrong"); ?>');
                    }
                },
                error: function () {
                    toastr.error('<?php echo app('translator')->get("messages.something_went_wrong"); ?>');
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('mosque::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/procharmate/public_html/serial.procharmate.com/Modules/Mosque/Providers/../Resources/views/donations/index.blade.php ENDPATH**/ ?>