<?php $__env->startSection('title', __('whatsappbot::lang.settings')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1><?php echo app('translator')->get('whatsappbot::lang.whatsapp_bot'); ?>
        <small><?php echo app('translator')->get('whatsappbot::lang.settings'); ?></small>
    </h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-8">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        <i class="fa fa-cog"></i> <?php echo app('translator')->get('whatsappbot::lang.whatsapp_settings'); ?>
                    </h3>
                </div>
                <form action="<?php echo e(route('whatsappbot.settings.update'), false); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                <div class="box-body">
                    <div class="form-group">
                        <label for="whatsapp_phone"><?php echo app('translator')->get('whatsappbot::lang.whatsapp_phone_number'); ?></label>
                        <input type="text" name="whatsapp_phone" id="whatsapp_phone" 
                               class="form-control" 
                               value="<?php echo e($business->whatsapp_phone ?? '', false); ?>"
                               placeholder="+2348012345678">
                        <p class="help-block"><?php echo app('translator')->get('whatsappbot::lang.phone_help'); ?></p>
                    </div>
                    
                    <div class="form-group">
                        <div class="checkbox">
                            <label>
                                <input type="checkbox" name="whatsapp_enabled" value="1" 
                                       <?php echo e(($business->whatsapp_enabled ?? false) ? 'checked' : '', false); ?>>
                                <?php echo app('translator')->get('whatsappbot::lang.enable_whatsapp_bot'); ?>
                            </label>
                        </div>
                        <p class="help-block"><?php echo app('translator')->get('whatsappbot::lang.enable_whatsapp_help'); ?></p>
                    </div>

                    <div class="form-group">
                        <div class="checkbox">
                            <label>
                                <input type="checkbox" name="auto_send_invoices" value="1" 
                                       <?php echo e(($business->auto_send_invoices ?? false) ? 'checked' : '', false); ?>>
                                <?php echo app('translator')->get('whatsappbot::lang.auto_send_invoices'); ?>
                            </label>
                        </div>
                        <p class="help-block"><?php echo app('translator')->get('whatsappbot::lang.auto_send_invoices_help'); ?></p>
                    </div>

                    <div class="form-group">
                        <label><?php echo app('translator')->get('whatsappbot::lang.webhook_url'); ?></label>
                        <div class="input-group">
                            <input type="text" class="form-control" readonly 
                                   value="<?php echo e(url('/api/webhook/whatsapp'), false); ?>">
                            <div class="input-group-btn">
                                <button type="button" class="btn btn-info" 
                                        onclick="copyToClipboard('<?php echo e(url('/api/webhook/whatsapp'), false); ?>')">
                                    <i class="fa fa-copy"></i> <?php echo app('translator')->get('whatsappbot::lang.copy'); ?>
                                </button>
                            </div>
                        </div>
                        <p class="help-block"><?php echo app('translator')->get('whatsappbot::lang.webhook_help'); ?></p>
                    </div>

                    <div class="form-group">
                        <label><?php echo app('translator')->get('whatsappbot::lang.api_endpoint'); ?></label>
                        <input type="text" class="form-control" readonly 
                               value="<?php echo e(config('whatsappbot.nodeurl'), false); ?>">
                        <p class="help-block"><?php echo app('translator')->get('whatsappbot::lang.api_endpoint_help'); ?></p>
                    </div>
                </div>
                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> <?php echo app('translator')->get('whatsappbot::lang.save_settings'); ?>
                    </button>
                    <a href="<?php echo e(route('whatsappbot.index'), false); ?>" class="btn btn-default">
                        <i class="fa fa-arrow-left"></i> <?php echo app('translator')->get('whatsappbot::lang.back_to_dashboard'); ?>
                    </a>
                </div>
                </form>
            </div>
        </div>

        <!-- Status Card -->
        <div class="col-md-4">
            <div class="box box-info">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        <i class="fa fa-info-circle"></i> <?php echo app('translator')->get('whatsappbot::lang.current_status'); ?>
                    </h3>
                </div>
                <div class="box-body">
                    <table class="table table-condensed">
                        <tr>
                            <td><strong><?php echo app('translator')->get('whatsappbot::lang.status'); ?>:</strong></td>
                            <td>
                                <?php if($business->whatsapp_enabled ?? false): ?>
                                    <span class="label label-success">
                                        <i class="fa fa-check"></i> <?php echo app('translator')->get('whatsappbot::lang.enabled'); ?>
                                    </span>
                                <?php else: ?>
                                    <span class="label label-danger">
                                        <i class="fa fa-times"></i> <?php echo app('translator')->get('whatsappbot::lang.disabled'); ?>
                                    </span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <td><strong><?php echo app('translator')->get('whatsappbot::lang.phone'); ?>:</strong></td>
                            <td>
                                <?php if($business->whatsapp_phone): ?>
                                    <span class="text-success"><?php echo e($business->whatsapp_phone, false); ?></span>
                                <?php else: ?>
                                    <span class="text-warning"><?php echo app('translator')->get('whatsappbot::lang.not_configured'); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <td><strong><?php echo app('translator')->get('whatsappbot::lang.auto_invoices'); ?>:</strong></td>
                            <td>
                                <?php if($business->auto_send_invoices ?? false): ?>
                                    <span class="label label-success">
                                        <i class="fa fa-check"></i> <?php echo app('translator')->get('whatsappbot::lang.enabled'); ?>
                                    </span>
                                <?php else: ?>
                                    <span class="label label-default">
                                        <i class="fa fa-times"></i> <?php echo app('translator')->get('whatsappbot::lang.disabled'); ?>
                                    </span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <td><strong><?php echo app('translator')->get('whatsappbot::lang.api_configured'); ?>:</strong></td>
                            <td>
                                <?php if(config('whatsappbot.token')): ?>
                                    <span class="label label-success">
                                        <i class="fa fa-check"></i> <?php echo app('translator')->get('whatsappbot::lang.yes'); ?>
                                    </span>
                                <?php else: ?>
                                    <span class="label label-danger">
                                        <i class="fa fa-times"></i> <?php echo app('translator')->get('whatsappbot::lang.no'); ?>
                                    </span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Central Bot Mode:</strong></td>
                            <td>
                                <?php if(config('whatsappbot.central_bot_enabled')): ?>
                                    <span class="label label-primary">
                                        <i class="fa fa-robot"></i> Enabled
                                    </span>
                                <?php else: ?>
                                    <span class="label label-default">
                                        <i class="fa fa-user"></i> Individual Mode
                                    </span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php if(config('whatsappbot.central_bot_enabled')): ?>
                        <tr>
                            <td><strong>Central Bot Number:</strong></td>
                            <td>
                                <?php if(config('whatsappbot.central_bot_number')): ?>
                                    <span class="text-info">
                                        <i class="fa fa-whatsapp"></i> <?php echo e(config('whatsappbot.central_bot_number'), false); ?>

                                    </span>
                                    <br><small class="text-muted">Send messages TO this number</small>
                                <?php else: ?>
                                    <span class="text-warning">Not configured</span>
                                    <br><small class="text-muted">Set WHATSAPP_CENTRAL_BOT_NUMBER in .env</small>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">
    function copyToClipboard(text) {
        var temp = $('<input>');
        $('body').append(temp);
        temp.val(text).select();
        document.execCommand('copy');
        temp.remove();
        toastr.success('<?php echo app('translator')->get("whatsappbot::lang.copied_to_clipboard"); ?>');
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/procharmate/public_html/serial.procharmate.com/Modules/WhatsAppBot/Resources/views/settings.blade.php ENDPATH**/ ?>