<?php $__env->startSection('title', __('mosque::mosque.menu_tenancy') . ' | ' . __('mosque::mosque.tenancy_seat_board')); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black"><?php echo app('translator')->get('mosque::mosque.menu_tenancy'); ?></h1>
</section>

<section class="content">
    <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
        <?php echo $__env->make('mosque::tenancy.partials.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <style>
            .ten-board-controls label{font-size:12px;margin-bottom:4px;}
            .ten-room-container{background:#fff;border-radius:12px;padding:20px;margin-bottom:20px;box-shadow:0 2px 8px rgba(0,0,0,0.08)}
            .ten-floor-section{margin-bottom:25px}
            .ten-floor-header{display:flex;align-items:center;gap:12px;padding:12px 16px;background:linear-gradient(135deg,#667eea 0%,#764ba2 100%);border-radius:8px;color:#fff;margin-bottom:15px}
            .ten-floor-icon{font-size:18px}
            .ten-floor-title{font-size:16px;font-weight:700;flex:1}
            .ten-floor-seats{font-size:13px;font-weight:600;background:rgba(255,255,255,.2);padding:4px 12px;border-radius:20px}
            .ten-room{background:#f8f9fa;border:1px solid #e9ecef;border-radius:10px;padding:15px;margin-bottom:12px}
            .ten-room-header{display:flex;align-items:center;gap:10px;margin-bottom:12px;padding-bottom:10px;border-bottom:1px solid #e9ecef}
            .ten-room-icon{font-size:14px;color:#6b7280}
            .ten-room-title{font-size:14px;font-weight:700;color:#0b1020;flex:1}
            .ten-room-type{font-size:11px;padding:3px 10px;border-radius:15px;font-weight:600;background:#eef2ff;color:#3730a3}
            .ten-room-stats{display:flex;gap:15px;font-size:12px;color:#6b7280}
            .ten-room-stat{display:flex;align-items:center;gap:4px}
            .ten-seat-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(100px,1fr));gap:12px}
            .ten-bed-item{position:relative;background:#fff;border-radius:10px;padding:10px;cursor:pointer;transition:all 0.2s ease;border:2px solid transparent}
            .ten-bed-item:hover{transform:translateY(-3px);box-shadow:0 4px 12px rgba(0,0,0,0.1)}
            .ten-bed-item.available{border-color:#10b981;background:#f0fdf4}
            .ten-bed-item.available .ten-bed-svg path{fill:#10b981}
            .ten-bed-item.occupied{border-color:#ef4444;background:#fef2f2}
            .ten-bed-item.occupied .ten-bed-svg path{fill:#ef4444}
            .ten-bed-item.leaving{border-color:#f59e0b;background:#fffbeb}
            .ten-bed-item.leaving .ten-bed-svg path{fill:#f59e0b}
            .ten-bed-item.held{border-color:#94a3b8;background:#f8fafc}
            .ten-bed-item.held .ten-bed-svg path{fill:#94a3b8}
            .ten-bed-item.maintenance{border-color:#6b7280;background:#f1f5f9}
            .ten-bed-item.maintenance .ten-bed-svg path{fill:#6b7280}
            .ten-bed-svg{width:45px;height:35px;display:block;margin:0 auto 8px}
            .ten-bed-number{font-size:13px;font-weight:700;text-align:center;color:#0b1020;margin-bottom:2px}
            .ten-bed-status{font-size:10px;text-align:center;font-weight:600;text-transform:uppercase;letter-spacing:0.5px}
            .ten-bed-item.available .ten-bed-status{color:#059669}
            .ten-bed-item.occupied .ten-bed-status{color:#dc2626}
            .ten-bed-item.leaving .ten-bed-status{color:#d97706}
            .ten-bed-item.held .ten-bed-status{color:#64748b}
            .ten-bed-item.maintenance .ten-bed-status{color:#475569}
            .ten-legend{display:flex;align-items:center;gap:8px;font-size:12px;font-weight:600}
            .ten-legend-box{width:16px;height:16px;border-radius:4px;border:2px solid}
            .ten-legend-box.available{border-color:#10b981;background:#10b981}
            .ten-legend-box.occupied{border-color:#ef4444;background:#ef4444}
            .ten-legend-box.leaving{border-color:#f59e0b;background:#f59e0b}
            .ten-legend-box.held{border-color:#94a3b8;background:#94a3b8}
            .ten-legend-box.maintenance{border-color:#6b7280;background:#6b7280}
            .ten-tooltip{position:absolute;z-index:9999;background:#1f2937;color:#fff;padding:12px 16px;border-radius:12px;max-width:280px;box-shadow:0 10px 40px rgba(0,0,0,.3);display:none}
            .ten-tooltip .name{font-weight:700;margin-bottom:6px;font-size:14px}
            .ten-tooltip .detail{display:flex;gap:8px;margin-bottom:4px;font-size:12px}
            .ten-tooltip .label{color:#9ca3af}
            .ten-tooltip .value{color:#f3f4f6}
        </style>

        <div style="margin-top:15px;">
            <div class="row ten-board-controls">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label><?php echo app('translator')->get('mosque::mosque.tenancy_building'); ?></label>
                        <select class="form-control" id="ten_building_id">
                            <option value=""><?php echo app('translator')->get('mosque::mosque.tenancy_select_building'); ?></option>
                            <?php $__currentLoopData = ($buildings ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($id, false); ?>"><?php echo e($name, false); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="form-group">
                        <label><?php echo app('translator')->get('mosque::mosque.tenancy_floor'); ?></label>
                        <div id="ten_floor_tabs" style="margin-top:5px;"></div>
                    </div>
                </div>
            </div>

            <div class="row" style="margin-top:10px;">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label><?php echo app('translator')->get('mosque::mosque.tenancy_search_seats'); ?></label>
                        <input type="text" class="form-control" id="ten_seat_search" placeholder="<?php echo e(__('mosque::mosque.tenancy_search_by_code'), false); ?>">
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label><?php echo app('translator')->get('mosque::mosque.tenancy_filter_status'); ?></label>
                        <select class="form-control" id="ten_status_filter">
                            <option value="all"><?php echo app('translator')->get('mosque::mosque.tenancy_all_statuses'); ?></option>
                            <option value="available"><?php echo app('translator')->get('mosque::mosque.tenancy_status_available'); ?></option>
                            <option value="occupied"><?php echo app('translator')->get('mosque::mosque.tenancy_status_occupied'); ?></option>
                            <option value="leaving"><?php echo app('translator')->get('mosque::mosque.tenancy_status_leaving'); ?></option>
                            <option value="held"><?php echo app('translator')->get('mosque::mosque.tenancy_status_held'); ?></option>
                            <option value="maintenance"><?php echo app('translator')->get('mosque::mosque.tenancy_status_maintenance'); ?></option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label><?php echo app('translator')->get('mosque::mosque.tenancy_filter_room_type'); ?></label>
                        <select class="form-control" id="ten_room_type_filter">
                            <option value="all"><?php echo app('translator')->get('mosque::mosque.tenancy_all_types'); ?></option>
                            <option value="Room"><?php echo e(__('mosque::mosque.tenancy_type_room'), false); ?></option>
                            <option value="Apartment"><?php echo e(__('mosque::mosque.tenancy_type_apartment'), false); ?></option>
                            <option value="Ward"><?php echo e(__('mosque::mosque.tenancy_type_ward'), false); ?></option>
                        </select>
                    </div>
                </div>
            </div>

            <div class="row" style="margin-top:10px;">
                <div class="col-sm-12">
                    <div class="well well-sm" style="margin:0;padding:10px;">
                        <div style="display:flex;gap:20px;flex-wrap:wrap;font-size:13px;">
                            <div><span class="ten-legend-box available"></span> <?php echo app('translator')->get('mosque::mosque.tenancy_status_available'); ?> (<span id="ten_count_available">0</span>)</div>
                            <div><span class="ten-legend-box occupied"></span> <?php echo app('translator')->get('mosque::mosque.tenancy_status_occupied'); ?> (<span id="ten_count_occupied">0</span>)</div>
                            <div><span class="ten-legend-box leaving"></span> <?php echo app('translator')->get('mosque::mosque.tenancy_status_leaving'); ?> (<span id="ten_count_leaving">0</span>)</div>
                            <div><span class="ten-legend-box held"></span> <?php echo app('translator')->get('mosque::mosque.tenancy_status_held'); ?> (<span id="ten_count_held">0</span>)</div>
                            <div><span class="ten-legend-box maintenance"></span> <?php echo app('translator')->get('mosque::mosque.tenancy_status_maintenance'); ?> (<span id="ten_count_maintenance">0</span>)</div>
                            <div><span id="ten_total_seats"><?php echo app('translator')->get('mosque::mosque.tenancy_total_seats', ['count' => 0]); ?></span></div>
                        </div>
                    </div>
                </div>
            </div>

            <div id="ten_board_loading" class="text-muted" style="display:none;margin:10px 0;"><?php echo app('translator')->get('mosque::mosque.tenancy_loading'); ?></div>
            <div id="ten_board_empty" class="alert alert-warning" style="display:none;margin:10px 0;"><?php echo app('translator')->get('mosque::mosque.tenancy_no_data'); ?></div>
            <div id="ten_rooms_container"></div>
        </div>
    <?php echo $__env->renderComponent(); ?>

    <div class="modal fade" id="ten_seat_modal" tabindex="-1" role="dialog" aria-labelledby="tenSeatModalLabel">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="tenSeatModalLabel"><?php echo app('translator')->get('mosque::mosque.tenancy_seat'); ?></h4>
                </div>
                <div class="modal-body">
                    <div id="ten_seat_modal_body"></div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="ten_allocate_modal" tabindex="-1" role="dialog" aria-labelledby="tenAllocateModalLabel">
        <div class="modal-dialog" role="document">
            <form id="ten_allocate_form">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" id="tenAllocateModalLabel"><?php echo app('translator')->get('mosque::mosque.tenancy_allocate'); ?></h4>
                    </div>
                    <div class="modal-body">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="seat_id" id="ten_allocate_seat_id">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('mosque::mosque.tenancy_tenant'); ?></label>
                            <select class="form-control select2" name="tenant_id" id="ten_allocate_tenant_id" required style="width:100%;"></select>
                            <p class="help-block" style="margin-top:6px;">
                                <a href="<?php echo e(route('mosque.tenancy.tenants.create'), false); ?>" target="_blank"><?php echo app('translator')->get('mosque::mosque.tenancy_add_tenant'); ?></a>
                            </p>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('mosque::mosque.tenancy_start_date'); ?></label>
                                    <input type="date" class="form-control" name="start_date" value="<?php echo e(now()->toDateString(), false); ?>" required>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('mosque::mosque.tenancy_amount'); ?></label>
                                    <input type="number" step="0.01" class="form-control" name="rent_amount" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('mosque::mosque.tenancy_cycle'); ?></label>
                                    <select class="form-control" name="billing_cycle" required>
                                        <option value="monthly"><?php echo app('translator')->get('mosque::mosque.tenancy_cycle_monthly'); ?></option>
                                        <option value="yearly"><?php echo app('translator')->get('mosque::mosque.tenancy_cycle_yearly'); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('mosque::mosque.tenancy_security_deposit'); ?></label>
                                    <input type="number" step="0.01" class="form-control" name="security_deposit">
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('mosque::mosque.tenancy_note'); ?></label>
                            <textarea class="form-control" name="note" rows="2"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo app('translator')->get('messages.close'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('mosque::mosque.tenancy_allocate'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="ten_move_modal" tabindex="-1" role="dialog" aria-labelledby="tenMoveModalLabel">
        <div class="modal-dialog" role="document">
            <form id="ten_move_form">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" id="tenMoveModalLabel"><?php echo app('translator')->get('mosque::mosque.tenancy_move'); ?></h4>
                    </div>
                    <div class="modal-body">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" id="ten_move_alloc_id">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('mosque::mosque.tenancy_new_seat'); ?> *</label>
                            <select class="form-control" id="ten_move_new_seat_id" required></select>
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('mosque::mosque.tenancy_move_date'); ?> *</label>
                            <input type="date" class="form-control" id="ten_move_date" required value="<?php echo e(now()->toDateString(), false); ?>">
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('mosque::mosque.tenancy_note'); ?></label>
                            <input type="text" class="form-control" id="ten_move_note" maxlength="2000">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo app('translator')->get('messages.close'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('mosque::mosque.tenancy_move'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="ten_end_modal" tabindex="-1" role="dialog" aria-labelledby="tenEndModalLabel">
        <div class="modal-dialog" role="document">
            <form id="ten_end_form">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" id="tenEndModalLabel"><?php echo app('translator')->get('mosque::mosque.tenancy_end_allocation'); ?></h4>
                    </div>
                    <div class="modal-body">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" id="ten_end_alloc_id">
                        <input type="hidden" id="ten_end_seat_id">
                        <div class="alert alert-info" style="margin-bottom:15px;">
                            <?php echo app('translator')->get('mosque::mosque.tenancy_end_warning'); ?>
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('mosque::mosque.tenancy_end_date'); ?> *</label>
                            <input type="date" class="form-control" id="ten_end_date" required value="<?php echo e(now()->toDateString(), false); ?>">
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('mosque::mosque.tenancy_note'); ?></label>
                            <textarea class="form-control" id="ten_end_note" rows="2" maxlength="2000"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo app('translator')->get('messages.cancel'); ?></button>
                        <button type="submit" class="btn btn-warning"><?php echo app('translator')->get('mosque::mosque.tenancy_end'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="ten-tooltip" id="ten_tooltip"></div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script>
    (function () {
        var floorsUrl = <?php echo json_encode(route('mosque.tenancy.seat_board.floors', [], false)) ?>;
        var floorUrl = <?php echo json_encode(route('mosque.tenancy.seat_board.floor', [], false)) ?>;
        var allocUrl = <?php echo json_encode(route('mosque.tenancy.allocations.store', [], false)) ?>;
        var moveAllocUrlTmpl = <?php echo json_encode(route('mosque.tenancy.allocations.move', ['id' => 0], false)) ?>;
        var seatStatusUrlTmpl = <?php echo json_encode(route('mosque.tenancy.seats.status', ['id' => 0], false)) ?>;
        var markLeavingUrlTmpl = <?php echo json_encode(route('mosque.tenancy.seats.leaving', ['id' => 0], false)) ?>;
        var endAllocUrlTmpl = <?php echo json_encode(route('mosque.tenancy.allocations.end', ['id' => 0], false)) ?>;
        var tenantsDataUrl = <?php echo json_encode(route('mosque.tenancy.tenants.data', [], false)) ?>;
        var monthsStayedLabel = <?php echo json_encode(__('mosque::mosque.tenancy_months_stayed'), 15, 512) ?>;

        var allFloors = [];
        var seatMap = {};
        var tenantsCache = null;
        var currentBuildingId = null;

        function toast(type, msg) {
            if (window.toastr && toastr[type]) { toastr[type](msg); return; }
            alert(msg);
        }

        function setLoading(on) { $('#ten_board_loading').toggle(!!on); }
        function escapeHtml(s) { return $('<div>').text(s || '').html(); }

        function loadTenantsOnce(cb) {
            if (tenantsCache) { cb(tenantsCache); return; }
            $.ajax({
                url: tenantsDataUrl,
                dataType: 'json',
                data: { length: 500, start: 0, draw: 1 },
                success: function (resp) {
                    var rows = (resp && resp.data) ? resp.data : [];
                    tenantsCache = rows.map(function (r) { return { id: r.id, name: r.full_name || ('#' + r.id) }; });
                    cb(tenantsCache);
                },
                error: function () { tenantsCache = []; cb([]); }
            });
        }

        function loadAllFloors(buildingId) {
            $('#ten_board_empty').hide();
            $('#ten_rooms_container').html('');
            if (!buildingId) {
                allFloors = [];
                renderAllFloors();
                return;
            }
            setLoading(true);
            $.getJSON(floorsUrl, { building_id: buildingId }).done(function (resp) {
                setLoading(false);
                allFloors = (resp && resp.floors) ? resp.floors : [];
                loadAllFloorRooms();
            }).fail(function () {
                setLoading(false);
                toast('error', <?php echo json_encode(__('messages.something_went_wrong'), 15, 512) ?>);
            });
        }

        function loadAllFloorRooms() {
            if (allFloors.length === 0) {
                renderAllFloors();
                return;
            }
            var loadedCount = 0;
            var allFloorRooms = [];
            
            allFloors.forEach(function (floor) {
                $.getJSON(floorUrl, { floor_id: floor.id }).done(function (resp) {
                    floor.rooms = (resp && resp.rooms) ? resp.rooms : [];
                    loadedCount++;
                    if (loadedCount === allFloors.length) {
                        renderAllFloors();
                    }
                }).fail(function () {
                    floor.rooms = [];
                    loadedCount++;
                    if (loadedCount === allFloors.length) {
                        renderAllFloors();
                    }
                });
            });
        }

        var allFloorData = [];

        function renderAllFloors() {
            seatMap = {};
            allFloorData = [];
            var totalAvailable = 0, totalOccupied = 0, totalLeaving = 0, totalHeld = 0, totalMaintenance = 0;
            var roomTypes = new Set();

            allFloors.forEach(function (floor) {
                if (!floor.rooms || floor.rooms.length === 0) return;
                allFloorData.push(floor);
                floor.rooms.forEach(function (room) {
                    if (!room.seats || room.seats.length === 0) return;
                    room.seats.forEach(function (seat) {
                        seatMap[seat.id] = seat;
                        seat.floor_id = floor.id;
                        seat.floor_name = floor.name_or_number;
                        
                        switch(seat.effective_status) {
                            case 'available': totalAvailable++; break;
                            case 'occupied': totalOccupied++; break;
                            case 'leaving': totalLeaving++; break;
                            case 'held': totalHeld++; break;
                            case 'maintenance': totalMaintenance++; break;
                        }
                        
                        if (room.type) roomTypes.add(room.type);
                    });
                });
            });

            applyFilters();
        }

        var filteredFloorData = [];

        function applyFilters() {
            var searchTerm = $('#ten_seat_search').val().toLowerCase();
            var statusFilter = $('#ten_status_filter').val();
            var roomTypeFilter = $('#ten_room_type_filter').val().toLowerCase();

            filteredFloorData = [];
            var totalAvailable = 0, totalOccupied = 0, totalLeaving = 0, totalHeld = 0, totalMaintenance = 0;

            allFloorData.forEach(function (floor) {
                var floorRooms = [];
                floor.rooms.forEach(function (room) {
                    var roomSeats = [];
                    var roomType = (room.type || '').toLowerCase();
                    var matchesType = roomTypeFilter === 'all' || roomType.indexOf(roomTypeFilter) >= 0;
                    
                    if (!matchesType) {
                        room.displaySeats = [];
                        return;
                    }

                    room.seats.forEach(function (seat) {
                        var matchesSearch = !searchTerm || seat.code.toLowerCase().indexOf(searchTerm) >= 0;
                        var matchesStatus = statusFilter === 'all' || seat.effective_status === statusFilter;
                        
                        if (matchesSearch && matchesStatus) {
                            roomSeats.push(seat);
                            switch(seat.effective_status) {
                                case 'available': totalAvailable++; break;
                                case 'occupied': totalOccupied++; break;
                                case 'leaving': totalLeaving++; break;
                                case 'held': totalHeld++; break;
                                case 'maintenance': totalMaintenance++; break;
                            }
                        }
                    });

                    room.displaySeats = roomSeats;
                    if (roomSeats.length > 0) floorRooms.push(room);
                });

                if (floorRooms.length > 0) {
                    filteredFloorData.push({
                        id: floor.id,
                        name_or_number: floor.name_or_number,
                        rooms: floorRooms
                    });
                }
            });

            var html = '';
            if (filteredFloorData.length === 0) {
                $('#ten_board_empty').show();
                $('#ten_rooms_container').html('');
            } else {
                $('#ten_board_empty').hide();
                filteredFloorData.forEach(function (floor) {
                    html += '<div class="ten-floor-section">';
                    html += '<div class="ten-floor-header">';
                    html += '<i class="fa fa-building-o ten-floor-icon"></i>';
                    html += '<span class="ten-floor-title">' + escapeHtml(floor.name_or_number) + '</span>';
                    var floorSeatCount = 0;
                    floor.rooms.forEach(function (r) { floorSeatCount += r.displaySeats.length; });
                    html += '<span class="ten-floor-seats">' + floorSeatCount + ' beds</span>';
                    html += '</div>';

                    floor.rooms.forEach(function (room) {
                        html += '<div class="ten-room">';
                        html += '<div class="ten-room-header">';
                        html += '<i class="fa fa-door-open ten-room-icon"></i>';
                        html += '<span class="ten-room-title">' + escapeHtml(room.code) + '</span>';
                        html += '<span class="ten-room-type">' + escapeHtml(room.type) + '</span>';
                        html += '<div class="ten-room-stats">';
                        var roomAvail = 0, roomOcc = 0, roomLeave = 0;
                        room.displaySeats.forEach(function (s) {
                            if (s.effective_status === 'available') roomAvail++;
                            else if (s.effective_status === 'occupied') roomOcc++;
                            else if (s.effective_status === 'leaving') roomLeave++;
                        });
                        html += '<span class="ten-room-stat"><span style="color:#10b981;">' + roomAvail + '</span> <small>Available</small></span>';
                        html += '<span class="ten-room-stat"><span style="color:#ef4444;">' + roomOcc + '</span> <small>Occupied</small></span>';
                        html += '<span class="ten-room-stat"><span style="color:#f59e0b;">' + roomLeave + '</span> <small>Leaving</small></span>';
                        html += '</div>';
                        html += '</div>';
                        html += '<div class="ten-seat-grid">';
                        room.displaySeats.forEach(function (seat, idx) {
                            var statusLabels = {
                                'available': 'Available',
                                'occupied': 'Occupied',
                                'leaving': 'Leaving',
                                'held': 'Held',
                                'maintenance': 'Maintenance'
                            };
                            html += '<div class="ten-bed-item ' + escapeHtml(seat.effective_status) + '" data-id="' + seat.id + '">';
                            html += '<svg class="ten-bed-svg" viewBox="0 0 45 35">';
                            html += '<path d="M4.5,8.5 L4.5,30.5 L40.5,30.5 L40.5,8.5 M4.5,8.5 C4.5,5.5 7,4.5 8.5,4.5 L36.5,4.5 C38,4.5 40.5,5.5 40.5,8.5 M4.5,15.5 L40.5,15.5 M4.5,23.5 L40.5,23.5" fill="none" stroke="currentColor" stroke-width="2"/>';
                            html += '<rect x="11.5" y="18.5" width="8" height="6" fill="none" stroke="currentColor" stroke-width="1.5" rx="0.5"/>';
                            html += '<rect x="25.5" y="18.5" width="8" height="6" fill="none" stroke="currentColor" stroke-width="1.5" rx="0.5"/>';
                            html += '<path d="M2,4.5 L4.5,4.5 L4.5,8.5 M43,4.5 L40.5,4.5 L40.5,8.5" fill="none" stroke="currentColor" stroke-width="1.5"/>';
                            html += '</svg>';
                            html += '<div class="ten-bed-number">' + escapeHtml(seat.code) + '</div>';
                            html += '<div class="ten-bed-status">' + escapeHtml(statusLabels[seat.effective_status] || seat.effective_status) + '</div>';
                            html += '</div>';
                        });
                        html += '</div>';
                        html += '</div>';
                    });

                    html += '</div>';
                });
                $('#ten_rooms_container').html(html);
            }

            $('#ten_count_available').text(totalAvailable);
            $('#ten_count_occupied').text(totalOccupied);
            $('#ten_count_leaving').text(totalLeaving);
            $('#ten_count_held').text(totalHeld);
            $('#ten_count_maintenance').text(totalMaintenance);

            var totalSeats = totalAvailable + totalOccupied + totalLeaving + totalHeld + totalMaintenance;
            $('#ten_total_seats').text(<?php echo json_encode(__('mosque::mosque.tenancy_total_seats', ['count' => 0]), 512) ?>.replace('0', totalSeats));

            var currentTypeFilter = $('#ten_room_type_filter').val();
            if (currentTypeFilter !== 'all') {
                // Keep the selected filter value
                return;
            }
            // Only update filter options when on "All" to preserve current selection
            var typesHtml = '<option value="all"><?php echo app('translator')->get('mosque::mosque.tenancy_all_types'); ?></option>';
                Array.from(roomTypes).sort().forEach(function (t) {
                    typesHtml += '<option value="' + escapeHtml(t) + '">' + escapeHtml(t) + '</option>';
                });
                $('#ten_room_type_filter').html(typesHtml);
        }

        function openSeatModal(seatId) {
            var s = seatMap[seatId];
            if (!s) return;
            var body = '';
            body += '<div><strong><?php echo app('translator')->get('mosque::mosque.tenancy_seat'); ?>:</strong> ' + escapeHtml(s.code) + '</div>';
            body += '<div><strong><?php echo app('translator')->get('mosque::mosque.tenancy_status'); ?>:</strong> ' + escapeHtml(s.effective_status) + '</div>';
            if (s.leaving_on) body += '<div><strong><?php echo app('translator')->get('mosque::mosque.tenancy_leaving_on'); ?>:</strong> ' + escapeHtml(s.leaving_on) + '</div>';
            if (s.tenant) {
                body += '<hr style="margin:10px 0;">';
                body += '<div><strong><?php echo app('translator')->get('mosque::mosque.tenancy_tenant'); ?>:</strong> ' + escapeHtml(s.tenant.name) + '</div>';
                body += '<div><strong><?php echo app('translator')->get('mosque::mosque.tenancy_phone'); ?>:</strong> ' + escapeHtml(s.tenant.phone) + '</div>';
                if (s.tenant.area) body += '<div><strong><?php echo app('translator')->get('mosque::mosque.tenancy_area'); ?>:</strong> ' + escapeHtml(s.tenant.area) + '</div>';
            }
            body += '<hr style="margin:10px 0;">';
            body += '<div class="row">';
            if (!s.allocation) {
                body += '<div class="col-sm-6" style="margin-bottom:8px;"><button class="btn btn-xs btn-primary" id="ten_btn_allocate" data-seat="' + seatId + '"><?php echo app('translator')->get('mosque::mosque.tenancy_allocate'); ?></button></div>';
            } else {
                body += '<div class="col-sm-6" style="margin-bottom:8px;"><button class="btn btn-xs btn-info" id="ten_btn_move_alloc" data-alloc="' + s.allocation.id + '" data-seat="' + seatId + '"><?php echo app('translator')->get('mosque::mosque.tenancy_move'); ?></button></div>';
                body += '<div class="col-sm-6" style="margin-bottom:8px;"><button class="btn btn-xs btn-warning" id="ten_btn_end_alloc" data-alloc="' + s.allocation.id + '" data-seat="' + seatId + '"><?php echo app('translator')->get('mosque::mosque.tenancy_end'); ?></button></div>';
                body += '<div class="col-sm-12" style="margin-bottom:8px;"><div class="well well-sm" style="margin:0;"><strong><?php echo app('translator')->get('mosque::mosque.tenancy_rent'); ?>:</strong> ' + escapeHtml(s.allocation.rent_amount) + ' (' + escapeHtml(s.allocation.billing_cycle) + ')</div></div>';
            }
            body += '</div>';
            body += '<div class="row">';
            if (!s.allocation) {
                body += '<div class="col-sm-4"><button class="btn btn-xs btn-default ten-seat-status" data-seat="' + seatId + '" data-status="available"><?php echo app('translator')->get('mosque::mosque.tenancy_set_available'); ?></button></div>';
                body += '<div class="col-sm-4"><button class="btn btn-xs btn-default ten-seat-status" data-seat="' + seatId + '" data-status="held"><?php echo app('translator')->get('mosque::mosque.tenancy_set_held'); ?></button></div>';
            }
            body += '<div class="col-sm-4"><button class="btn btn-xs btn-default ten-seat-status" data-seat="' + seatId + '" data-status="maintenance"><?php echo app('translator')->get('mosque::mosque.tenancy_set_maintenance'); ?></button></div>';
            body += '</div>';
            body += '<div class="row" style="margin-top:8px;">';
            body += '<div class="col-sm-12"><div class="input-group input-group-sm"><span class="input-group-addon"><?php echo app('translator')->get('mosque::mosque.tenancy_leaving_on'); ?></span><input type="date" class="form-control" id="ten_leaving_on" value="' + (s.leaving_on || '') + '"><span class="input-group-btn"><button class="btn btn-default" id="ten_btn_leaving_save" data-seat="' + seatId + '"><?php echo app('translator')->get('messages.save'); ?></button></span></div></div>';
            body += '</div>';
            $('#ten_seat_modal_body').html(body);
            $('#ten_seat_modal').modal('show');
        }

        function postJson(url, data, cb) {
            $.ajax({ method: 'POST', url: url, data: data, dataType: 'json',
                success: function (resp) { cb(null, resp); },
                error: function (xhr) {
                    var msg = (xhr && xhr.responseJSON && xhr.responseJSON.msg) ? xhr.responseJSON.msg : <?php echo json_encode(__('messages.something_went_wrong'), 15, 512) ?>;
                    cb(new Error(msg));
                }
            });
        }

        $(document).on('change', '#ten_building_id', function () { loadAllFloors($(this).val()); });
        $(document).on('click', '.ten-floor-btn', function () {
            $('.ten-floor-btn').removeClass('btn-primary').addClass('btn-default');
            $(this).removeClass('btn-default').addClass('btn-primary');
            currentFloorId = $(this).data('id');
            loadFloor(currentFloorId);
        });
        $(document).on('click', '.ten-bed-item', function () { openSeatModal($(this).data('id')); });

        // Filter event listeners
        $(document).on('input', '#ten_seat_search', function () { applyFilters(); });
        $(document).on('change', '#ten_status_filter', function () { applyFilters(); });
        $(document).on('change', '#ten_room_type_filter', function () { applyFilters(); });

        $(document).on('click', '#ten_btn_allocate', function () {
            var seatId = $(this).data('seat');
            $('#ten_allocate_seat_id').val(seatId);
            loadTenantsOnce(function (tenants) {
                var opts = '<option value=""><?php echo app('translator')->get('mosque::mosque.tenancy_select_tenant'); ?></option>';
                tenants.forEach(function (t) { opts += '<option value="' + t.id + '">' + escapeHtml(t.name) + '</option>'; });
                $('#ten_allocate_tenant_id').html(opts);
                $('#ten_allocate_modal').modal('show');
            });
        });

        $('#ten_allocate_form').on('submit', function (e) {
            e.preventDefault();
            var fd = new FormData(this);
            $.ajax({
                method: 'POST',
                url: allocUrl,
                data: fd,
                processData: false,
                contentType: false,
                dataType: 'json',
                    success: function (resp) {
                    if (resp && resp.success) {
                        toast('success', resp.msg || <?php echo json_encode(__('mosque::mosque.tenancy_success'), 15, 512) ?>);
                        if (resp.whatsapp_links && resp.whatsapp_links.length && typeof openWhatsAppLinksModal === 'function') {
                            openWhatsAppLinksModal(resp.whatsapp_links);
                        }
                        $('#ten_allocate_modal').modal('hide');
                        $('#ten_seat_modal').modal('hide');
                        loadAllFloors(currentBuildingId);
                    } else {
                        toast('error', (resp && resp.msg) ? resp.msg : <?php echo json_encode(__('messages.something_went_wrong'), 15, 512) ?>);
                    }
                },
                error: function (xhr) {
                    toast('error', (xhr && xhr.responseJSON && xhr.responseJSON.msg) ? xhr.responseJSON.msg : <?php echo json_encode(__('messages.something_went_wrong'), 15, 512) ?>);
                }
            });
        });

        $(document).on('click', '.ten-seat-status', function () {
            var seatId = $(this).data('seat');
            var status = $(this).data('status');
            var url = seatStatusUrlTmpl.replace(/0$/, String(seatId));
            postJson(url, { status: status, _token: <?php echo json_encode(csrf_token(), 15, 512) ?> }, function (err, resp) {
                if (err || !resp || !resp.success) { toast('error', (resp && resp.msg) ? resp.msg : err.message); return; }
                toast('success', resp.msg || <?php echo json_encode(__('mosque::mosque.tenancy_success'), 15, 512) ?>);
                $('#ten_seat_modal').modal('hide');
                loadAllFloors(currentBuildingId);
            });
        });

        $(document).on('click', '#ten_btn_leaving_save', function () {
            var seatId = $(this).data('seat');
            var leavingOn = $('#ten_leaving_on').val();
            if (!leavingOn) { toast('error', <?php echo json_encode(__('mosque::mosque.tenancy_err_leaving_date_required'), 15, 512) ?>); return; }
            var url = markLeavingUrlTmpl.replace(/0$/, String(seatId));
            postJson(url, { leaving_on: leavingOn, _token: <?php echo json_encode(csrf_token(), 15, 512) ?> }, function (err, resp) {
                if (err || !resp || !resp.success) { toast('error', (resp && resp.msg) ? resp.msg : err.message); return; }
                toast('success', resp.msg || <?php echo json_encode(__('mosque::mosque.tenancy_success'), 15, 512) ?>);
                $('#ten_seat_modal').modal('hide');
                loadAllFloors(currentBuildingId);
            });
        });

        $(document).on('click', '#ten_btn_end_alloc', function () {
            var allocId = $(this).data('alloc');
            var seatId = $(this).data('seat');
            $('#ten_end_alloc_id').val(allocId);
            $('#ten_end_seat_id').val(seatId);
            $('#ten_end_date').val(<?php echo json_encode(now()->toDateString(), 15, 512) ?>);
            $('#ten_end_note').val('');
            $('#ten_end_modal').modal('show');
        });

        $('#ten_end_form').on('submit', function (e) {
            e.preventDefault();
            var allocId = $('#ten_end_alloc_id').val();
            var endDate = $('#ten_end_date').val();
            if (!allocId || !endDate) { toast('error', <?php echo json_encode(__('messages.something_went_wrong'), 15, 512) ?>); return; }
            var url = endAllocUrlTmpl.replace(/0$/, String(allocId));
            postJson(url, { end_date: endDate, note: $('#ten_end_note').val(), _token: <?php echo json_encode(csrf_token(), 15, 512) ?> }, function (err, resp) {
                if (err || !resp || !resp.success) { toast('error', (resp && resp.msg) ? resp.msg : err.message); return; }
                toast('success', resp.msg || <?php echo json_encode(__('mosque::mosque.tenancy_success'), 15, 512) ?>);
                $('#ten_end_modal').modal('hide');
                $('#ten_seat_modal').modal('hide');
                loadAllFloors(currentBuildingId);
            });
        });

        function availableSeatOptions(excludeSeatId) {
            var opts = [];
            Object.keys(seatMap || {}).forEach(function (k) {
                var s = seatMap[k];
                if (!s || !s.id) return;
                if (excludeSeatId && Number(s.id) === Number(excludeSeatId)) return;
                if (s.effective_status === 'available' && (!s.allocation)) {
                    opts.push({ id: s.id, label: s.code });
                }
            });
            opts.sort(function (a, b) { return (a.label || '').localeCompare(b.label || ''); });
            return opts;
        }

        $(document).on('click', '#ten_btn_move_alloc', function () {
            var allocId = $(this).data('alloc');
            var seatId = $(this).data('seat');
            $('#ten_move_alloc_id').val(allocId);
            $('#ten_move_note').val('');
            $('#ten_move_date').val(<?php echo json_encode(now()->toDateString(), 15, 512) ?>);

            var opts = availableSeatOptions(seatId);
            var html = '<option value=""><?php echo app('translator')->get('mosque::mosque.tenancy_select_new_seat'); ?></option>';
            opts.forEach(function (o) { html += '<option value="' + escapeHtml(o.id) + '">' + escapeHtml(o.label) + '</option>'; });
            $('#ten_move_new_seat_id').html(html);
            $('#ten_move_modal').modal('show');
        });

        $('#ten_move_form').on('submit', function (e) {
            e.preventDefault();
            var allocId = $('#ten_move_alloc_id').val();
            var newSeatId = $('#ten_move_new_seat_id').val();
            var moveDate = $('#ten_move_date').val();
            if (!allocId || !newSeatId || !moveDate) { toast('error', <?php echo json_encode(__('messages.something_went_wrong'), 15, 512) ?>); return; }
            var url = moveAllocUrlTmpl.replace(/0$/, String(allocId));
            postJson(url, { new_seat_id: newSeatId, move_date: moveDate, note: $('#ten_move_note').val(), _token: <?php echo json_encode(csrf_token(), 15, 512) ?> }, function (err, resp) {
                if (err || !resp || !resp.success) { toast('error', (resp && resp.msg) ? resp.msg : err.message); return; }
                toast('success', resp.msg || <?php echo json_encode(__('mosque::mosque.tenancy_success'), 15, 512) ?>);
                if (resp.whatsapp_links && resp.whatsapp_links.length && typeof openWhatsAppLinksModal === 'function') {
                    openWhatsAppLinksModal(resp.whatsapp_links);
                }
                $('#ten_move_modal').modal('hide');
                $('#ten_seat_modal').modal('hide');
                loadAllFloors(currentBuildingId);
            });
        });

        // Tooltip
        var tip = $('#ten_tooltip');
        $(document).on('mouseenter', '.ten-bed-item', function () {
            var s = seatMap[$(this).data('id')];
            if (!s || !s.tenant) return;
            var html = '';
            if (s.tenant.photo_url) {
                html += '<div style="display:flex;gap:10px;align-items:center;margin-bottom:6px;">'
                    + '<img src="' + escapeHtml(s.tenant.photo_url) + '" style="width:42px;height:42px;border-radius:10px;object-fit:cover;border:1px solid rgba(255,255,255,.18);">'
                    + '<div><div class="name">' + escapeHtml(s.tenant.name) + '</div>'
                    + '<div class="small">' + escapeHtml(s.tenant.phone) + '</div></div></div>';
            } else {
                html += '<div class="name">' + escapeHtml(s.tenant.name) + '</div>';
                html += '<div class="small">' + escapeHtml(s.tenant.phone) + '</div>';
            }
            if (s.tenant.area) html += '<div class="small"><?php echo app('translator')->get('mosque::mosque.tenancy_area'); ?>: ' + escapeHtml(s.tenant.area) + '</div>';
            if (s.allocation) html += '<div class="small"><?php echo app('translator')->get('mosque::mosque.tenancy_start_date'); ?>: ' + escapeHtml(s.allocation.start_date) + '</div>';
            if (s.allocation && s.allocation.months_stayed) html += '<div class="small">' + escapeHtml(monthsStayedLabel) + ': ' + escapeHtml(s.allocation.months_stayed) + '</div>';
            tip.html(html).show();
        });
        $(document).on('mousemove', '.ten-bed-item', function (e) { tip.css({ left: (e.pageX + 14) + 'px', top: (e.pageY + 14) + 'px' }); });
        $(document).on('mouseleave', '.ten-bed-item', function () { tip.hide(); });

        // Init
        var firstBuilding = $('#ten_building_id option:eq(1)').val();
        if (firstBuilding) {
            $('#ten_building_id').val(firstBuilding);
            currentBuildingId = firstBuilding;
            loadAllFloors(firstBuilding);
        } else {
            $('#ten_board_empty').show();
        }
    })();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('mosque::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/procharmate/public_html/serial.procharmate.com/Modules/Mosque/Providers/../Resources/views/tenancy/seat_board.blade.php ENDPATH**/ ?>