<?php $__env->startSection('title', __('mosque::mosque.menu_tenancy') . ' | ' . __('mosque::mosque.tenancy_settings')); ?>

<?php $__env->startSection('content'); ?>
<style>
    .tenancy-settings-card {
        background: white;
        border-radius: 16px;
        padding: 24px;
        box-shadow: 0 2px 12px rgba(0, 0, 0, 0.08);
        margin-bottom: 24px;
    }
    
    .tenancy-settings-header {
        display: flex;
        align-items: center;
        gap: 12px;
        margin-bottom: 20px;
        padding-bottom: 16px;
        border-bottom: 2px solid #e9ecef;
    }
    
    .tenancy-settings-header h3 {
        margin: 0;
        font-size: 20px;
        font-weight: 700;
        color: #0b1020;
        flex: 1;
    }
    
    .tenancy-settings-header .icon {
        font-size: 24px;
        color: #667eea;
    }
    
    .tenancy-form-row {
        margin-bottom: 16px;
    }
    
    .tenancy-form-row label {
        font-size: 13px;
        font-weight: 600;
        color: #374151;
        margin-bottom: 6px;
    }
    
    .tenancy-form-row .form-control {
        border-radius: 8px;
        border: 1px solid #d1d5db;
        padding: 10px 14px;
        font-size: 14px;
    }
    
    .tenancy-form-row .form-control:focus {
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }
    
    .tenancy-form-row .checkbox label {
        font-size: 14px;
        color: #374151;
        margin-left: 6px;
        cursor: pointer;
    }
    
    .tenancy-section-divider {
        height: 1px;
        background: #e9ecef;
        margin: 24px 0;
    }
    
    .tenancy-section-title {
        font-size: 16px;
        font-weight: 700;
        color: #0b1020;
        margin-bottom: 16px;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .tenancy-section-title i {
        color: #667eea;
    }
    
    .tenancy-wizard-steps {
        display: flex;
        gap: 8px;
        margin-bottom: 24px;
    }
    
    .tenancy-wizard-step {
        flex: 1;
        text-align: center;
        padding: 12px 16px;
        background: #f3f4f6;
        border-radius: 8px;
        font-size: 13px;
        font-weight: 600;
        color: #6b7280;
        cursor: pointer;
        transition: all 0.3s ease;
        border: 2px solid transparent;
    }
    
    .tenancy-wizard-step:hover {
        background: #e5e7eb;
    }
    
    .tenancy-wizard-step.active {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-color: #667eea;
    }
    
    .tenancy-wizard-step .step-number {
        display: inline-block;
        width: 28px;
        height: 28px;
        line-height: 28px;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.3);
        margin-right: 8px;
        font-weight: 700;
    }
    
    .tenancy-wizard-step:not(.active) .step-number {
        background: rgba(0, 0, 0, 0.1);
    }
    
    .tenancy-wizard-content {
        background: white;
        border-radius: 12px;
        padding: 24px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
        display: none;
    }
    
    .tenancy-wizard-content.active {
        display: block;
        animation: fadeIn 0.3s ease;
    }
    
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }
    
    .tenancy-quick-actions {
        display: flex;
        gap: 12px;
        margin-bottom: 20px;
        flex-wrap: wrap;
    }
    
    .tenancy-quick-action {
        flex: 1;
        min-width: 140px;
        padding: 16px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 12px;
        color: white;
        text-align: center;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 12px rgba(102, 126, 234, 0.25);
    }
    
    .tenancy-quick-action:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 16px rgba(102, 126, 234, 0.35);
    }
    
    .tenancy-quick-action i {
        font-size: 28px;
        display: block;
        margin-bottom: 8px;
    }
    
    .tenancy-quick-action span {
        font-size: 13px;
        font-weight: 600;
    }
    
    .tenancy-table-wrapper {
        background: white;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
        margin-top: 20px;
    }
    
    .tenancy-table-wrapper .table {
        margin: 0;
        font-size: 13px;
    }
    
    .tenancy-table-wrapper .table thead th {
        background: #f8f9fa;
        border-bottom: 2px solid #e9ecef;
        font-weight: 700;
        color: #0b1020;
        padding: 12px;
    }
    
    .tenancy-table-wrapper .table tbody td {
        padding: 12px;
        vertical-align: middle;
        border-bottom: 1px solid #e9ecef;
    }
    
    .tenancy-table-wrapper .table tbody tr:hover {
        background: #f8f9fa;
    }
    
    .tenancy-filter-bar {
        background: #f8f9fa;
        border-radius: 10px;
        padding: 16px;
        margin-bottom: 16px;
        display: flex;
        gap: 12px;
        align-items: flex-end;
        flex-wrap: wrap;
    }
    
    .tenancy-filter-bar .form-group {
        margin: 0;
        flex: 1;
        min-width: 150px;
    }
    
    .tenancy-filter-bar label {
        font-size: 12px;
        font-weight: 600;
        color: #6b7280;
        margin-bottom: 4px;
    }
    
    .tenancy-add-btn {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        border: none;
        color: white;
        padding: 10px 20px;
        border-radius: 8px;
        font-size: 13px;
        font-weight: 600;
        box-shadow: 0 4px 12px rgba(16, 185, 129, 0.25);
        transition: all 0.3s ease;
    }
    
    .tenancy-add-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 16px rgba(16, 185, 129, 0.35);
    }
</style>

<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black"><?php echo app('translator')->get('mosque::mosque.menu_tenancy'); ?></h1>
</section>

<section class="content">
    <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
        <?php echo $__env->make('mosque::tenancy.partials.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div style="margin-top:20px;">
            <!-- Quick Setup Guide -->
            <div class="tenancy-settings-card">
                <div class="tenancy-settings-header">
                    <i class="fa fa-cogs icon"></i>
                    <h3><?php echo app('translator')->get('mosque::mosque.tenancy_settings'); ?></h3>
                </div>
                
                <form id="ten_settings_form">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-sm-3">
                            <div class="tenancy-form-row">
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="tenancy_enabled" value="1" <?php if(($settings['tenancy_enabled'] ?? true)): ?> checked <?php endif; ?>>
                                        <?php echo app('translator')->get('mosque::mosque.tenancy_enabled'); ?>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="tenancy-form-row">
                                <label><?php echo app('translator')->get('mosque::mosque.tenancy_billing_mode'); ?></label>
                                <select class="form-control" name="tenancy_billing_mode">
                                    <option value="manual" <?php if(($settings['tenancy_billing_mode'] ?? 'manual')==='manual'): ?> selected <?php endif; ?>><?php echo app('translator')->get('mosque::mosque.tenancy_billing_manual'); ?></option>
                                    <option value="auto_lazy" <?php if(($settings['tenancy_billing_mode'] ?? 'manual')==='auto_lazy'): ?> selected <?php endif; ?>><?php echo app('translator')->get('mosque::mosque.tenancy_billing_auto_lazy'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="tenancy-form-row">
                                <label><?php echo app('translator')->get('mosque::mosque.tenancy_qr_ttl'); ?></label>
                                <input type="number" class="form-control" name="tenancy_qr_ttl_minutes" value="<?php echo e((int) ($settings['tenancy_qr_ttl_minutes'] ?? 43200), false); ?>">
                            </div>
                        </div>
                        <div class="col-sm-3 text-right">
                            <div class="tenancy-form-row" style="margin-top:24px;">
                                <button type="submit" class="tenancy-add-btn"><i class="fa fa-save"></i> <?php echo app('translator')->get('messages.save'); ?></button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Structure Management -->
            <div class="tenancy-settings-card">
                <div class="tenancy-settings-header">
                    <i class="fa fa-building-o icon"></i>
                    <h3><?php echo app('translator')->get('mosque::mosque.tenancy_structure'); ?></h3>
                </div>
                
                <p style="color:#6b7280;margin-bottom:20px;"><?php echo app('translator')->get('mosque::mosque.tenancy_structure_help'); ?></p>
                
                <!-- Quick Actions -->
                <div class="tenancy-quick-actions">
                    <div class="tenancy-quick-action" onclick="window.openStructModal('building')">
                        <i class="fa fa-building"></i>
                        <span><?php echo app('translator')->get('mosque::mosque.tenancy_add_building'); ?></span>
                    </div>
                    <div class="tenancy-quick-action" style="background:linear-gradient(135deg, #f59e0b 0%, #d97706 100%);box-shadow: 0 4px 12px rgba(245, 158, 11, 0.25);" onclick="window.openStructModal('floor')">
                        <i class="fa fa-layer-group"></i>
                        <span><?php echo app('translator')->get('mosque::mosque.tenancy_add_floor'); ?></span>
                    </div>
                    <div class="tenancy-quick-action" style="background:linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);box-shadow: 0 4px 12px rgba(59, 130, 246, 0.25);" onclick="window.openStructModal('room')">
                        <i class="fa fa-door-open"></i>
                        <span><?php echo app('translator')->get('mosque::mosque.tenancy_add_room'); ?></span>
                    </div>
                    <div class="tenancy-quick-action" style="background:linear-gradient(135deg, #10b981 0%, #059669 100%);box-shadow: 0 4px 12px rgba(16, 185, 129, 0.25);" onclick="window.openStructModal('seat')">
                        <i class="fa fa-bed"></i>
                        <span><?php echo app('translator')->get('mosque::mosque.tenancy_add_seat'); ?></span>
                    </div>
                </div>

                <!-- Wizard Steps -->
                <div class="tenancy-wizard-steps">
                    <div class="tenancy-wizard-step" onclick="showWizard('building')" id="step_building">
                        <span class="step-number">1</span> <?php echo app('translator')->get('mosque::mosque.tenancy_buildings'); ?>
                    </div>
                    <div class="tenancy-wizard-step" onclick="showWizard('floor')" id="step_floor">
                        <span class="step-number">2</span> <?php echo app('translator')->get('mosque::mosque.tenancy_floors'); ?>
                    </div>
                    <div class="tenancy-wizard-step" onclick="showWizard('room')" id="step_room">
                        <span class="step-number">3</span> <?php echo app('translator')->get('mosque::mosque.tenancy_rooms'); ?>
                    </div>
                    <div class="tenancy-wizard-step" onclick="showWizard('seat')" id="step_seat">
                        <span class="step-number">4</span> <?php echo app('translator')->get('mosque::mosque.tenancy_seats'); ?>
                    </div>
                </div>

                <!-- Buildings Tab -->
                <div class="tenancy-wizard-content active" id="content_building">
                    <div class="tenancy-filter-bar">
                        <div class="text-right" style="flex:1;">
                            <button type="button" class="tenancy-add-btn" id="ten_add_building"><i class="fa fa-plus"></i> <?php echo app('translator')->get('mosque::mosque.tenancy_add_building'); ?></button>
                        </div>
                    </div>
                    <div class="tenancy-table-wrapper">
                        <table class="table table-bordered table-striped" id="ten_buildings_table" style="width:100%;">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('mosque::mosque.tenancy_name'); ?></th>
                                    <th><?php echo app('translator')->get('mosque::mosque.tenancy_address'); ?></th>
                                    <th><?php echo app('translator')->get('mosque::mosque.tenancy_note'); ?></th>
                                    <th><?php echo app('translator')->get('messages.action'); ?></th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>

                <!-- Floors Tab -->
                <div class="tenancy-wizard-content" id="content_floor">
                    <div class="tenancy-filter-bar">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('mosque::mosque.tenancy_building'); ?></label>
                            <select class="form-control" id="ten_filter_floor_building"></select>
                        </div>
                        <div class="text-right" style="flex:1;">
                            <button type="button" class="tenancy-add-btn" id="ten_add_floor"><i class="fa fa-plus"></i> <?php echo app('translator')->get('mosque::mosque.tenancy_add_floor'); ?></button>
                        </div>
                    </div>
                    <div class="tenancy-table-wrapper">
                        <table class="table table-bordered table-striped" id="ten_floors_table" style="width:100%;">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('mosque::mosque.tenancy_building'); ?></th>
                                    <th><?php echo app('translator')->get('mosque::mosque.tenancy_floor'); ?></th>
                                    <th><?php echo app('translator')->get('mosque::mosque.tenancy_sort_order'); ?></th>
                                    <th><?php echo app('translator')->get('messages.action'); ?></th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>

                <!-- Rooms Tab -->
                <div class="tenancy-wizard-content" id="content_room">
                    <div class="tenancy-filter-bar">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('mosque::mosque.tenancy_building'); ?></label>
                            <select class="form-control" id="ten_filter_room_building"></select>
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('mosque::mosque.tenancy_floor'); ?></label>
                            <select class="form-control" id="ten_filter_room_floor"></select>
                        </div>
                        <div class="text-right">
                            <button type="button" class="tenancy-add-btn" id="ten_add_room"><i class="fa fa-plus"></i> <?php echo app('translator')->get('mosque::mosque.tenancy_add_room'); ?></button>
                        </div>
                    </div>
                    <div class="tenancy-table-wrapper">
                        <table class="table table-bordered table-striped" id="ten_rooms_table" style="width:100%;">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('mosque::mosque.tenancy_building'); ?></th>
                                    <th><?php echo app('translator')->get('mosque::mosque.tenancy_floor'); ?></th>
                                    <th><?php echo app('translator')->get('mosque::mosque.tenancy_room'); ?></th>
                                    <th><?php echo app('translator')->get('mosque::mosque.tenancy_type'); ?></th>
                                    <th><?php echo app('translator')->get('messages.action'); ?></th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>

                <!-- Seats Tab -->
                <div class="tenancy-wizard-content" id="content_seat">
                    <div class="tenancy-filter-bar">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('mosque::mosque.tenancy_building'); ?></label>
                            <select class="form-control" id="ten_filter_seat_building"></select>
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('mosque::mosque.tenancy_floor'); ?></label>
                            <select class="form-control" id="ten_filter_seat_floor"></select>
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('mosque::mosque.tenancy_room'); ?></label>
                            <select class="form-control" id="ten_filter_seat_room"></select>
                        </div>
                        <div class="text-right">
                            <button type="button" class="tenancy-add-btn" id="ten_add_seat"><i class="fa fa-plus"></i> <?php echo app('translator')->get('mosque::mosque.tenancy_add_seat'); ?></button>
                        </div>
                    </div>
                    <div class="tenancy-table-wrapper">
                        <table class="table table-bordered table-striped" id="ten_seats_table" style="width:100%;">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('mosque::mosque.tenancy_building'); ?></th>
                                    <th><?php echo app('translator')->get('mosque::mosque.tenancy_floor'); ?></th>
                                    <th><?php echo app('translator')->get('mosque::mosque.tenancy_room'); ?></th>
                                    <th><?php echo app('translator')->get('mosque::mosque.tenancy_seat'); ?></th>
                                    <th><?php echo app('translator')->get('mosque::mosque.tenancy_status'); ?></th>
                                    <th><?php echo app('translator')->get('messages.action'); ?></th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Templates -->
            <div class="tenancy-settings-card">
                <div class="tenancy-section-title">
                    <i class="fa fa-envelope-o"></i>
                    <?php echo app('translator')->get('mosque::mosque.tenancy_templates'); ?>
                </div>
                <div class="row">
                    <div class="col-sm-6">
                        <div class="tenancy-form-row">
                            <label><?php echo app('translator')->get('mosque::mosque.tenancy_tpl_bill_sms'); ?></label>
                            <textarea class="form-control" name="tenancy_template_bill_generated_sms" rows="3"><?php echo e($settings['tenancy_template_bill_generated_sms'] ?? '', false); ?></textarea>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="tenancy-form-row">
                            <label><?php echo app('translator')->get('mosque::mosque.tenancy_tpl_bill_whatsapp'); ?></label>
                            <textarea class="form-control" name="tenancy_template_bill_generated_whatsapp" rows="3"><?php echo e($settings['tenancy_template_bill_generated_whatsapp'] ?? '', false); ?></textarea>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6">
                        <div class="tenancy-form-row">
                            <label><?php echo app('translator')->get('mosque::mosque.tenancy_tpl_bill_email_subject'); ?></label>
                            <input class="form-control" name="tenancy_template_bill_generated_email_subject" value="<?php echo e($settings['tenancy_template_bill_generated_email_subject'] ?? '', false); ?>">
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="tenancy-form-row">
                            <label><?php echo app('translator')->get('mosque::mosque.tenancy_tpl_alloc_whatsapp'); ?></label>
                            <textarea class="form-control" name="tenancy_template_allocation_approved_whatsapp" rows="2"><?php echo e($settings['tenancy_template_allocation_approved_whatsapp'] ?? '', false); ?></textarea>
                        </div>
                    </div>
                </div>
                <div class="tenancy-form-row">
                    <label><?php echo app('translator')->get('mosque::mosque.tenancy_tpl_bill_email'); ?></label>
                    <textarea class="form-control" name="tenancy_template_bill_generated_email" rows="4"><?php echo e($settings['tenancy_template_bill_generated_email'] ?? '', false); ?></textarea>
                    <p class="help-block"><?php echo app('translator')->get('mosque::mosque.tenancy_template_tokens'); ?></p>
                </div>
            </div>
        </div>
    <?php echo $__env->renderComponent(); ?>

    <!-- Structure Modal -->
    <div class="modal fade" id="ten_struct_modal" tabindex="-1" role="dialog" aria-labelledby="tenStructModalLabel">
        <div class="modal-dialog" role="document">
            <form id="ten_struct_form">
                <?php echo csrf_field(); ?>
                <input type="hidden" id="ten_struct_type" value="">
                <input type="hidden" id="ten_struct_id" value="">
                <input type="hidden" name="_method" id="ten_struct_method" value="POST">
                <div class="modal-content" style="border-radius:12px;">
                    <div class="modal-header" style="border-bottom:1px solid #e9ecef;">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" id="tenStructModalLabel"><?php echo app('translator')->get('mosque::mosque.tenancy_structure'); ?></h4>
                    </div>
                    <div class="modal-body">
                        <div class="ten-struct-fields ten-struct-building">
                            <div class="tenancy-form-row">
                                <label><?php echo app('translator')->get('mosque::mosque.tenancy_name'); ?> *</label>
                                <input type="text" class="form-control input-sm" name="name" id="ten_building_name" placeholder="e.g., Main Building">
                            </div>
                            <div class="tenancy-form-row">
                                <label><?php echo app('translator')->get('mosque::mosque.tenancy_address'); ?></label>
                                <input type="text" class="form-control input-sm" name="address" id="ten_building_address" placeholder="e.g., 123 Mosque Street">
                            </div>
                            <div class="tenancy-form-row">
                                <label><?php echo app('translator')->get('mosque::mosque.tenancy_note'); ?></label>
                                <textarea class="form-control input-sm" name="notes" id="ten_building_notes" rows="2" placeholder="Any additional notes..."></textarea>
                            </div>
                        </div>

                        <div class="ten-struct-fields ten-struct-floor" style="display:none;">
                            <div class="tenancy-form-row">
                                <label><?php echo app('translator')->get('mosque::mosque.tenancy_building'); ?> *</label>
                                <select class="form-control input-sm" name="building_id" id="ten_floor_building_id"></select>
                            </div>
                            <div class="tenancy-form-row">
                                <label><?php echo app('translator')->get('mosque::mosque.tenancy_floor'); ?> *</label>
                                <input type="text" class="form-control input-sm" name="name_or_number" id="ten_floor_name_or_number" placeholder="e.g., 1st Floor, Ground Floor">
                            </div>
                            <div class="tenancy-form-row">
                                <label><?php echo app('translator')->get('mosque::mosque.tenancy_sort_order'); ?></label>
                                <input type="number" class="form-control input-sm" name="sort_order" id="ten_floor_sort_order" value="0" placeholder="e.g., 1, 2, 3...">
                            </div>
                        </div>

                        <div class="ten-struct-fields ten-struct-room" style="display:none;">
                            <div class="tenancy-form-row">
                                <label><?php echo app('translator')->get('mosque::mosque.tenancy_building'); ?> *</label>
                                <select class="form-control input-sm" id="ten_room_building_id"></select>
                            </div>
                            <div class="tenancy-form-row">
                                <label><?php echo app('translator')->get('mosque::mosque.tenancy_floor'); ?> *</label>
                                <select class="form-control input-sm" name="floor_id" id="ten_room_floor_id"></select>
                            </div>
                            <div class="tenancy-form-row">
                                <label><?php echo app('translator')->get('mosque::mosque.tenancy_room'); ?> *</label>
                                <input type="text" class="form-control input-sm" name="code" id="ten_room_code" placeholder="e.g., Room 101, Apartment A">
                            </div>
                            <div class="tenancy-form-row">
                                <label><?php echo app('translator')->get('mosque::mosque.tenancy_type'); ?> *</label>
                                <select class="form-control input-sm" name="type" id="ten_room_type">
                                    <option value="room"><?php echo app('translator')->get('mosque::mosque.tenancy_type_room'); ?></option>
                                    <option value="apartment"><?php echo app('translator')->get('mosque::mosque.tenancy_type_apartment'); ?></option>
                                    <option value="ward"><?php echo app('translator')->get('mosque::mosque.tenancy_type_ward'); ?></option>
                                </select>
                            </div>
                            <div class="tenancy-form-row">
                                <label><?php echo app('translator')->get('mosque::mosque.tenancy_note'); ?></label>
                                <textarea class="form-control input-sm" name="notes" id="ten_room_notes" rows="2" placeholder="Any additional notes..."></textarea>
                            </div>
                        </div>

                        <div class="ten-struct-fields ten-struct-seat" style="display:none;">
                            <div class="tenancy-form-row">
                                <label><?php echo app('translator')->get('mosque::mosque.tenancy_building'); ?> *</label>
                                <select class="form-control input-sm" id="ten_seat_building_id"></select>
                            </div>
                            <div class="tenancy-form-row">
                                <label><?php echo app('translator')->get('mosque::mosque.tenancy_floor'); ?> *</label>
                                <select class="form-control input-sm" id="ten_seat_floor_id"></select>
                            </div>
                            <div class="tenancy-form-row">
                                <label><?php echo app('translator')->get('mosque::mosque.tenancy_room'); ?> *</label>
                                <select class="form-control input-sm" name="room_id" id="ten_seat_room_id"></select>
                            </div>
                            <div class="tenancy-form-row">
                                <label><?php echo app('translator')->get('mosque::mosque.tenancy_seat'); ?> *</label>
                                <input type="text" class="form-control input-sm" name="code" id="ten_seat_code" placeholder="e.g., Bed 1, Seat A">
                            </div>
                            <div class="tenancy-form-row">
                                <label><?php echo app('translator')->get('mosque::mosque.tenancy_status'); ?> *</label>
                                <select class="form-control input-sm" name="status" id="ten_seat_status">
                                    <option value="available"><?php echo app('translator')->get('mosque::mosque.tenancy_available'); ?></option>
                                    <option value="held"><?php echo app('translator')->get('mosque::mosque.tenancy_held'); ?></option>
                                    <option value="occupied"><?php echo app('translator')->get('mosque::mosque.tenancy_occupied'); ?></option>
                                    <option value="maintenance"><?php echo app('translator')->get('mosque::mosque.tenancy_maintenance'); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer" style="border-top:1px solid #e9ecef;">
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo app('translator')->get('messages.close'); ?></button>
                        <button type="submit" class="tenancy-add-btn"><i class="fa fa-save"></i> <?php echo app('translator')->get('messages.save'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script>
    var metaBuildingsUrl = <?php echo json_encode(route('mosque.tenancy.structure.meta.buildings', [], false)) ?>;
    var metaFloorsUrl = <?php echo json_encode(route('mosque.tenancy.structure.meta.floors', [], false)) ?>;
    var metaRoomsUrl = <?php echo json_encode(route('mosque.tenancy.structure.meta.rooms', [], false)) ?>;

    var bDataUrl = <?php echo json_encode(route('mosque.tenancy.structure.buildings.data', [], false)) ?>;
    var fDataUrl = <?php echo json_encode(route('mosque.tenancy.structure.floors.data', [], false)) ?>;
    var rDataUrl = <?php echo json_encode(route('mosque.tenancy.structure.rooms.data', [], false)) ?>;
    var sDataUrl = <?php echo json_encode(route('mosque.tenancy.structure.seats.data', [], false)) ?>;

    var showUrl = {
        building: <?php echo json_encode(route('mosque.tenancy.structure.buildings.show', ['id' => 0], false)) ?>,
        floor: <?php echo json_encode(route('mosque.tenancy.structure.floors.show', ['id' => 0], false)) ?>,
        room: <?php echo json_encode(route('mosque.tenancy.structure.rooms.show', ['id' => 0], false)) ?>,
        seat: <?php echo json_encode(route('mosque.tenancy.structure.seats.show', ['id' => 0], false)) ?>
    };
    var storeUrl = {
        building: <?php echo json_encode(route('mosque.tenancy.structure.buildings.store', [], false)) ?>,
        floor: <?php echo json_encode(route('mosque.tenancy.structure.floors.store', [], false)) ?>,
        room: <?php echo json_encode(route('mosque.tenancy.structure.rooms.store', [], false)) ?>,
        seat: <?php echo json_encode(route('mosque.tenancy.structure.seats.store', [], false)) ?>
    };
    var updateUrl = {
        building: <?php echo json_encode(route('mosque.tenancy.structure.buildings.update', ['id' => 0], false)) ?>,
        floor: <?php echo json_encode(route('mosque.tenancy.structure.floors.update', ['id' => 0], false)) ?>,
        room: <?php echo json_encode(route('mosque.tenancy.structure.rooms.update', ['id' => 0], false)) ?>,
        seat: <?php echo json_encode(route('mosque.tenancy.structure.seats.update', ['id' => 0], false)) ?>
    };

    function showWizard(type) {
        $('.tenancy-wizard-step').removeClass('active');
        $('.tenancy-wizard-content').removeClass('active');
        $('#step_' + type).addClass('active');
        $('#content_' + type).addClass('active');
    }

    function openStructModalInternal(type, id) {
        id = id || 0;
        $('#ten_struct_type').val(type);
        $('#ten_struct_id').val(id);
        $('#ten_struct_method').val(id ? 'PUT' : 'POST');
        $('#ten_struct_form')[0].reset();
        $('.ten-struct-fields').hide();
        $('.ten-struct-' + type).show();

        if (type === 'building') {
            $('#tenStructModalLabel').text(id ? <?php echo json_encode(__('mosque::mosque.tenancy_edit_building'), 15, 512) ?> : <?php echo json_encode(__('mosque::mosque.tenancy_add_building'), 15, 512) ?>);
        }
        if (type === 'floor') {
            $('#tenStructModalLabel').text(id ? <?php echo json_encode(__('mosque::mosque.tenancy_edit_floor'), 15, 512) ?> : <?php echo json_encode(__('mosque::mosque.tenancy_add_floor'), 15, 512) ?>);
            loadBuildings($('#ten_floor_building_id'), <?php echo json_encode(__('mosque::mosque.tenancy_select_building'), 15, 512) ?>);
        }
        if (type === 'room') {
            $('#tenStructModalLabel').text(id ? <?php echo json_encode(__('mosque::mosque.tenancy_edit_room'), 15, 512) ?> : <?php echo json_encode(__('mosque::mosque.tenancy_add_room'), 15, 512) ?>);
            loadBuildings($('#ten_room_building_id'), <?php echo json_encode(__('mosque::mosque.tenancy_select_building'), 15, 512) ?>);
            fillSelect($('#ten_room_floor_id'), [], <?php echo json_encode(__('mosque::mosque.tenancy_select_floor'), 15, 512) ?>);
        }
        if (type === 'seat') {
            $('#tenStructModalLabel').text(id ? <?php echo json_encode(__('mosque::mosque.tenancy_edit_seat'), 15, 512) ?> : <?php echo json_encode(__('mosque::mosque.tenancy_add_seat'), 15, 512) ?>);
            loadBuildings($('#ten_seat_building_id'), <?php echo json_encode(__('mosque::mosque.tenancy_select_building'), 15, 512) ?>);
            fillSelect($('#ten_seat_floor_id'), [], <?php echo json_encode(__('mosque::mosque.tenancy_select_floor'), 15, 512) ?>);
            fillSelect($('#ten_seat_room_id'), [], <?php echo json_encode(__('mosque::mosque.tenancy_select_room'), 15, 512) ?>);
        }

        if (id) {
            var url = showUrl[type].replace(/0$/, String(id));
            $.getJSON(url).done(function (resp) {
                if (!resp || !resp.success || !resp.data) return;
                var d = resp.data;
                if (type === 'building') {
                    $('#ten_building_name').val(d.name || '');
                    $('#ten_building_address').val(d.address || '');
                    $('#ten_building_notes').val(d.notes || '');
                } else if (type === 'floor') {
                    loadBuildings($('#ten_floor_building_id'), <?php echo json_encode(__('mosque::mosque.tenancy_select_building'), 15, 512) ?>, function () {
                        $('#ten_floor_building_id').val(d.building_id || '');
                    });
                    $('#ten_floor_name_or_number').val(d.name_or_number || '');
                    $('#ten_floor_sort_order').val(d.sort_order || 0);
                } else if (type === 'room') {
                    $('#ten_room_code').val(d.code || '');
                    $('#ten_room_type').val(d.type || 'room');
                    $('#ten_room_notes').val(d.notes || '');
                    var currentBuilding = $('#ten_filter_room_building').val();
                    if (currentBuilding) {
                        $('#ten_room_building_id').val(currentBuilding).trigger('change');
                    }
                    setTimeout(function () { $('#ten_room_floor_id').val(d.floor_id || ''); }, 350);
                } else if (type === 'seat') {
                    $('#ten_seat_code').val(d.code || '');
                    $('#ten_seat_status').val(d.status || 'available');
                    var currentBuilding2 = $('#ten_filter_seat_building').val();
                    if (currentBuilding2) {
                        $('#ten_seat_building_id').val(currentBuilding2).trigger('change');
                    }
                    setTimeout(function () { $('#ten_seat_room_id').val(d.room_id || ''); }, 700);
                }
            });
        }

        $('#ten_struct_modal').modal('show');
    }

    window.openStructModal = function(type) {
        showWizard(type);
        setTimeout(function() {
            openStructModalInternal(type, 0);
        }, 100);
    };

    function escapeHtml(s) { return $('<div>').text(s || '').html(); }
    function fillSelect($sel, opts, placeholder) {
        var html = '<option value="">' + escapeHtml(placeholder || '') + '</option>';
        (opts || []).forEach(function (o) {
            html += '<option value="' + escapeHtml(o.id) + '">' + escapeHtml(o.name || '') + '</option>';
        });
        $sel.html(html);
    }

    function loadBuildings($sel, placeholder, cb) {
        $.getJSON(metaBuildingsUrl).done(function (resp) {
            var buildings = (resp && resp.buildings) ? resp.buildings : [];
            fillSelect($sel, buildings.map(function (b) { return { id: b.id, name: b.name }; }), placeholder);
            if (cb) cb(buildings);
        }).fail(function () {
            fillSelect($sel, [], placeholder);
            if (cb) cb([]);
        });
    }

    function loadFloors(buildingId, $sel, placeholder, cb) {
        if (!buildingId) { fillSelect($sel, [], placeholder); if (cb) cb([]); return; }
        $.getJSON(metaFloorsUrl, { building_id: buildingId }).done(function (resp) {
            var floors = (resp && resp.floors) ? resp.floors : [];
            fillSelect($sel, floors.map(function (f) { return { id: f.id, name: f.name_or_number }; }), placeholder);
            if (cb) cb(floors);
        }).fail(function () {
            fillSelect($sel, [], placeholder);
            if (cb) cb([]);
        });
    }

    function loadRooms(floorId, $sel, placeholder, cb) {
        if (!floorId) { fillSelect($sel, [], placeholder); if (cb) cb([]); return; }
        $.getJSON(metaRoomsUrl, { floor_id: floorId }).done(function (resp) {
            var rooms = (resp && resp.rooms) ? resp.rooms : [];
            fillSelect($sel, rooms.map(function (r) { return { id: r.id, name: r.code }; }), placeholder);
            if (cb) cb(rooms);
        }).fail(function () {
            fillSelect($sel, [], placeholder);
            if (cb) cb([]);
        });
    }

    $(function () {
        // Filter dropdowns
        loadBuildings($('#ten_filter_floor_building'), <?php echo json_encode(__('mosque::mosque.tenancy_all_buildings'), 15, 512) ?>);
        loadBuildings($('#ten_filter_room_building'), <?php echo json_encode(__('mosque::mosque.tenancy_all_buildings'), 15, 512) ?>);
        loadBuildings($('#ten_filter_seat_building'), <?php echo json_encode(__('mosque::mosque.tenancy_all_buildings'), 15, 512) ?>);
        fillSelect($('#ten_filter_room_floor'), [], <?php echo json_encode(__('mosque::mosque.tenancy_all_floors'), 15, 512) ?>);
        fillSelect($('#ten_filter_seat_floor'), [], <?php echo json_encode(__('mosque::mosque.tenancy_all_floors'), 15, 512) ?>);
        fillSelect($('#ten_filter_seat_room'), [], <?php echo json_encode(__('mosque::mosque.tenancy_all_rooms'), 15, 512) ?>);

        $('#ten_filter_floor_building').on('change', function () {
            if (window.tenFloorsTable) window.tenFloorsTable.ajax.reload();
        });

        $('#ten_filter_room_building').on('change', function () {
            loadFloors($(this).val(), $('#ten_filter_room_floor'), <?php echo json_encode(__('mosque::mosque.tenancy_all_floors'), 15, 512) ?>);
            if (window.tenRoomsTable) window.tenRoomsTable.ajax.reload();
        });
        $('#ten_filter_room_floor').on('change', function () {
            if (window.tenRoomsTable) window.tenRoomsTable.ajax.reload();
        });

        $('#ten_filter_seat_building').on('change', function () {
            var b = $(this).val();
            loadFloors(b, $('#ten_filter_seat_floor'), <?php echo json_encode(__('mosque::mosque.tenancy_all_floors'), 15, 512) ?>);
            fillSelect($('#ten_filter_seat_room'), [], <?php echo json_encode(__('mosque::mosque.tenancy_all_rooms'), 15, 512) ?>);
            if (window.tenSeatsTable) window.tenSeatsTable.ajax.reload();
        });
        $('#ten_filter_seat_floor').on('change', function () {
            var f = $(this).val();
            loadRooms(f, $('#ten_filter_seat_room'), <?php echo json_encode(__('mosque::mosque.tenancy_all_rooms'), 15, 512) ?>);
            if (window.tenSeatsTable) window.tenSeatsTable.ajax.reload();
        });
        $('#ten_filter_seat_room').on('change', function () {
            if (window.tenSeatsTable) window.tenSeatsTable.ajax.reload();
        });

        function defaultButtons() {
            return [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ];
        }

        window.tenBuildingsTable = $('#ten_buildings_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: bDataUrl,
            dom: 'lBfrtip',
            buttons: defaultButtons(),
            columns: [
                { data: 'name', name: 'name' },
                { data: 'address', name: 'address' },
                { data: 'notes', name: 'notes' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ]
        });

        window.tenFloorsTable = $('#ten_floors_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: fDataUrl,
                data: function (d) { d.building_id = $('#ten_filter_floor_building').val(); }
            },
            dom: 'lBfrtip',
            buttons: defaultButtons(),
            columns: [
                { data: 'building', name: 'building' },
                { data: 'name_or_number', name: 'name_or_number' },
                { data: 'sort_order', name: 'sort_order' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ]
        });

        window.tenRoomsTable = $('#ten_rooms_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: rDataUrl,
                data: function (d) {
                    d.building_id = $('#ten_filter_room_building').val();
                    d.floor_id = $('#ten_filter_room_floor').val();
                }
            },
            dom: 'lBfrtip',
            buttons: defaultButtons(),
            columns: [
                { data: 'building', name: 'building' },
                { data: 'floor', name: 'floor' },
                { data: 'code', name: 'code' },
                { data: 'type', name: 'type' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ]
        });

        window.tenSeatsTable = $('#ten_seats_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: sDataUrl,
                data: function (d) {
                    d.building_id = $('#ten_filter_seat_building').val();
                    d.floor_id = $('#ten_filter_seat_floor').val();
                    d.room_id = $('#ten_filter_seat_room').val();
                }
            },
            dom: 'lBfrtip',
            buttons: defaultButtons(),
            columns: [
                { data: 'building', name: 'building' },
                { data: 'floor', name: 'floor' },
                { data: 'room', name: 'room' },
                { data: 'code', name: 'code' },
                { data: 'status', name: 'status' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ]
        });

        $('#ten_settings_form').on('submit', function (e) {
            e.preventDefault();
            $.ajax({
                method: 'POST',
                url: '<?php echo e(route("mosque.tenancy.settings.update", [], false), false); ?>',
                data: $(this).serialize(),
                dataType: 'json',
                success: function (resp) {
                    if (resp && resp.success) {
                        toastr.success(resp.msg || <?php echo json_encode(__('mosque::mosque.tenancy_success'), 15, 512) ?>);
                    } else {
                        toastr.error((resp && resp.msg) ? resp.msg : <?php echo json_encode(__('messages.something_went_wrong'), 15, 512) ?>);
                    }
                },
                error: function () { toastr.error(<?php echo json_encode(__('messages.something_went_wrong'), 15, 512) ?>); }
            });
        });


        $('#ten_room_building_id').on('change', function () {
            loadFloors($(this).val(), $('#ten_room_floor_id'), <?php echo json_encode(__('mosque::mosque.tenancy_select_floor'), 15, 512) ?>);
        });

        $('#ten_seat_building_id').on('change', function () {
            loadFloors($(this).val(), $('#ten_seat_floor_id'), <?php echo json_encode(__('mosque::mosque.tenancy_select_floor'), 15, 512) ?>);
            fillSelect($('#ten_seat_room_id'), [], <?php echo json_encode(__('mosque::mosque.tenancy_select_room'), 15, 512) ?>);
        });
        $('#ten_seat_floor_id').on('change', function () {
            loadRooms($(this).val(), $('#ten_seat_room_id'), <?php echo json_encode(__('mosque::mosque.tenancy_select_room'), 15, 512) ?>);
        });

        $('#ten_add_building').on('click', function () { openStructModalInternal('building', 0); });
        $('#ten_add_floor').on('click', function () { openStructModalInternal('floor', 0); });
        $('#ten_add_room').on('click', function () { openStructModalInternal('room', 0); });
        $('#ten_add_seat').on('click', function () { openStructModalInternal('seat', 0); });

        $(document).on('click', '.ten-struct-edit', function () {
            openStructModalInternal($(this).data('type'), $(this).data('id'));
        });

        $('#ten_struct_form').on('submit', function (e) {
            e.preventDefault();
            var type = $('#ten_struct_type').val();
            var id = parseInt($('#ten_struct_id').val() || '0', 10);
            var url = id ? updateUrl[type].replace(/0$/, String(id)) : storeUrl[type];

            var $form = $(this);
            $form.find('.ten-struct-fields :input').prop('disabled', true);
            $form.find('.ten-struct-fields:visible :input').prop('disabled', false);

            $.ajax({
                method: 'POST',
                url: url,
                data: $form.serialize(),
                dataType: 'json',
                success: function (resp) {
                    if (resp && resp.success) {
                        toastr.success(resp.msg || <?php echo json_encode(__('mosque::mosque.tenancy_success'), 15, 512) ?>);
                        $('#ten_struct_modal').modal('hide');
                        if (type === 'building') window.tenBuildingsTable.ajax.reload();
                        if (type === 'floor') window.tenFloorsTable.ajax.reload();
                        if (type === 'room') window.tenRoomsTable.ajax.reload();
                        if (type === 'seat') window.tenSeatsTable.ajax.reload();
                    } else {
                        toastr.error((resp && resp.msg) ? resp.msg : <?php echo json_encode(__('messages.something_went_wrong'), 15, 512) ?>);
                    }
                },
                error: function (xhr) {
                    var msg = <?php echo json_encode(__('messages.something_went_wrong'), 15, 512) ?>;
                    if (xhr && xhr.responseJSON) {
                        if (xhr.responseJSON.errors) {
                            var k = Object.keys(xhr.responseJSON.errors)[0];
                            if (k && xhr.responseJSON.errors[k] && xhr.responseJSON.errors[k][0]) msg = xhr.responseJSON.errors[k][0];
                        }
                        if (xhr.responseJSON.msg) msg = xhr.responseJSON.msg;
                    }
                    toastr.error(msg);
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('mosque::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/procharmate/public_html/serial.procharmate.com/Modules/Mosque/Providers/../Resources/views/tenancy/settings.blade.php ENDPATH**/ ?>