<div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                    aria-hidden="true">&times;</span></button>
            <h4 class="modal-title"><?php echo app('translator')->get('advancedreports::lang.stock_report'); ?> - <?php echo e($product->name, false); ?></h4>
        </div>
        <div class="modal-body">

            <!-- Product Basic Info -->
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title"><?php echo app('translator')->get('sale.product'); ?> <?php echo app('translator')->get('advancedreports::lang.product_info'); ?></h3>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <table class="table table-condensed">
                                        <tr>
                                            <th><?php echo app('translator')->get('product.sku'); ?>:</th>
                                            <td><?php echo e($product->sku, false); ?></td>
                                        </tr>
                                        <tr>
                                            <th><?php echo app('translator')->get('sale.product'); ?>:</th>
                                            <td><?php echo e($product->name, false); ?></td>
                                        </tr>
                                        <tr>
                                            <th><?php echo app('translator')->get('category.category'); ?>:</th>
                                            <td><?php echo e($category->name ?? 'N/A', false); ?></td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="col-md-6">
                                    <table class="table table-condensed">
                                        <tr>
                                            <th><?php echo app('translator')->get('product.unit'); ?>:</th>
                                            <td><?php echo e($unit_name ?? 'N/A', false); ?></td>
                                        </tr>
                                        <tr>
                                            <th><?php echo app('translator')->get('lang_v1.type'); ?>:</th>
                                            <td><?php echo e(ucfirst($product->type), false); ?></td>
                                        </tr>
                                        <tr>
                                            <th><?php echo app('translator')->get('sale.status'); ?>:</th>
                                            <td>
                                                <?php if($product->enable_stock == 1): ?>
                                                <span
                                                    class="label label-success"><?php echo app('translator')->get('advancedreports::lang.active'); ?></span>
                                                <?php else: ?>
                                                <span
                                                    class="label label-default"><?php echo app('translator')->get('advancedreports::lang.inactive'); ?></span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Stock Details by Location -->
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title"><?php echo app('translator')->get('advancedreports::lang.current_stock'); ?> <?php echo app('translator')->get('lang_v1.by'); ?>
                                <?php echo app('translator')->get('purchase.business_location'); ?></h3>
                        </div>
                        <div class="box-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th><?php echo app('translator')->get('lang_v1.variation'); ?></th>
                                            <th><?php echo app('translator')->get('purchase.business_location'); ?></th>
                                            <th><?php echo app('translator')->get('advancedreports::lang.current_stock'); ?></th>
                                            <th><?php echo app('translator')->get('lang_v1.purchase_price'); ?></th>
                                            <th><?php echo app('translator')->get('advancedreports::lang.selling_price'); ?></th>
                                            <th><?php echo app('translator')->get('advancedreports::lang.stock_value_purchase'); ?></th>
                                            <th><?php echo app('translator')->get('advancedreports::lang.stock_value_sale'); ?></th>
                                            <th><?php echo app('translator')->get('advancedreports::lang.potential_profit'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $total_stock_value_purchase = 0;
                                        $total_stock_value_sale = 0;
                                        $total_potential_profit = 0;
                                        $total_current_stock = 0;
                                        ?>

                                        <?php $__empty_1 = true; $__currentLoopData = $stockData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variationData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php $__empty_2 = true; $__currentLoopData = $variationData['locations']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locationData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                        <?php
                                        $variation = $variationData['variation'];
                                        $current_stock = $locationData['current_stock'];
                                        $purchase_price = $locationData['purchase_price'];
                                        $selling_price = $locationData['selling_price'];
                                        $stock_value_purchase = $current_stock * $purchase_price;
                                        $stock_value_sale = $current_stock * $selling_price;
                                        $potential_profit = $stock_value_sale - $stock_value_purchase;

                                        $total_stock_value_purchase += $stock_value_purchase;
                                        $total_stock_value_sale += $stock_value_sale;
                                        $total_potential_profit += $potential_profit;
                                        $total_current_stock += $current_stock;
                                        ?>

                                        <tr>
                                            <td>
                                                <?php echo e($variation->name && $variation->name != 'DUMMY' ? $variation->name :
                                                'Default', false); ?>

                                                <?php if($variation->sub_sku): ?>
                                                <br><small class="text-muted"><?php echo e($variation->sub_sku, false); ?></small>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($locationData['business_location']->name, false); ?></td>
                                            <td
                                                class="<?php echo e($current_stock <= 0 ? 'text-danger' : ($current_stock <= 10 ? 'text-warning' : ''), false); ?>">
                                                <?php echo e(number_format($current_stock, 2), false); ?> <?php echo e($unit_name, false); ?>

                                            </td>
                                            <td class="text-right">
                                                <span class="display_currency" data-currency_symbol="true"><?php echo e(number_format($purchase_price, 2), false); ?></span>
                                            </td>
                                            <td class="text-right">
                                                <span class="display_currency" data-currency_symbol="true"><?php echo e(number_format($selling_price, 2), false); ?></span>
                                            </td>
                                            <td class="text-right">
                                                <span class="display_currency" data-currency_symbol="true"><?php echo e(number_format($stock_value_purchase, 2), false); ?></span>
                                            </td>
                                            <td class="text-right">
                                                <span class="display_currency" data-currency_symbol="true"><?php echo e(number_format($stock_value_sale, 2), false); ?></span>
                                            </td>
                                            <td
                                                class="text-right <?php echo e($potential_profit >= 0 ? 'text-success' : 'text-danger', false); ?>">
                                                <span class="display_currency" data-currency_symbol="true"><?php echo e(number_format($potential_profit, 2), false); ?></span>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                        <tr>
                                            <td><?php echo e($variationData['variation']->name &&
                                                $variationData['variation']->name != 'DUMMY' ?
                                                $variationData['variation']->name : 'Default', false); ?></td>
                                            <td colspan="7" class="text-center text-muted">
                                                <?php echo app('translator')->get('lang_v1.no_data_found'); ?></td>
                                        </tr>
                                        <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="8" class="text-center text-muted">
                                                <?php echo app('translator')->get('lang_v1.no_data_found'); ?></td>
                                        </tr>
                                        <?php endif; ?>
                                    </tbody>
                                    <tfoot>
                                        <tr class="bg-gray">
                                            <td colspan="2"><strong><?php echo app('translator')->get('sale.total'); ?>:</strong></td>
                                            <td><strong><?php echo e(number_format($total_current_stock, 2), false); ?> <?php echo e($unit->short_name ?? 'units', false); ?></strong></td>
                                            <td></td>
                                            <td></td>
                                            <td class="text-right">
                                                <strong><span class="display_currency" data-currency_symbol="true"><?php echo e(number_format($total_stock_value_purchase, 2), false); ?></span></strong>
                                            </td>
                                            <td class="text-right">
                                                <strong><span class="display_currency" data-currency_symbol="true"><?php echo e(number_format($total_stock_value_sale, 2), false); ?></span></strong>
                                            </td>
                                            <td
                                                class="text-right <?php echo e($total_potential_profit >= 0 ? 'text-success' : 'text-danger', false); ?>">
                                                <strong><span class="display_currency" data-currency_symbol="true"><?php echo e(number_format($total_potential_profit, 2), false); ?></span></strong>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo app('translator')->get('messages.close'); ?></button>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function(){
    __currency_convert_recursively($('.stock_modal'));
  });
</script><?php /**PATH /home/procharmate/public_html/serial.procharmate.com/Modules/AdvancedReports/Resources/views/stock/show.blade.php ENDPATH**/ ?>