
    <?php
        $title = __('purchase.add_payment');
    ?>
<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>

    <section class="content-header">
        <h1><?php echo e($title, false); ?></h1>
    </section>
    <!-- Main content -->
    <section class="content no-print">

        <div class="row">
            <div class="col-md-12 col-sm-12">

                <?php $__env->startComponent('components.widget', ['class' => 'box-solid']); ?>

                    <div class="row">

                        <div class="col-sm-4">
                            <div class="form-group">
                                <?php echo Form::label('select_location_id', __('Location Name') . ':*'); ?>

                                <div class="input-group" style="width: 100%;margin-bottom: 4px">
                                    <?php echo Form::hidden('location_id', $default_location->id ?? null , ['id' => 'location_id', 'data-receipt_printer_type' => !empty($default_location->receipt_printer_type) ? $default_location->receipt_printer_type : 'browser', 'data-default_payment_accounts' => $default_location->default_payment_accounts ?? '']); ?>

                                    
                                    <?php if(count($business_locations) > 1): ?>
                                        <div style="margin-bottom: 5px;">
                                            <?php echo Form::select('select_location_id', $business_locations, $default_location->id ?? null , ['class' => 'form-control input-sm', 'id' => 'select_location_id', 'required', 'autofocus'], $bl_attributes); ?>

                                        </div>
                                    <?php else: ?>
                                        <?php echo e($default_location->name, false); ?>

                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>

                        <div class="col-sm-4">
                            <div class="form-group">
                                <?php echo Form::label('contact_id', __('Contact Name') . ':*'); ?>

                                <div class="input-group" style="margin-bottom: 4px">
                                    <span class="input-group-addon">
                                        <i class="fa fa-user"></i>
                                    </span>
                                    <?php echo Form::select('contact_id', ['' => 'Please Select'] + $all_contact, null, ['class' => 'getContact form-control select2', 'id'=>'getContact', 'required']); ?>

                                </div>
                            </div>
                        </div>

                        <div class="col-sm-4">
                            <div class="form-group">
                                <?php echo Form::label('due_payment_type', __('Type') . ':*'); ?>

                                <div class="input-group" style="margin-bottom: 4px">
                                    <span class="input-group-addon">
                                        <i class="fa fa-user"></i>
                                    </span>
                                    <?php echo Form::select('due_payment_type', ['purchase' => 'Purchase','purchase_return' => 'Purchase eturn','sell' => 'Sell','sell_return'=>'Sell Return'], 'sell', ['class' => 'due_payment_type form-control select2', 'id'=>'due_payment_type', 'required']); ?>

                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="contact_form_html">

                            </div>
                            
                        </div>
                    </div>

                <?php echo $__env->renderComponent(); ?>

            </div>
        </div>

    </section>

    <!-- This will be printed -->
    <section class="invoice print_section" id="receipt_section"></section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>

	<script src="<?php echo e(asset('js/pos.js?v=' . $asset_v), false); ?>"></script>
	<script src="<?php echo e(asset('js/product.js?v=' . $asset_v), false); ?>"></script>
	<script src="<?php echo e(asset('js/opening_stock.js?v=' . $asset_v), false); ?>"></script>

	<!-- Call restaurant module if defined -->
    <?php if(in_array('tables' ,$enabled_modules) || in_array('modifiers' ,$enabled_modules) || in_array('service_staff' ,$enabled_modules)): ?>
    	<script src="<?php echo e(asset('js/restaurant.js?v=' . $asset_v), false); ?>"></script>
    <?php endif; ?>

    <script type="text/javascript">


        window.addEventListener('afterprint', function() {
            location.reload();
        });
	

    	$(document).ready( function() {

    		$('.paid_on').datetimepicker({
                format: moment_date_format + ' ' + moment_time_format,
                ignoreReadonly: true,
            });

            
            $(document).on('change', 'select.getContact, select#select_location_id, #due_payment_type', function(e) {

                var contact_id = $('.getContact').val();
				var duePaymentType =  $('#due_payment_type').val();
				var location_id =  $('#location_id').val();

                if (!location_id) {
                    return false;
                }
                if (!contact_id) {
                    return false;
                }

				$.ajax({

					method: 'get',
                    url: '/payments/pay-contact-due-form/'+contact_id+'?type=' + duePaymentType + '&location_id=' + location_id,
					dataType: 'html',
					success: function(result) {

             
		
                        $('.contact_form_html').html(result);
                        __currency_convert_recursively($('.contact_form_html'));
                        
                        $('#paid_on').datetimepicker({
                            format: moment_date_format + ' ' + moment_time_format,
                            ignoreReadonly: true,
                        });

                        $(".contact_form_html").find('.select2').each( function(){
                            $(this).select2();
                        });

                        $('.contact_form_html').find('form#pay_contact_due_form_extra').validate();

					},

				});

            });



            $(document).on('submit', 'form#pay_contact_due_form_extra', function(e){

                // postPayContactDueForm
                e.preventDefault();

                var is_valid = true;

                // var payment_type = $('#pay_contact_due_form_extra .payment_types_dropdown').val();
                // console.log(payment_type);
                // var denomination_for_payment_types = JSON.parse($('#pay_contact_due_form_extra .enable_cash_denomination_for_payment_methods').val());
                // if (denomination_for_payment_types.includes(payment_type) && $('#pay_contact_due_form_extra .is_strict').length && $('#pay_contact_due_form_extra .is_strict').val() === '1' ) {
                //     var payment_amount = __read_number($('#pay_contact_due_form_extra .payment_amount'));
                //     var total_denomination = $('#pay_contact_due_form_extra').find('input.denomination_total_amount').val();
                //     if (payment_amount != total_denomination ) {
                //         is_valid = false;
                //     }
                // }



                $('#pay_contact_due_form_extra').find('button[type="submit"]').attr('disabled', false);

                if (!is_valid) {
                    $('#pay_contact_due_form_extra').find('.cash_denomination_error').removeClass('hide');
                    return false;
                } else {
                    $('#pay_contact_due_form_extra').find('.cash_denomination_error').addClass('hide');


                    var submit_form = $('form#pay_contact_due_form_extra');

                    var url = submit_form.attr('action');
                    var data = submit_form.serialize();

                    $.ajax({
                        method: 'POST',
                        url: url,
                        data: data,
                        dataType: 'json',
                        success: function(result) {

                            if (result.success == 1) {

                                toastr.success(result.msg);


                                var title = document.title;
                                if (typeof result.print_title != 'undefined') {
                                    document.title = result.print_title;
                                }

                                //If printer type browser then print content
                                $('#receipt_section').html(result.html_content);
                                __currency_convert_recursively($('#receipt_section'));
                                __print_receipt('receipt_section');

                                setTimeout(function() {
                                    document.title = title;
                                }, 1200);


                            }else {

                                // window.location = result.redirect_url ;
                                toastr.error(result.msg);


                            }

                        },
                    });


                }



            })


    	});
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/procharmate/public_html/serial.procharmate.com/resources/views/transaction_payment/create.blade.php ENDPATH**/ ?>