<?php $__env->startSection('title', __('WhatsApp Bot')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1><?php echo app('translator')->get('whatsappbot::lang.whatsapp_bot'); ?>
        <small><?php echo app('translator')->get('whatsappbot::lang.manage_whatsapp_bot'); ?></small>
    </h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <!-- Configuration Card -->
        <div class="col-md-6">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        <i class="fa fa-cog"></i> <?php echo app('translator')->get('whatsappbot::lang.configuration'); ?>
                    </h3>
                </div>
                <div class="box-body">
                    <table class="table table-striped">
                        <tr>
                            <td><strong><?php echo app('translator')->get('whatsappbot::lang.api_endpoint'); ?>:</strong></td>
                            <td><?php echo e(config('whatsappbot.nodeurl'), false); ?></td>
                        </tr>
                        <tr>
                            <td><strong><?php echo app('translator')->get('whatsappbot::lang.webhook_url'); ?>:</strong></td>
                            <td>
                                <code><?php echo e(url('/api/webhook/whatsapp'), false); ?></code>
                                <button class="btn btn-xs btn-info" onclick="copyToClipboard('<?php echo e(url('/api/webhook/whatsapp'), false); ?>')">
                                    <i class="fa fa-copy"></i> <?php echo app('translator')->get('whatsappbot::lang.copy'); ?>
                                </button>
                            </td>
                        </tr>
                        <tr>
                            <td><strong><?php echo app('translator')->get('whatsappbot::lang.status'); ?>:</strong></td>
                            <td>
                                <?php if(config('whatsappbot.token')): ?>
                                    <span class="label label-success">
                                        <i class="fa fa-check"></i> <?php echo app('translator')->get('whatsappbot::lang.configured'); ?>
                                    </span>
                                <?php else: ?>
                                    <span class="label label-danger">
                                        <i class="fa fa-times"></i> <?php echo app('translator')->get('whatsappbot::lang.not_configured'); ?>
                                    </span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <td><strong><?php echo app('translator')->get('whatsappbot::lang.business_phone'); ?>:</strong></td>
                            <td>
                                <?php if($business_phone): ?>
                                    <?php echo e($business_phone, false); ?>

                                <?php else: ?>
                                    <span class="text-warning">
                                        <i class="fa fa-exclamation-triangle"></i> <?php echo app('translator')->get('whatsappbot::lang.no_phone_configured'); ?>
                                    </span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <!-- Test Message Card -->
        <div class="col-md-6">
            <div class="box box-success">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        <i class="fa fa-paper-plane"></i> <?php echo app('translator')->get('whatsappbot::lang.send_test_message'); ?>
                    </h3>
                </div>
                <form id="test-message-form">
                    <div class="box-body">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('whatsappbot::lang.phone_number'); ?></label>
                            <input type="text" name="phone" class="form-control" 
                                   placeholder="+2348012345678" required>
                            <p class="help-block"><?php echo app('translator')->get('whatsappbot::lang.phone_help'); ?></p>
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('whatsappbot::lang.message'); ?></label>
                            <textarea name="message" class="form-control" rows="4" 
                                      placeholder="<?php echo app('translator')->get('whatsappbot::lang.message_placeholder'); ?>" required></textarea>
                        </div>
                    </div>
                    <div class="box-footer">
                        <button type="submit" class="btn btn-success">
                            <i class="fa fa-paper-plane"></i> <?php echo app('translator')->get('whatsappbot::lang.send'); ?>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Available Commands Card -->
    <div class="row">
        <div class="col-md-12">
            <div class="box box-info">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        <i class="fa fa-list"></i> <?php echo app('translator')->get('whatsappbot::lang.available_commands'); ?>
                    </h3>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h4><i class="fa fa-shopping-cart"></i> <?php echo app('translator')->get('whatsappbot::lang.sales_queries'); ?></h4>
                            <ul class="list-unstyled">
                                <li><code>What's today's sales?</code></li>
                                <li><code>Show yesterday's sales</code></li>
                                <li><code>This week's sales</code></li>
                                <li><code>This month's sales</code></li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h4><i class="fa fa-money"></i> <?php echo app('translator')->get('whatsappbot::lang.profit_queries'); ?></h4>
                            <ul class="list-unstyled">
                                <li><code>What's today's profit?</code></li>
                                <li><code>Yesterday's profit</code></li>
                                <li><code>This week's profit</code></li>
                                <li><code>This month's profit</code></li>
                            </ul>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <h4><i class="fa fa-bar-chart"></i> <?php echo app('translator')->get('whatsappbot::lang.reports'); ?></h4>
                            <ul class="list-unstyled">
                                <li><code>Send report</code></li>
                                <li><code>Full report</code></li>
                                <li><code>Top products</code></li>
                                <li><code>Best selling items</code></li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h4><i class="fa fa-question-circle"></i> <?php echo app('translator')->get('whatsappbot::lang.help'); ?></h4>
                            <ul class="list-unstyled">
                                <li><code>Help</code></li>
                                <li><code>Commands</code></li>
                                <li><code>What can you do?</code></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Setup Instructions -->
    <div class="row">
        <div class="col-md-12">
            <div class="box box-warning collapsed-box">
                <div class="box-header with-border">
                    <h3 class="box-title">
                        <i class="fa fa-book"></i> <?php echo app('translator')->get('whatsappbot::lang.setup_instructions'); ?>
                    </h3>
                    <div class="box-tools pull-right">
                        <button type="button" class="btn btn-box-tool" data-widget="collapse">
                            <i class="fa fa-plus"></i>
                        </button>
                    </div>
                </div>
                <div class="box-body">
                    <ol>
                        <li>
                            <strong><?php echo app('translator')->get('whatsappbot::lang.step1'); ?>:</strong>
                            <?php echo app('translator')->get('whatsappbot::lang.step1_desc'); ?>
                        </li>
                        <li>
                            <strong><?php echo app('translator')->get('whatsappbot::lang.step2'); ?>:</strong>
                            <?php echo app('translator')->get('whatsappbot::lang.step2_desc'); ?>
                        </li>
                        <li>
                            <strong><?php echo app('translator')->get('whatsappbot::lang.step3'); ?>:</strong>
                            <?php echo app('translator')->get('whatsappbot::lang.step3_desc'); ?>
                            <code><?php echo e(url('/api/webhook/whatsapp'), false); ?></code>
                        </li>
                        <li>
                            <strong><?php echo app('translator')->get('whatsappbot::lang.step4'); ?>:</strong>
                            <?php echo app('translator')->get('whatsappbot::lang.step4_desc'); ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

</section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script type="text/javascript" data-cfasync="false">
    // Cache buster: v1.4 - Use web route instead of API route
    var WHATSAPP_TEST_URL = '<?php echo e(route("whatsappbot.send-test"), false); ?>';
    
    console.log('WhatsApp Test URL:', WHATSAPP_TEST_URL);
    
    $(document).ready(function() {
        // Handle test message form submission
        $('#test-message-form').on('submit', function(e) {
            e.preventDefault();
            
            var phone = $('input[name="phone"]').val();
            var message = $('textarea[name="message"]').val();
            
            $.ajax({
                url: WHATSAPP_TEST_URL,
                type: 'POST',
                data: {
                    phone: phone,
                    message: message,
                    _token: '<?php echo e(csrf_token(), false); ?>'
                },
                success: function(response) {
                    toastr.success('<?php echo app('translator')->get("whatsappbot::lang.test_message_sent"); ?>');
                    $('#test-message-form')[0].reset();
                },
                error: function(xhr) {
                    console.error('Error:', xhr.status, xhr.statusText);
                    console.error('URL attempted:', WHATSAPP_TEST_URL);
                    var error = xhr.responseJSON ? xhr.responseJSON.message : '<?php echo app('translator')->get("whatsappbot::lang.test_message_failed"); ?>';
                    toastr.error(error);
                }
            });
        });
    });
    
    function copyToClipboard(text) {
        var temp = $('<input>');
        $('body').append(temp);
        temp.val(text).select();
        document.execCommand('copy');
        temp.remove();
        toastr.success('<?php echo app('translator')->get("whatsappbot::lang.copied_to_clipboard"); ?>');
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/procharmate/public_html/serial.procharmate.com/Modules/WhatsAppBot/Resources/views/index.blade.php ENDPATH**/ ?>